/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.gallery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.AbstractProViewPart20141031;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryChangedListener;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.CategorizedGalleryViewer;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.gallery.GalleryPlugin;
import org.xmind.ui.internal.gallery.Messages;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

public class GalleryView
extends AbstractProViewPart20141031
implements IGalleryChangedListener {
    private Composite container;
    private ClipArtViewer viewer;
    private Control statusArea;
    private Control loadingIndicator;
    private MenuManager contextMenu;

    protected String getFeatureKey() {
        return "ClipArtView";
    }

    public void doCreatePartControl(Composite parent) {
        VerifyUI20141031.getUsageDataCollector().increase("ShowClipArtCount");
        this.container = new Composite(parent, 0);
        this.createDropTarget((Control)this.container);
        this.contextMenu = new MenuManager("#PopupMenu");
        this.container.setMenu(this.contextMenu.createContextMenu((Control)this.container));
        this.contextMenu.add((IContributionItem)new Separator("group.edit"));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.container.setLayout((Layout)layout);
        this.viewer = new ClipArtViewer();
        EditDomain domain = new EditDomain();
        domain.installTool("select tool", (ITool)new GallerySelectTool());
        this.viewer.setEditDomain(domain);
        this.viewer.setContentProvider((IContentProvider)new GalleryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GalleryLabelProvider());
        Properties properties = this.viewer.getProperties();
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(72, 72));
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout().align(1, 1));
        properties.set("org.xmind.ui.gallery.singleClickToOpen", true);
        this.viewer.createControl(this.container, 64);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setInput(GalleryCore.getInstance());
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                GalleryView.this.insertImage(event.getSelection());
            }
        });
        this.statusArea = new Composite(this.container, 0);
        this.statusArea.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout statusAreaLayout = new GridLayout();
        statusAreaLayout.marginWidth = 0;
        statusAreaLayout.marginHeight = 0;
        statusAreaLayout.verticalSpacing = 0;
        statusAreaLayout.horizontalSpacing = 0;
        ((Composite)this.statusArea).setLayout((Layout)statusAreaLayout);
        Label separator = new Label((Composite)this.statusArea, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false));
        this.loadingIndicator = new Composite((Composite)this.statusArea, 0);
        this.loadingIndicator.setLayoutData((Object)new GridData(4, 4, true, true));
        RowLayout loadingLayout = new RowLayout(256);
        loadingLayout.marginTop = 1;
        loadingLayout.marginBottom = 1;
        loadingLayout.center = true;
        ((Composite)this.loadingIndicator).setLayout((Layout)loadingLayout);
        Label loadingLabel = new Label((Composite)this.loadingIndicator, 16448);
        loadingLabel.setText(Messages.GalleryView_LoadingMore_Message);
        this.statusArea.setVisible(false);
        ((GridData)this.statusArea.getLayoutData()).exclude = true;
        this.getSite().registerContextMenu(this.contextMenu, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GalleryCore.getInstance().addGalleryChangedlistener(this);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                GalleryCore.getInstance().load();
            }
        });
    }

    private void toggleStatusArea(boolean visible, boolean failed) {
        if (this.statusArea == null || this.statusArea.isDisposed()) {
            return;
        }
        this.statusArea.setVisible(visible);
        ((GridData)this.statusArea.getLayoutData()).exclude = !visible;
        this.loadingIndicator.setVisible(!failed);
        ((GridData)this.loadingIndicator.getLayoutData()).exclude = failed;
        this.container.layout(true, true);
    }

    private void insertImage(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IGraphicalEditorPage page;
            IEditorPart editor;
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<String> paths = new ArrayList<String>(ss.size());
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof LocalGalleryItem) {
                    paths.add(((LocalGalleryItem)o).getFile().getAbsolutePath());
                }
                if (o instanceof DownloadedGalleryItem) {
                    paths.add(((DownloadedGalleryItem)o).getPath());
                }
                ++n2;
            }
            if (!paths.isEmpty() && (editor = this.getSite().getPage().getActiveEditor()) instanceof IGraphicalEditor && (page = ((IGraphicalEditor)editor).getActivePageInstance()) != null) {
                page.getEditDomain().handleRequest(new Request("add_image").setViewer((IViewer)page.getViewer()).setParameter("paths", (Object)paths.toArray(new String[paths.size()])));
            }
        }
    }

    private void createDragSource(Control control) {
        final DragSource dragSource = new DragSource(control, 1);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
            }
        });
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){
            String[] sourceFiles;

            public void dragStart(DragSourceEvent event) {
                this.sourceFiles = this.getSelectedFiles();
                if (this.sourceFiles.length == 0) {
                    event.doit = false;
                }
            }

            private String[] getSelectedFiles() {
                ISelection selection = GalleryView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ArrayList<String> files = new ArrayList<String>(ss.size());
                    for (Object o : ss.toList()) {
                        if (o instanceof LocalGalleryItem) {
                            files.add(((LocalGalleryItem)o).getFile().getAbsolutePath());
                        }
                        if (!(o instanceof DownloadedGalleryItem)) continue;
                        files.add(((DownloadedGalleryItem)o).getPath());
                    }
                    return files.toArray(new String[files.size()]);
                }
                return new String[0];
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.sourceFiles;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private void createDropTarget(Control control) {
        final DropTarget dropTarget = new DropTarget(control, 3);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dropTarget.dispose();
            }
        });
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void drop(DropTargetEvent event) {
                String[] cfr_ignored_0 = (String[])event.data;
                GalleryView.this.viewer.refresh();
            }

            public void dragEnter(DropTargetEvent event) {
                this.dropAccept(event);
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.dropAccept(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.dropAccept(event);
            }

            public void dropAccept(DropTargetEvent event) {
                if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                } else if (event.detail == 16) {
                    if ((event.operations & 1) != 0) {
                        event.detail = 1;
                    } else if ((event.operations & 2) != 0) {
                        event.detail = 2;
                    }
                }
            }
        });
    }

    public void doSetFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void galleryGroupChanged() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        this.container.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (GalleryView.this.viewer == null || GalleryView.this.viewer.getControl() == null || GalleryView.this.viewer.getControl().isDisposed()) {
                    return;
                }
                GalleryView.this.viewer.refresh();
            }
        });
    }

    public void galleryStatusChanged(int oldStatus, int newStatus) {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        if (newStatus == 2) {
            this.container.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (GalleryView.this.container == null || GalleryView.this.container.isDisposed()) {
                        return;
                    }
                    GalleryView.this.toggleStatusArea(true, false);
                }
            });
        } else {
            this.container.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (GalleryView.this.container == null || GalleryView.this.container.isDisposed()) {
                        return;
                    }
                    GalleryView.this.toggleStatusArea(false, false);
                }
            });
        }
    }

    public void dispose() {
        GalleryCore.getInstance().removeGalleryChangedListener(this);
        if (this.viewer != null) {
            if (this.viewer.getControl() != null) {
                this.viewer.getControl().dispose();
            }
            this.viewer = null;
        }
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClipArtViewer
    extends CategorizedGalleryViewer {
        private ClipArtViewer() {
        }

        public void refresh() {
            if (this.getLabelProvider() instanceof GalleryLabelProvider) {
                ((GalleryLabelProvider)this.getLabelProvider()).clearCaches();
            }
            super.refresh();
        }

        protected void hookNestedViewerControl(GalleryViewer viewer, Object category) {
            super.hookNestedViewerControl(viewer, category);
            GalleryView.this.createDragSource(viewer.getControl());
        }

        protected List<Object> getCategories() {
            return super.getCategories();
        }
    }

    private static class GalleryContentProvider
    implements ITreeContentProvider {
        private GalleryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((GalleryCore)inputElement).getGalleryGroups().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IGalleryGroup) {
                return ((IGalleryGroup)parentElement).getItems().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IGalleryItem) {
                return ((IGalleryItem)element).getParent();
            }
            if (element instanceof IGalleryGroup) {
                return GalleryCore.getInstance();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof GalleryCore || element instanceof IGalleryGroup;
        }
    }

    private static class GalleryLabelProvider
    extends ImageCachedLabelProvider {
        private GalleryLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IGalleryGroup) {
                return ((IGalleryGroup)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            URL url;
            if (element instanceof IGalleryItem && (url = ((IGalleryItem)element).getURL()) != null) {
                Image image;
                InputStream stream = url.openStream();
                try {
                    image = new Image((Device)Display.getCurrent(), stream);
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        GalleryPlugin.log(e, "Failed to read image data from URL: " + url.toExternalForm());
                    }
                }
                stream.close();
                return image;
            }
            return null;
        }
    }
}

