/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;

public class DefaultCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private int fAnchor = -1;
    private final CharPairs fPairs;
    private final String fPartitioning;
    private final boolean fCaretEitherSideOfBracket;

    public DefaultCharacterPairMatcher(char[] chars, String partitioning) {
        this(chars, partitioning, false);
    }

    public DefaultCharacterPairMatcher(char[] chars, String partitioning, boolean caretEitherSideOfBracket) {
        Assert.isLegal((chars.length % 2 == 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)partitioning);
        this.fPairs = new CharPairs(chars);
        this.fPartitioning = partitioning;
        this.fCaretEitherSideOfBracket = caretEitherSideOfBracket;
    }

    public DefaultCharacterPairMatcher(char[] chars) {
        this(chars, "__dftl_partitioning");
    }

    @Override
    public IRegion match(IDocument doc, int offset) {
        if (doc == null || offset < 0 || offset > doc.getLength()) {
            return null;
        }
        try {
            return this.performMatch(doc, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public IRegion match(IDocument document, int offset, int length) {
        int sourceCaretOffset;
        block4: {
            if (document == null || offset < 0 || offset > document.getLength() || Math.abs(length) > 1) {
                return null;
            }
            try {
                char ch;
                sourceCaretOffset = offset + length;
                if (Math.abs(length) != 1) break block4;
                char c = ch = length > 0 ? document.getChar(offset) : document.getChar(sourceCaretOffset);
                if (this.fPairs.contains(ch)) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int adjustment = this.getOffsetAdjustment(document, sourceCaretOffset, length);
        return this.match(document, sourceCaretOffset += adjustment);
    }

    @Override
    public IRegion findEnclosingPeerCharacters(IDocument document, int offset, int length) {
        if (document == null || offset < 0 || offset > document.getLength()) {
            return null;
        }
        IRegion region = this.match(document, offset, length);
        this.fAnchor = 1;
        if (region != null) {
            return region;
        }
        try {
            String partition = TextUtilities.getContentType((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)false);
            DocumentPartitionAccessor partDoc = new DocumentPartitionAccessor(document, this.fPartitioning, partition);
            IRegion enclosingPeers = this.findEnclosingPeers(document, partDoc, offset, length, 0, document.getLength());
            if (enclosingPeers != null) {
                return enclosingPeers;
            }
            partDoc = new DocumentPartitionAccessor(document, this.fPartitioning, "__dftl_partition_content_type");
            return this.findEnclosingPeers(document, partDoc, offset, length, 0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            this.fAnchor = -1;
            return null;
        }
    }

    @Override
    public boolean isMatchedChar(char ch) {
        return this.fPairs.contains(ch);
    }

    @Override
    public boolean isMatchedChar(char ch, IDocument document, int offset) {
        return this.isMatchedChar(ch);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRecomputationOfEnclosingPairRequired(IDocument document, IRegion currentSelection, IRegion previousSelection) {
        int previousStartOffset = previousSelection.getOffset();
        int currentStartOffset = currentSelection.getOffset();
        int previousEndOffset = previousStartOffset + previousSelection.getLength();
        int currentEndOffset = currentStartOffset + currentSelection.getLength();
        try {
            int i;
            int end;
            int start;
            block12: {
                String currStartContentType;
                String prevEndContentType = TextUtilities.getContentType((IDocument)document, (String)this.fPartitioning, (int)previousEndOffset, (boolean)false);
                String currEndContentType = TextUtilities.getContentType((IDocument)document, (String)this.fPartitioning, (int)currentEndOffset, (boolean)false);
                if (!prevEndContentType.equals(currEndContentType)) {
                    return true;
                }
                String prevStartContentType = TextUtilities.getContentType((IDocument)document, (String)this.fPartitioning, (int)previousStartOffset, (boolean)true);
                if (!prevStartContentType.equals(currStartContentType = TextUtilities.getContentType((IDocument)document, (String)this.fPartitioning, (int)currentStartOffset, (boolean)true))) {
                    return true;
                }
                if (currentEndOffset > previousEndOffset) {
                    start = previousEndOffset;
                    end = currentEndOffset;
                } else {
                    start = currentEndOffset;
                    end = previousEndOffset;
                }
                i = Math.max(start - 1, 0);
                while (true) {
                    if (i > end) {
                        if (currentStartOffset <= previousStartOffset) break;
                        start = previousStartOffset;
                        end = currentStartOffset;
                        break block12;
                    }
                    if (this.isMatchedChar(document.getChar(i))) {
                        return true;
                    }
                    ++i;
                }
                start = currentStartOffset;
                end = previousStartOffset;
            }
            i = Math.max(start - 1, 0);
            while (true) {
                if (i > end) {
                    return false;
                }
                if (this.isMatchedChar(document.getChar(i))) {
                    return true;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int getOffsetAdjustment(IDocument document, int offset, int length) {
        block7: {
            block6: {
                if (length == 0 || Math.abs(length) > 1 || offset >= document.getLength()) {
                    return 0;
                }
                try {
                    if (length >= 0) break block6;
                    if (this.fPairs.isStartCharacter(document.getChar(offset))) {
                        return 1;
                    }
                    break block7;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (this.fCaretEitherSideOfBracket && this.fPairs.isEndCharacter(document.getChar(offset - 1))) {
                return -1;
            }
        }
        return 0;
    }

    private IRegion performMatch(IDocument doc, int caretOffset) throws BadLocationException {
        int adjustedEndOffset;
        int searchStartPosition;
        char ch;
        boolean isForward;
        char prevChar;
        char c = prevChar = caretOffset - 1 >= 0 ? doc.getChar(caretOffset - 1) : (char)'\u0000';
        if (this.fCaretEitherSideOfBracket) {
            boolean isBackward;
            char currChar;
            char c2 = currChar = caretOffset != doc.getLength() ? doc.getChar(caretOffset) : (char)'\u0000';
            if (this.fPairs.isEndCharacter(prevChar) && !this.fPairs.isEndCharacter(currChar)) {
                currChar = prevChar;
                prevChar = doc.getChar(Math.max(--caretOffset - 1, 0));
            } else if (this.fPairs.isStartCharacter(currChar) && !this.fPairs.contains(prevChar)) {
                prevChar = currChar;
                currChar = doc.getChar(++caretOffset);
            }
            isForward = this.fPairs.contains(prevChar) && this.fPairs.isStartCharacter(prevChar);
            boolean bl = isBackward = this.fPairs.contains(currChar) && !this.fPairs.isStartCharacter(currChar);
            if (!isForward && !isBackward) {
                return null;
            }
            ch = isForward ? prevChar : currChar;
        } else {
            if (!this.fPairs.contains(prevChar)) {
                return null;
            }
            isForward = this.fPairs.isStartCharacter(prevChar);
            ch = prevChar;
        }
        int n = this.fAnchor = isForward ? 1 : 0;
        int n2 = isForward ? caretOffset : (searchStartPosition = this.fCaretEitherSideOfBracket ? caretOffset - 1 : caretOffset - 2);
        int adjustedOffset = isForward ? caretOffset - 1 : (this.fCaretEitherSideOfBracket ? caretOffset + 1 : caretOffset);
        String partition = TextUtilities.getContentType((IDocument)doc, (String)this.fPartitioning, (int)(!isForward && this.fCaretEitherSideOfBracket ? caretOffset : Math.max(caretOffset - 1, 0)), (boolean)false);
        DocumentPartitionAccessor partDoc = new DocumentPartitionAccessor(doc, this.fPartitioning, partition);
        int endOffset = this.findMatchingPeer(partDoc, ch, this.fPairs.getMatching(ch), isForward, isForward ? doc.getLength() : -1, searchStartPosition);
        if (endOffset == -1) {
            return null;
        }
        int n3 = adjustedEndOffset = isForward ? endOffset + 1 : endOffset;
        if (adjustedEndOffset == adjustedOffset) {
            return null;
        }
        return new Region(Math.min(adjustedOffset, adjustedEndOffset), Math.abs(adjustedEndOffset - adjustedOffset));
    }

    private int findMatchingPeer(DocumentPartitionAccessor doc, char start, char end, boolean searchForward, int boundary, int startPos) throws BadLocationException {
        int pos = startPos;
        int nestingLevel = 0;
        while (pos != boundary) {
            char c = doc.getChar(pos);
            if (c == end && doc.inPartition(pos)) {
                if (nestingLevel == 0) {
                    return pos;
                }
                --nestingLevel;
            } else if (c == start && doc.inPartition(pos)) {
                ++nestingLevel;
            }
            pos = doc.getNextPosition(pos, searchForward);
        }
        return -1;
    }

    private IRegion findEnclosingPeers(IDocument document, DocumentPartitionAccessor doc, int offset, int length, int lowerBoundary, int upperBoundary) throws BadLocationException {
        int pos2;
        int pos1;
        char currChar;
        int end;
        int start;
        char[] pairs = this.fPairs.fPairs;
        if (length >= 0) {
            start = offset;
            end = offset + length;
        } else {
            end = offset;
            start = offset + length;
        }
        boolean lowerFound = false;
        boolean upperFound = false;
        int[][] counts = new int[pairs.length][2];
        char c = currChar = start != document.getLength() ? doc.getChar(start) : (char)'\u0000';
        if (this.fPairs.isEndCharacter(currChar)) {
            pos1 = doc.getNextPosition(start, false);
            pos2 = start;
        } else {
            pos1 = start;
            pos2 = doc.getNextPosition(start, true);
        }
        while (pos1 >= lowerBoundary && !lowerFound || pos2 < upperBoundary && !upperFound) {
            int j;
            int i;
            char c2;
            int i2 = 0;
            while (i2 < counts.length) {
                counts[i2][1] = 0;
                counts[i2][0] = 0;
                ++i2;
            }
            block2: while (pos1 >= lowerBoundary && !lowerFound) {
                c2 = doc.getChar(pos1);
                i = this.getCharacterIndex(c2, document, pos1);
                if (i != -1 && doc.inPartition(pos1)) {
                    if (i % 2 == 0) {
                        int[] nArray = counts[i / 2];
                        nArray[0] = nArray[0] - 1;
                    } else {
                        int[] nArray = counts[i / 2];
                        nArray[0] = nArray[0] + 1;
                    }
                    j = 0;
                    while (j < counts.length) {
                        if (counts[j][0] == -1) {
                            lowerFound = true;
                            break block2;
                        }
                        ++j;
                    }
                }
                pos1 = doc.getNextPosition(pos1, false);
            }
            block4: while (pos2 < upperBoundary && !upperFound) {
                c2 = doc.getChar(pos2);
                i = this.getCharacterIndex(c2, document, pos2);
                if (i != -1 && doc.inPartition(pos2)) {
                    if (i % 2 == 0) {
                        int[] nArray = counts[i / 2];
                        nArray[1] = nArray[1] + 1;
                    } else {
                        int[] nArray = counts[i / 2];
                        nArray[1] = nArray[1] - 1;
                    }
                    j = 0;
                    while (j < counts.length) {
                        if (counts[j][1] == -1 && counts[j][0] == -1) {
                            upperFound = true;
                            break block4;
                        }
                        ++j;
                    }
                }
                pos2 = doc.getNextPosition(pos2, true);
            }
            if (pos1 <= start && pos2 >= end - 1) continue;
            pos1 = doc.getNextPosition(pos1, false);
            pos2 = doc.getNextPosition(pos2, true);
            lowerFound = false;
            upperFound = false;
        }
        if (pos1 < lowerBoundary || ++pos2 > upperBoundary) {
            return null;
        }
        return new Region(pos1, pos2 - pos1);
    }

    private int getCharacterIndex(char ch, IDocument document, int offset) {
        char[] pairs = this.fPairs.fPairs;
        int i = 0;
        while (i < pairs.length) {
            if (pairs[i] == ch && this.isMatchedChar(ch, document, offset)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getAnchor() {
        return this.fAnchor;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void clear() {
        this.fAnchor = -1;
    }

    private static class CharPairs {
        private final char[] fPairs;

        public CharPairs(char[] pairs) {
            this.fPairs = pairs;
        }

        public boolean contains(char c) {
            char[] pairs = this.fPairs;
            int i = 0;
            int n = pairs.length;
            while (i < n) {
                if (c == pairs[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean isOpeningCharacter(char c, boolean searchForward) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (searchForward && this.getStartChar(i) == c) {
                    return true;
                }
                if (!searchForward && this.getEndChar(i) == c) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public boolean isStartCharacter(char c) {
            return this.isOpeningCharacter(c, true);
        }

        public boolean isEndCharacter(char c) {
            return this.isOpeningCharacter(c, false);
        }

        public char getMatching(char c) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (this.getStartChar(i) == c) {
                    return this.getEndChar(i);
                }
                if (this.getEndChar(i) == c) {
                    return this.getStartChar(i);
                }
                i += 2;
            }
            Assert.isTrue((boolean)false);
            return '\u0000';
        }

        private char getStartChar(int i) {
            return this.fPairs[i];
        }

        private char getEndChar(int i) {
            return this.fPairs[i + 1];
        }
    }

    private static class DocumentPartitionAccessor {
        private final IDocument fDocument;
        private final String fPartitioning;
        private final String fPartition;
        private ITypedRegion fCachedPartition;
        private int fLength;

        public DocumentPartitionAccessor(IDocument doc, String partitioning, String partition) {
            this.fDocument = doc;
            this.fPartitioning = partitioning;
            this.fPartition = partition;
            this.fLength = doc.getLength();
        }

        public char getChar(int pos) throws BadLocationException {
            return this.fDocument.getChar(pos);
        }

        public boolean inPartition(int pos) {
            ITypedRegion partition = this.getPartition(pos);
            return partition != null && partition.getType().equals(this.fPartition);
        }

        public int getNextPosition(int pos, boolean searchForward) {
            ITypedRegion partition = this.getPartition(pos);
            if (partition == null || this.fPartition.equals(partition.getType())) {
                return this.simpleIncrement(pos, searchForward);
            }
            if (searchForward) {
                int end = partition.getOffset() + partition.getLength();
                if (pos < end) {
                    return end;
                }
            } else {
                int offset = partition.getOffset();
                if (pos > offset) {
                    return offset - 1;
                }
            }
            return this.simpleIncrement(pos, searchForward);
        }

        private int simpleIncrement(int pos, boolean searchForward) {
            return pos + (searchForward ? 1 : -1);
        }

        private ITypedRegion getPartition(int pos) {
            if (this.fCachedPartition == null || !DocumentPartitionAccessor.contains((IRegion)this.fCachedPartition, pos)) {
                Assert.isTrue((pos >= 0 && pos <= this.fLength ? 1 : 0) != 0);
                try {
                    this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)pos, (boolean)false);
                }
                catch (BadLocationException badLocationException) {
                    this.fCachedPartition = null;
                }
            }
            return this.fCachedPartition;
        }

        private static boolean contains(IRegion region, int pos) {
            int offset = region.getOffset();
            return offset <= pos && pos < offset + region.getLength();
        }
    }
}

