/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.decorations;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.AbstractDecoration;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPolygon;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.decorations.IBranchConnectionDecoration;
import org.xmind.ui.decorations.ITopicDecoration;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.ITopicPart;

public class SubFishboneBranchDecoration
extends AbstractDecoration {
    private IBranchPart branch;
    private PrecisionPoint start = null;
    private PrecisionPoint end = null;

    public SubFishboneBranchDecoration(IBranchPart branch, String id) {
        super(id);
        this.branch = branch;
    }

    public void validate(IFigure figure) {
        PrecisionPoint p2;
        super.validate(figure);
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart == null) {
            this.setVisible(figure, false);
            return;
        }
        IAnchor anchor = ((INodePart)topicPart).getSourceAnchor((IGraphicalPart)this.branch);
        if (anchor == null) {
            this.setVisible(figure, false);
            return;
        }
        IBranchPart parent = this.branch.getParentBranch();
        if (parent == null) {
            this.setVisible(figure, false);
            return;
        }
        IBranchConnectionDecoration conn = (IBranchConnectionDecoration)parent.getConnections().getDecoration(this.branch.getBranchIndex());
        if (conn == null) {
            this.setVisible(figure, false);
            return;
        }
        int orientation = conn.getTargetOrientation();
        PrecisionPoint p1 = anchor.getLocation(orientation, (double)conn.getTargetExpansion());
        if (p1.equals((Object)(p2 = anchor.getLocation(Geometry.getOppositePosition((int)orientation), 0.0)))) {
            this.setVisible(figure, false);
            return;
        }
        PrecisionRectangle r = new PrecisionRectangle(topicPart.getFigure().getBounds());
        for (IBranchPart subBranch : this.branch.getSubBranches()) {
            ITopicPart subTopicPart = subBranch.getTopicPart();
            r = subTopicPart != null ? Geometry.union((PrecisionRectangle)r, (PrecisionRectangle)new PrecisionRectangle(subTopicPart.getFigure().getBounds())) : Geometry.union((PrecisionRectangle)r, (PrecisionRectangle)new PrecisionRectangle(subBranch.getFigure().getBounds()));
        }
        PrecisionPolygon polygon = PrecisionPolygon.createFromRect((PrecisionRectangle)r);
        PrecisionPoint p = polygon.intersectFarthest(new PrecisionLine(p1, p2, PrecisionLine.LineType.Ray));
        if (p != null) {
            p2 = p;
        }
        this.setVisible(figure, true);
        this.start = p1;
        this.end = p2;
    }

    public void invalidate() {
        this.start = null;
        this.end = null;
        super.invalidate();
    }

    protected void performPaint(IFigure figure, Graphics graphics) {
        ITopicDecoration topicDecoration = this.getTopicDecoration();
        if (topicDecoration == null) {
            return;
        }
        Color lineColor = topicDecoration.getLineColor();
        if (lineColor == null) {
            return;
        }
        int lineWidth = topicDecoration.getLineWidth();
        int lineStyle = topicDecoration.getLineStyle();
        org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        shape.moveTo(this.start);
        shape.lineTo(this.end);
        graphics.setForegroundColor(lineColor);
        graphics.setLineWidth(lineWidth);
        graphics.setLineStyle(lineStyle);
        graphics.drawPath((Path)shape);
        shape.dispose();
    }

    private ITopicDecoration getTopicDecoration() {
        IDecoration decoration;
        IFigure topicFigure;
        ITopicPart topicPart = this.branch.getTopicPart();
        if (topicPart != null && (topicFigure = topicPart.getFigure()) instanceof IDecoratedFigure && (decoration = ((IDecoratedFigure)topicFigure).getDecoration()) instanceof ITopicDecoration) {
            return (ITopicDecoration)decoration;
        }
        return null;
    }
}

