/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.internal.dom.MarkerResourceProvider;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.IInputSource;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.ClonedTemplate;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.ResourceConfirmPageViewer;
import org.xmind.ui.internal.xmindresource.XMindResourceImpExpUtils;
import org.xmind.ui.mindmap.ITemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImportWizardSelectionPage
extends WizardPage {
    private static final String PAGE_SELECTION_NAME = "org.xmind.ui.xmindresource.ResourceImportWizardSelectionPage";
    private Text fileInput;
    private Button fileBrowseButton;
    private boolean modifyingPathInput = false;
    private boolean settingTargetPath = false;
    private boolean pathModified = false;
    private Listener widgetListener;
    private String sourcePath;
    private PageBook confirmPageBook;
    private Control fileErrorConfirmPage;
    private ResourceConfirmPageViewer confirmViewer;
    private int status = 0;
    private String unZipDir;

    public ResourceImportWizardSelectionPage() {
        super(PAGE_SELECTION_NAME, Messages.ResourceImportWizardSelectionPage_title, null);
        this.setDescription(Messages.ResourceImportWizardSelectionPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        Control fileGroup = this.createFileControls(composite);
        fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label blank = new Label(composite, 0);
        blank.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        blank.setText(" ");
        this.fileInput.setFocus();
        this.createConfirm(composite);
    }

    protected Control createFileControls(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        Label fromFile = new Label(group, 64);
        fromFile.setLayoutData((Object)new GridData(1, 2, false, false));
        fromFile.setText(Messages.ResourceImportWizardSelectionPage_FromFile_text);
        this.fileInput = new Text(group, 2052);
        if (this.getSourcePath() != null) {
            this.fileInput.setText(this.getSourcePath());
        }
        this.fileInput.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.fileInput, 24);
        this.hookWidget((Widget)this.fileInput, 15);
        this.fileBrowseButton = new Button(group, 8);
        this.fileBrowseButton.setText(Messages.ResourceImportWizardSelectionPage_Browse_text);
        int width = this.fileBrowseButton.computeSize((int)-1, (int)-1).x;
        GridData layoutData = new GridData(3, 2, false, false);
        layoutData.widthHint = Math.max(93, width);
        this.fileBrowseButton.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.fileBrowseButton, 13);
        return group;
    }

    protected void hookWidget(Widget widget, int eventType) {
        if (this.widgetListener == null) {
            this.widgetListener = new WidgetListener();
        }
        widget.addListener(eventType, this.widgetListener);
    }

    protected void handleWidgetEvent(Event event) {
        if (event.widget == this.fileInput) {
            if (event.type == 24) {
                this.pathModified = true;
                if (!this.settingTargetPath) {
                    this.modifyingPathInput = true;
                    this.setSourcePath(this.fileInput.getText());
                    this.modifyingPathInput = false;
                }
                this.updateStatus();
            } else if (event.type == 15) {
                this.fileInput.setSelection(new Point(0, this.fileInput.getText().length()));
            }
        } else if (event.widget == this.fileBrowseButton) {
            this.openFileDialog();
            this.fileInput.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.fileInput = null;
        this.fileBrowseButton = null;
        this.modifyingPathInput = false;
        this.settingTargetPath = false;
        this.pathModified = false;
    }

    private void openFileDialog() {
        FileDialog dialog = this.createFileDialog();
        String path = dialog.open();
        if (path != null) {
            this.setSourcePath(path);
        }
    }

    private FileDialog createFileDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.ResourceImportWizardSelectionPage_FileDialog_text);
        String ext = "*.xrb";
        String mExt = "*.xmp";
        String allSupportedExt = String.format("%s;%s", ext, mExt);
        ArrayList<String> filterExtensions = new ArrayList<String>(Arrays.asList(dialog.getFilterExtensions()));
        filterExtensions.add(allSupportedExt);
        filterExtensions.add(ext);
        filterExtensions.add(mExt);
        dialog.setFilterExtensions(filterExtensions.toArray(new String[filterExtensions.size()]));
        ArrayList<String> filterNames = new ArrayList<String>(Arrays.asList(dialog.getFilterNames()));
        filterNames.add(NLS.bind((String)"{0} ({1}, {2})", (Object[])new String[]{Messages.ResourceImportWizardSelectionPage_Support_Files, ext, mExt}));
        filterNames.add(NLS.bind((String)"{0} ({1})", (Object)Messages.ResourceImportExportWizardPage_FilterName, (Object)ext));
        filterNames.add(NLS.bind((String)"{0} ({1})", (Object)Messages.ResourceImportWizardSelectionPage_Marker_Package, (Object)mExt));
        dialog.setFilterNames(filterNames.toArray(new String[filterNames.size()]));
        if (this.getSourcePath() != null) {
            File file = new File(this.getSourcePath());
            dialog.setFilterPath(file.getParent());
            dialog.setFileName(file.getName());
        }
        return dialog;
    }

    private void updateStatus() {
        this.setPageComplete(this.isPageCompletable());
        String warningMessage = this.generateWarningMessage();
        if (warningMessage != null) {
            this.setMessage(warningMessage, 2);
        } else {
            this.setMessage(null);
        }
        this.setErrorMessage(this.generateErrorMessage());
        if (this.isPageCompletable()) {
            List<Object> elementsToConfirm = this.sourcePath.endsWith(".xrb") ? this.getElementsToConfirmFromSourcePath(this.getSourcePath()) : this.getMarkersToConfirmFromSourcePath(this.getSourcePath());
            if (!elementsToConfirm.isEmpty()) {
                this.confirmViewer.setNeedConfirmSelection(elementsToConfirm);
                this.confirmPageBook.showPage(this.confirmViewer.getControl());
            } else {
                this.confirmPageBook.showPage(this.fileErrorConfirmPage);
            }
        } else {
            this.confirmViewer.setNeedConfirmSelection(Collections.EMPTY_LIST);
        }
    }

    private String generateWarningMessage() {
        return null;
    }

    private String generateErrorMessage() {
        if (this.pathModified && !this.hasSourcePath()) {
            return Messages.ResourceImportWizardSelectionPage_FileNoteExists_message;
        }
        return null;
    }

    private boolean isPageCompletable() {
        return this.hasSourcePath() && (this.sourcePath.endsWith(".xrb") || this.sourcePath.endsWith(".xmp"));
    }

    private void setSourcePath(String path) {
        this.sourcePath = path;
        if (!this.modifyingPathInput) {
            this.settingTargetPath = true;
            if (this.fileInput.isEnabled()) {
                this.fileInput.setText(path);
            }
            this.settingTargetPath = false;
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public boolean hasSourcePath() {
        return this.sourcePath != null && !"".equals(this.sourcePath) && new File(this.sourcePath).exists() && new File(this.sourcePath).canRead();
    }

    private void createConfirm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.confirmPageBook = new PageBook(composite, 0);
        this.confirmPageBook.setBackground(composite.getBackground());
        this.confirmPageBook.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileErrorConfirmPage = this.createFileErrorConfirmPage((Composite)this.confirmPageBook);
        this.confirmViewer = new ResourceConfirmPageViewer((Composite)this.confirmPageBook, 68354);
        this.confirmViewer.initViewer();
        this.confirmViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.confirmPageBook.showPage(this.confirmViewer.getControl());
    }

    private Control createFileErrorConfirmPage(Composite parent) {
        Label errorPage = new Label((Composite)this.confirmPageBook, 2112);
        errorPage.setBackground(parent.getBackground());
        errorPage.setText(Messages.ResourceImportWizardSelectionPage_FileError_description);
        return errorPage;
    }

    public int getStatus() {
        return this.status;
    }

    public String getUnZipDir() {
        return this.unZipDir;
    }

    private List<Object> getElementsToConfirmFromSourcePath(String sourcePath) {
        File markerFile;
        File clipartDir;
        File templatesDir;
        String tempDir;
        this.status = 0;
        this.status |= XMindResourceImpExpUtils.createTempDiretoryHasUnZipResource(sourcePath);
        File root = XMindResourceImpExpUtils.getSpecialDir(sourcePath);
        this.unZipDir = tempDir = root.getAbsolutePath();
        LinkedList<Object> elementsToConfirm = new LinkedList<Object>();
        if (this.status != 0) {
            return elementsToConfirm;
        }
        File themeFile = new File(String.valueOf(tempDir) + File.separator + "themes" + File.separator + "styles.xml");
        if (themeFile.exists()) {
            try {
                IStyleSheet styleSheet = Core.getStyleSheetBuilder().loadFromFile(themeFile);
                Set styles = styleSheet.getStyles("master-styles");
                elementsToConfirm.addAll(styles);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if ((templatesDir = new File(String.valueOf(tempDir) + File.separator + "templates")).isDirectory()) {
            ArrayList<ITemplate> templates = new ArrayList<ITemplate>();
            this.loadTemplatesFromDir(templates, templatesDir);
            elementsToConfirm.addAll(templates);
        }
        if ((clipartDir = new File(String.valueOf(tempDir) + File.separator + "cliparts")).isDirectory()) {
            File[] cliparts;
            LocalGalleryGroup galleryGroup = new LocalGalleryGroup(clipartDir, "Temp Clip Art");
            File[] fileArray = cliparts = clipartDir.listFiles();
            int n = cliparts.length;
            int n2 = 0;
            while (n2 < n) {
                File clipartFile = fileArray[n2];
                if (this.isImageFile(clipartFile.getAbsolutePath())) {
                    elementsToConfirm.add(new LocalGalleryItem((IGalleryGroup)galleryGroup, clipartFile));
                }
                ++n2;
            }
        }
        if ((markerFile = new File(String.valueOf(tempDir) + File.separator + "markers" + File.separator + "markerSheet.xml")).exists()) {
            DirectoryInputSource inputSource = new DirectoryInputSource(new File(String.valueOf(tempDir) + File.separator + "markers"));
            try {
                IMarkerSheet sourceMarkerSheet = Core.getMarkerSheetBuilder().loadFromFile(markerFile, (IMarkerResourceProvider)new MarkerResourceProvider((IInputSource)inputSource, null));
                elementsToConfirm.addAll(sourceMarkerSheet.getMarkerGroups());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return elementsToConfirm;
    }

    private List<Object> getMarkersToConfirmFromSourcePath(String sourcePath) {
        String tempDir;
        this.status = 0;
        this.status |= XMindResourceImpExpUtils.createTempDiretoryHasUnZipMarkerPackage(sourcePath);
        File root = XMindResourceImpExpUtils.getSpecialDir(sourcePath);
        this.unZipDir = tempDir = root.getAbsolutePath();
        LinkedList<Object> elementsToConfirm = new LinkedList<Object>();
        if (this.status != 0) {
            return elementsToConfirm;
        }
        File markerFile = new File(String.valueOf(tempDir) + File.separator + "markerSheet.xml");
        if (markerFile.exists()) {
            DirectoryInputSource inputSource = new DirectoryInputSource(new File(String.valueOf(tempDir) + File.separator + "markers"));
            try {
                IMarkerSheet sourceMarkerSheet = Core.getMarkerSheetBuilder().loadFromFile(markerFile, (IMarkerResourceProvider)new MarkerResourceProvider((IInputSource)inputSource, null));
                elementsToConfirm.addAll(sourceMarkerSheet.getMarkerGroups());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return elementsToConfirm;
    }

    private boolean isImageFile(String name) {
        return name.endsWith(".png") || name.endsWith(".bmp") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif");
    }

    private void loadTemplatesFromDir(List<ITemplate> templates, File templatesDir) {
        TreeSet<ITemplate> set = new TreeSet<ITemplate>(new Comparator<ITemplate>(){

            @Override
            public int compare(ITemplate t1, ITemplate t2) {
                URI u1 = t1.getSourceWorkbookURI();
                URI u2 = t2.getSourceWorkbookURI();
                return u1.compareTo(u2);
            }
        });
        if (templatesDir != null && templatesDir.isDirectory()) {
            String[] stringArray = templatesDir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                String fileName = stringArray[n2];
                if ((fileName.endsWith(".xmt") || fileName.endsWith(".xmind")) && (file = new File(templatesDir, fileName)).isFile() && file.canRead()) {
                    set.add((ITemplate)new ClonedTemplate(file.toURI(), fileName.substring(0, fileName.lastIndexOf(46))));
                }
                ++n2;
            }
        }
        templates.addAll(set);
    }

    private class WidgetListener
    implements Listener {
        private WidgetListener() {
        }

        public void handleEvent(Event event) {
            ResourceImportWizardSelectionPage.this.handleWidgetEvent(event);
        }
    }
}

