/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.util.ArrayList;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.presentation.AbstractPresentationWindows;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.internal.presentation.NavigationHistoryService;
import org.xmind.ui.internal.presentation.PresentationMenuService;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.PresentationPage;
import org.xmind.ui.internal.presentation.PresentationViewer;
import org.xmind.ui.internal.presentation.SideBar;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.util.Cancelable;
import org.xmind.ui.util.ICancelable;
import org.xmind.ui.viewers.SWTUtils;

public class PresentationWindow
extends AbstractPresentationWindows
implements ISelectionChangedListener {
    private static final int FADE_INTERVALS = 15;
    private static final int SIDE_BAR_OFFSET_STEP = 20;
    private SideBar sideBar;
    private IActionRegistry actionRegistry = new ActionRegistry();
    private int sideBarOffset = 1;
    private ICancelable sideBarJob = null;
    private List<Runnable> closeListeners = new ArrayList<Runnable>();
    private IContextActivation presentationContextActivation;

    public PresentationWindow(Shell parentShell) {
        super(parentShell);
        this.initProperties();
        IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        this.presentationContextActivation = service.activateContext("org.xmind.ui.context.presentation.edit");
    }

    private void initProperties() {
        Properties prop = this.getProperties();
        prop.set("scrollSmooth", (Object)Boolean.TRUE);
        prop.set("ignoreScrollEvent", (Object)Boolean.TRUE);
        prop.set("centered", (Object)Boolean.TRUE);
        prop.set("cornered", (Object)Boolean.TRUE);
        prop.set("gradient", (Object)Boolean.TRUE);
        prop.set("margin", (Object)500);
        prop.set("actions", (Object)this.actionRegistry);
        this.actionRegistry.addAction((IAction)new LightAction());
        this.actionRegistry.addAction((IAction)new QuitAction());
        this.actionRegistry.addAction((IAction)new ToggleSideBarAction());
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.installServices();
        return contents;
    }

    private void installServices() {
        GraphicalViewer viewer = (GraphicalViewer)this.getCurrentPage().getViewer();
        if (viewer != null) {
            PresentationMenuService brainstormMenuService = new PresentationMenuService((IGraphicalViewer)viewer);
            viewer.installService(PresentationMenuService.class, (IViewerService)brainstormMenuService);
            brainstormMenuService.setActive(true);
        }
    }

    private void unInstallServices() {
        GraphicalViewer viewer = (GraphicalViewer)this.getCurrentPage().getViewer();
        if (viewer != null) {
            viewer.uninstallService(PresentationMenuService.class);
        }
    }

    public IActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void addCloseListener(Runnable listener) {
        this.closeListeners.add(listener);
    }

    public void removeCloseListener(Runnable listener) {
        this.closeListeners.remove(listener);
    }

    protected void handleCloseEvent() {
        Object[] listeners;
        Object[] objectArray = listeners = this.closeListeners.toArray();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            final Runnable listener = (Runnable)l;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.run();
                }
            });
            ++n2;
        }
    }

    public int open() {
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.presentation.showingSideBar", null);
        properties.set("org.xmind.ui.presentation.lightOnOff", null);
        return super.open();
    }

    protected IPresentationPage createPage(IMindMap mindmap) {
        PresentationPage newPage = new PresentationPage(this, mindmap, this.getProperties());
        this.pageChanged(null, newPage);
        return newPage;
    }

    protected void pageChanged(PresentationPage oldPage, PresentationPage newPage) {
        if (oldPage != null) {
            oldPage.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (newPage != null) {
            newPage.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            super.pageChanged(oldPage, newPage);
        }
    }

    public ISelection getSelection() {
        IPresentationPage page = this.getCurrentPage();
        if (page != null) {
            return page.getViewer().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public SideBar getSideBar() {
        return this.sideBar;
    }

    private void createSideBar(Composite parent) {
        this.sideBar = new SideBar(this);
        this.sideBar.createControl(parent);
        this.sideBar.getControl().moveAbove(null);
        this.sideBar.setSelection(this.getCurrentPage(), this.getSelection());
    }

    public boolean canHandleShellCloseEvent() {
        IAction action;
        if (this.getCurrentPage().getViewer().getEditDomain().getActiveTool() != this.getCurrentPage().getViewer().getEditDomain().getDefaultTool()) {
            return false;
        }
        if (this.sideBar != null && this.sideBar.getControl() != null && !this.sideBar.getControl().isDisposed() && this.sideBar.getControl().isVisible() && Boolean.TRUE.equals(this.getProperties().get("org.xmind.ui.presentation.showingSideBar")) && (action = this.actionRegistry.getAction("org.xmind.ui.presentation.action.sideBar")) != null) {
            action.run();
            return false;
        }
        return super.canHandleShellCloseEvent();
    }

    public boolean close() {
        this.deactivateContext();
        this.unInstallServices();
        return super.close();
    }

    protected void deactivateContext() {
        if (this.presentationContextActivation != null) {
            ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).deactivateContext(this.presentationContextActivation);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.sideBar != null) {
            this.sideBar.setSelection(this.getCurrentPage(), event.getSelection());
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 1 && SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000006) || event.type == 31 && event.detail == 512) {
            this.nextPage();
        } else if (event.type == 1 && SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000005) || event.type == 31 && event.detail == 256) {
            this.prevPage();
        }
    }

    private void prevPage() {
        int currentPageIndex = this.getCurrentPageIndex();
        if (currentPageIndex > 0) {
            this.setCurrentPage(currentPageIndex - 1);
        }
    }

    private void nextPage() {
        int currentPageIndex = this.getCurrentPageIndex();
        if (currentPageIndex < this.getPageCount() - 1) {
            this.setCurrentPage(currentPageIndex + 1);
        }
    }

    protected Layout getContentLayout() {
        return new ContentsLayout();
    }

    public class ContentsLayout
    extends Layout {
        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int maxWidth = 0;
            int maxHeight = 0;
            Point size = PresentationWindow.this.getPageContainer().computeSize(wHint, hHint, flushCache);
            maxWidth = Math.max(size.x, maxWidth);
            maxHeight = Math.max(size.y, maxHeight);
            if (PresentationWindow.this.sideBar != null && PresentationWindow.this.sideBar.getControl() != null && !PresentationWindow.this.sideBar.getControl().isDisposed()) {
                PresentationWindow.this.sideBar.getControl().computeSize(240, hHint, flushCache);
                maxWidth = Math.max(size.x, maxWidth);
                maxHeight = Math.max(size.y, maxHeight);
            }
            int width = maxWidth;
            int height = maxHeight;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            PresentationWindow.this.getPageContainer().setBounds(area);
            if (PresentationWindow.this.sideBar != null && PresentationWindow.this.sideBar.getControl() != null && !PresentationWindow.this.sideBar.getControl().isDisposed()) {
                PresentationWindow.this.sideBar.getControl().setBounds(area.x, area.y, 240, area.height);
            }
        }
    }

    private class HideSideBarJob
    extends Cancelable {
        protected void doJob() {
            if (PresentationWindow.this.getShell() == null || PresentationWindow.this.getShell().isDisposed()) {
                return;
            }
            if (PresentationWindow.this.sideBar == null || PresentationWindow.this.sideBar.getControl() == null || PresentationWindow.this.sideBar.getControl().isDisposed()) {
                return;
            }
            Composite contents = (Composite)PresentationWindow.this.getContents();
            if (PresentationWindow.this.sideBarOffset > 0) {
                Composite parent = PresentationWindow.this.sideBar.getControl().getParent();
                Rectangle clientArea = parent.getClientArea();
                PresentationWindow.this.sideBarOffset = ((PresentationWindow)PresentationWindow.this).sideBar.getControl().getLocation().x - clientArea.x;
            }
            PresentationWindow presentationWindow = PresentationWindow.this;
            presentationWindow.sideBarOffset = presentationWindow.sideBarOffset - 20;
            if (PresentationWindow.this.sideBarOffset <= -240) {
                PresentationWindow.this.sideBar.getControl().setVisible(false);
                PresentationWindow.this.sideBarOffset = -240;
                contents.layout();
                return;
            }
            Rectangle clientArea = ((Composite)PresentationWindow.this.sideBar.getControl()).getClientArea();
            PresentationWindow.this.sideBar.getControl().setBounds(clientArea.x + PresentationWindow.this.sideBarOffset, clientArea.y, clientArea.width, clientArea.height);
            ((Composite)PresentationWindow.this.sideBar.getControl()).layout();
            PresentationWindow.this.sideBar.getControl().setVisible(true);
            Display.getCurrent().timerExec(5, (Runnable)((Object)this));
        }
    }

    private class LightAction
    extends Action {
        public LightAction() {
            super(null, 2);
            this.setToolTipText(PresentationMessages.Light_toolTip);
            this.setId("org.xmind.ui.presentation.action.light");
            this.setChecked(false);
        }

        public void run() {
            if (PresentationWindow.this.pages == null) {
                return;
            }
            Properties properties = PresentationWindow.this.getProperties();
            this.setChecked(!Boolean.TRUE.equals(properties.get("org.xmind.ui.presentation.lightOnOff")));
            for (IPresentationPage p : PresentationWindow.this.pages) {
                if (!(p instanceof PresentationPage)) continue;
                PresentationPage page = (PresentationPage)p;
                page.turnLight(this.isChecked());
                NavigationHistoryService historyService = (NavigationHistoryService)page.getViewer().getService(NavigationHistoryService.class);
                page.getViewer().getProperties().set("org.xmind.ui.presentation.lightOnOff", this.isChecked());
                if (this.isChecked()) {
                    historyService.turnOnDayMode(((PresentationViewer)page.getViewer()).getMindMap());
                    continue;
                }
                historyService.turnOffDayMode();
            }
            properties.set("org.xmind.ui.presentation.lightOnOff", this.isChecked());
        }
    }

    private class QuitAction
    extends Action {
        public QuitAction() {
            super(PresentationMessages.Quit_text);
            this.setToolTipText(PresentationMessages.Quit_toolTip);
            this.setId("org.xmind.ui.presentation.action.quit");
        }

        public void run() {
            PresentationWindow.this.close();
        }
    }

    private class ShowSideBarJob
    extends Cancelable {
        protected void doJob() {
            if (PresentationWindow.this.getShell() == null || PresentationWindow.this.getShell().isDisposed()) {
                return;
            }
            Composite contents = (Composite)PresentationWindow.this.getContents();
            if (PresentationWindow.this.sideBar == null || PresentationWindow.this.sideBar.getControl() == null || PresentationWindow.this.sideBar.getControl().isDisposed()) {
                PresentationWindow.this.createSideBar(contents);
                PresentationWindow.this.sideBar.getControl().setVisible(false);
                contents.layout();
                PresentationWindow.this.sideBarOffset = -240;
            } else if (PresentationWindow.this.sideBarOffset > 0) {
                Composite parent = PresentationWindow.this.sideBar.getControl().getParent();
                Rectangle clientArea = parent.getClientArea();
                PresentationWindow.this.sideBarOffset = ((PresentationWindow)PresentationWindow.this).sideBar.getControl().getLocation().x - clientArea.x;
            }
            PresentationWindow presentationWindow = PresentationWindow.this;
            presentationWindow.sideBarOffset = presentationWindow.sideBarOffset + 20;
            if (PresentationWindow.this.sideBarOffset >= 0) {
                PresentationWindow.this.sideBarOffset = 0;
                contents.layout();
                return;
            }
            Rectangle clientArea = ((Composite)PresentationWindow.this.sideBar.getControl()).getClientArea();
            PresentationWindow.this.sideBar.getControl().setBounds(clientArea.x + PresentationWindow.this.sideBarOffset, clientArea.y, clientArea.width, clientArea.height);
            ((Composite)PresentationWindow.this.sideBar.getControl()).layout();
            PresentationWindow.this.sideBar.getControl().setVisible(true);
            Display.getCurrent().timerExec(5, (Runnable)((Object)this));
        }
    }

    private class ToggleSideBarAction
    extends Action {
        public ToggleSideBarAction() {
            super(null, 2);
            this.setToolTipText(PresentationMessages.ShowSidebar_toolTip);
            this.setId("org.xmind.ui.presentation.action.sideBar");
            this.setChecked(false);
        }

        public void run() {
            if (PresentationWindow.this.getContents() == null || PresentationWindow.this.getContents().isDisposed()) {
                return;
            }
            Properties properties = PresentationWindow.this.getProperties();
            this.setChecked(!Boolean.TRUE.equals(properties.get("org.xmind.ui.presentation.showingSideBar")));
            if (PresentationWindow.this.sideBarJob != null) {
                PresentationWindow.this.sideBarJob.cancel();
                PresentationWindow.this.sideBarJob = null;
            }
            PresentationWindow.this.sideBarJob = (ICancelable)(this.isChecked() ? new ShowSideBarJob() : new HideSideBarJob());
            Display.getCurrent().timerExec(15, (Runnable)PresentationWindow.this.sideBarJob);
            properties.set("org.xmind.ui.presentation.showingSideBar", this.isChecked());
            VerifyUI20141031.getUsageDataCollector().increase("ShowOrHideSideBarCount");
        }
    }
}

