/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.dialogs.WallpaperDialog;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.PropertyEditor;
import org.xmind.ui.viewers.MButton;

public class WallpaperPropertyEditor
extends PropertyEditor {
    private MButton selectWallpaperWidget;
    private ToolBarManager removeWallpaperBar;
    private Image selectWallpaperImage;

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 3;
        composite.setLayout((Layout)layout);
        this.createSelecteWallpaperWidget(composite);
        this.createRemoveWallpaper(composite);
        return composite;
    }

    private void createSelecteWallpaperWidget(final Composite parent) {
        this.selectWallpaperWidget = new MButton(parent, 2);
        this.selectWallpaperWidget.setText(StyleEditorMessages.WallpaperPropertyEditor_SelectWallpaperButton_text);
        this.selectWallpaperWidget.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectWallpaperWidget.getControl().setToolTipText(StyleEditorMessages.SelectWallpaper_toolTip);
        this.selectWallpaperWidget.setImage(this.getSelectWallpaperImage());
        this.selectWallpaperWidget.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                WallpaperPropertyEditor.this.openWallpaperDialog((Control)parent);
            }
        });
    }

    private void openWallpaperDialog(final Control parent) {
        final WallpaperDialog wallpaperDialog = new WallpaperDialog(parent.getShell(), parent);
        wallpaperDialog.open();
        Shell shell = wallpaperDialog.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent event) {
                    IGraphicalViewer viewer = (IGraphicalViewer)parent.getShell().getData("MindMapViewer");
                    IWorkbook workbook = (IWorkbook)viewer.getAdapter(IWorkbook.class);
                    String path = null;
                    try {
                        String sourcePath = wallpaperDialog.getSelectedWallpaperPath();
                        IFileEntry fileEntry = workbook.getManifest().createAttachmentFromFilePath(sourcePath);
                        path = HyperlinkUtils.toAttachmentURL((String)fileEntry.getPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    WallpaperPropertyEditor.this.changeValue(path);
                    WallpaperPropertyEditor.this.fireApplyEditorValue();
                }
            });
        }
    }

    private void createRemoveWallpaper(Composite parent) {
        this.removeWallpaperBar = new ToolBarManager(0x800000);
        this.removeWallpaperBar.add((IAction)new RemoveWallpaperAction());
        this.removeWallpaperBar.createControl(parent);
        this.removeWallpaperBar.getControl().setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private Image getSelectWallpaperImage() {
        ImageDescriptor icon;
        if ((this.selectWallpaperImage == null || this.selectWallpaperImage.isDisposed()) && (icon = MindMapUI.getImages().get("insertimage.png", true)) != null) {
            this.selectWallpaperImage = icon.createImage(false);
        }
        return this.selectWallpaperImage;
    }

    protected void setValueToWidget(Object value) {
    }

    protected void deactivateWidget() {
    }

    private void removeWallpaper() {
        this.changeValue(null);
        this.fireApplyEditorValue();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setBackground(color);
            if (this.selectWallpaperWidget != null && this.selectWallpaperWidget.getControl() != null && !this.selectWallpaperWidget.getControl().isDisposed()) {
                this.selectWallpaperWidget.getControl().setBackground(color);
            }
            if (this.removeWallpaperBar != null && this.removeWallpaperBar.getControl() != null && !this.removeWallpaperBar.getControl().isDisposed()) {
                this.removeWallpaperBar.getControl().setBackground(color);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setForeground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setFont(font);
        }
    }

    private class RemoveWallpaperAction
    extends Action {
        public RemoveWallpaperAction() {
            super(null, 1);
            this.setImageDescriptor(MindMapUI.getImages().get("trash.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("trash.png", false));
            this.setToolTipText(StyleEditorMessages.RemoveWallpaper_toolTip);
        }

        public void run() {
            WallpaperPropertyEditor.this.removeWallpaper();
        }
    }
}

