/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.ui.workbench.addons.minmax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.xmind.cathy.internal.ui.workbench.addons.minmax.XTrimStack;

public class MinMaxAddon {
    static final String ID_SUFFIX = "(minimized)";
    static final String STACK_VISIBLE = "StackVisible";
    static final String STACK_HIDDEN = "StackHidden";
    static final String TRIM_STACK_EXIST = "TrimStackExist";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    private IEclipseContext context;
    @Inject
    MAddon minMaxAddon;
    @Inject
    MApplication application;
    private SelectionListener toolItemSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ToolItem selectedToolItem = (ToolItem)e.widget;
            MUIElement uiElement = (MUIElement)selectedToolItem.getData("modelElement");
            if (uiElement.getTags() != null && uiElement.getTags().contains("DirectCommand")) {
                return;
            }
            MUIElement rightTrimBar = MinMaxAddon.this.modelService.find("org.xmind.ui.trimbar.right", (MUIElement)MinMaxAddon.this.application);
            if (rightTrimBar instanceof MTrimBar) {
                List children = ((MTrimBar)rightTrimBar).getChildren();
                for (MTrimElement trimElement : children) {
                    if (!(trimElement instanceof MToolBar)) continue;
                    List toolItems = ((MToolBar)trimElement).getChildren();
                    for (MToolBarElement toolBarElement : toolItems) {
                        MPart p;
                        if (!(toolBarElement instanceof MHandledToolItem) || toolBarElement == uiElement) continue;
                        MHandledToolItem handledToolItem = (MHandledToolItem)toolBarElement;
                        handledToolItem.setSelected(false);
                        Map parameters = handledToolItem.getWbCommand().getParameterMap();
                        String partId = (String)parameters.get("org.xmind.ui.commandParameter.modelPart.partId");
                        if (partId == null || (p = MinMaxAddon.this.partService.findPart(partId)) == null) continue;
                        p.setVisible(false);
                        MinMaxAddon.this.partService.hidePart(p);
                    }
                }
            }
        }
    };
    private CTabFolder2Adapter CTFButtonListener = new CTabFolder2Adapter(){

        private MUIElement getElementToChange(CTabFolderEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void maximize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MinMaxAddon.STACK_VISIBLE);
        }

        public void minimize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MinMaxAddon.TRIM_STACK_EXIST);
            MinMaxAddon.this.setState(this.getElementToChange(event), MinMaxAddon.STACK_HIDDEN);
        }

        public void restore(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MinMaxAddon.STACK_VISIBLE);
        }
    };
    private MouseListener doubleClickListener = new MouseAdapter(){

        private MUIElement getElementToChange(MouseEvent event) {
            Widget widget = event.widget;
            MUIElement element = (MUIElement)widget.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void mouseDoubleClick(MouseEvent e) {
            MUIElement elementToChange;
            if (e.button == 1 && !(elementToChange = this.getElementToChange(e)).getTags().contains(MinMaxAddon.STACK_VISIBLE)) {
                MinMaxAddon.this.setState(elementToChange, MinMaxAddon.STACK_VISIBLE);
            }
        }
    };

    private void setState(MUIElement element, String state) {
        if (STACK_VISIBLE.equals(state)) {
            element.getTags().remove(STACK_HIDDEN);
            element.getTags().remove(STACK_VISIBLE);
            element.getTags().add(STACK_VISIBLE);
        } else if (STACK_HIDDEN.equals(state)) {
            element.getTags().remove(STACK_HIDDEN);
            element.getTags().remove(STACK_VISIBLE);
            element.getTags().add(STACK_HIDDEN);
        } else if (TRIM_STACK_EXIST.equals(state)) {
            element.getTags().remove(TRIM_STACK_EXIST);
            element.getTags().add(TRIM_STACK_EXIST);
        }
    }

    @Inject
    @Optional
    private void subscribeAppStartUpCompleted(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event, @Optional MApplication application) {
        this.fixToolItemOfRightTrimBarStatus(application);
    }

    private void fixToolItemOfRightTrimBarStatus(MApplication application) {
        MTrimBar rightTrimBar;
        if (application == null) {
            return;
        }
        MTrimmedWindow tw = null;
        List windows = application.getChildren();
        for (MWindow win : windows) {
            if (!(win instanceof MTrimmedWindow)) continue;
            tw = (MTrimmedWindow)win;
            break;
        }
        if (tw == null) {
            return;
        }
        MUIElement rightPartStack = this.modelService.find("org.xmind.ui.stack.right", tw);
        MStackElement selectedPartStackElement = null;
        if (rightPartStack instanceof MPartStack) {
            selectedPartStackElement = (MStackElement)((MPartStack)rightPartStack).getSelectedElement();
        }
        if ((rightTrimBar = this.modelService.getTrim(tw, SideValue.RIGHT)) != null) {
            List children = rightTrimBar.getChildren();
            for (MTrimElement trimElement : children) {
                if (!(trimElement instanceof MToolBar)) continue;
                List toolBarElements = ((MToolBar)trimElement).getChildren();
                for (MToolBarElement te : toolBarElements) {
                    ParameterizedCommand pc;
                    if (!(te instanceof MHandledToolItem)) continue;
                    MHandledToolItem handledToolItem = (MHandledToolItem)te;
                    Object widget = te.getWidget();
                    if (widget instanceof ToolItem) {
                        ((ToolItem)widget).removeSelectionListener(this.toolItemSelectionListener);
                        ((ToolItem)widget).addSelectionListener(this.toolItemSelectionListener);
                    }
                    if ((pc = handledToolItem.getWbCommand()) == null) continue;
                    Map parameterMap = pc.getParameterMap();
                    String partId = (String)parameterMap.get("org.xmind.ui.commandParameter.modelPart.partId");
                    boolean selected = selectedPartStackElement != null && selectedPartStackElement.getElementId().equals(partId);
                    handledToolItem.setSelected(selected);
                    Map persistedState = handledToolItem.getPersistedState();
                    String iconURI = (String)persistedState.get(selected ? "selectedIconURI" : "unselectedIconURI");
                    if (iconURI == null) continue;
                    handledToolItem.setIconURI(iconURI);
                }
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicWidget(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
            return;
        }
        Control control = (Control)changedElement.getWidget();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.removeMouseListener(this.doubleClickListener);
        control.addMouseListener(this.doubleClickListener);
        if (control instanceof CTabFolder) {
            ((CTabFolder)control).removeCTabFolder2Listener((CTabFolder2Listener)this.CTFButtonListener);
            ((CTabFolder)control).addCTabFolder2Listener((CTabFolder2Listener)this.CTFButtonListener);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicChildren(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MWindow window = this.modelService.getTopLevelWindowFor(changedElement);
        if (!(changedElement instanceof MPerspectiveStack) || window == null || !(window instanceof MTrimmedWindow)) {
            return;
        }
        if (UIEvents.isREMOVE((Event)event)) {
            for (Object removedElement : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                MUIElement removed = (MUIElement)removedElement;
                String perspectiveId = removed.getElementId();
                MTrimBar bar = this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MUIElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicSelectedElement(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event, @Optional MApplication application) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement instanceof MPartStack && "org.xmind.ui.stack.right".equals(changedElement.getElementId())) {
            this.fixToolItemOfRightTrimBarStatus(application);
            return;
        }
        if (!(changedElement instanceof MPerspectiveStack)) {
            return;
        }
        MPerspectiveStack ps = (MPerspectiveStack)changedElement;
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)ps);
        List tcList = this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
        MPerspective curPersp = (MPerspective)ps.getSelectedElement();
        if (curPersp != null) {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(TRIM_STACK_EXIST);
            List minimizedElements = this.modelService.findElements((MUIElement)curPersp, null, MUIElement.class, tags);
            String perspId = String.valueOf('(') + curPersp.getElementId() + ')';
            for (MUIElement ele : minimizedElements) {
                String fullId = String.valueOf(ele.getElementId()) + perspId;
                for (MToolControl tc : tcList) {
                    if (!fullId.equals(tc.getElementId())) continue;
                    tc.setToBeRendered(true);
                }
            }
        }
        if (event.getProperty("OldValue") instanceof MPerspective) {
            MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
            String perspId = String.valueOf('(') + oldPersp.getElementId() + ')';
            for (MToolControl tc : tcList) {
                if (!(tc.getObject() instanceof XTrimStack) || !tc.getElementId().contains(perspId)) continue;
                XTrimStack ts = (XTrimStack)tc.getObject();
                ts.setStateForShowStack(false);
                tc.setToBeRendered(false);
            }
        }
        final Shell winShell = (Shell)window.getWidget();
        winShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!winShell.isDisposed()) {
                    winShell.layout(true, true);
                }
            }
        });
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MUIElement)) {
            return;
        }
        MUIElement changedElement = (MUIElement)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)STACK_HIDDEN)) {
                this.hideStack(changedElement);
            } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)STACK_VISIBLE)) {
                this.showStack(changedElement);
            } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)TRIM_STACK_EXIST)) {
                this.createTrim(changedElement);
                changedElement.setVisible(false);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicElementId(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*") Event event) {
        Object changedObject = event.getProperty("ChangedElement");
        if (!(changedObject instanceof MPerspective)) {
            return;
        }
        MPerspective perspective = (MPerspective)changedObject;
        String newID = (String)event.getProperty("NewValue");
        String oldID = (String)event.getProperty("OldValue");
        newID = String.valueOf('(') + newID + ')';
        oldID = String.valueOf('(') + oldID + ')';
        MWindow perspWin = this.modelService.getTopLevelWindowFor((MUIElement)perspective);
        if (perspWin == null) {
            return;
        }
        List trimStacks = this.modelService.findElements((MUIElement)perspWin, null, MToolControl.class, null);
        for (MToolControl trimStack : trimStacks) {
            if (!XTrimStack.CONTRIBUTION_URI_XTRIMSTACK.equals(trimStack.getContributionURI())) continue;
            trimStack.setElementId(trimStack.getElementId().replace(oldID, newID));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicPerspSaved(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perpSaved") Event event) {
        MPerspective savedPersp = (MPerspective)event.getProperty("ChangedElement");
        String cache = this.getTrimCache(savedPersp);
        this.minMaxAddon.getPersistedState().put(savedPersp.getElementId(), cache);
    }

    private String getTrimCache(MPerspective savedPersp) {
        MWindow topWin = this.modelService.getTopLevelWindowFor((MUIElement)savedPersp);
        String perspIdStr = String.valueOf('(') + savedPersp.getElementId() + ')';
        String cache = this.getWinCache(topWin, perspIdStr);
        for (MWindow dw : savedPersp.getWindows()) {
            cache = String.valueOf(cache) + this.getWinCache(dw, perspIdStr);
        }
        return cache;
    }

    private String getWinCache(MWindow win, String perspIdStr) {
        String winStr = "";
        List stackList = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null);
        for (MPartStack stack : stackList) {
            winStr = String.valueOf(winStr) + this.getStackTrimLoc(stack, perspIdStr);
        }
        return winStr;
    }

    private String getStackTrimLoc(MPartStack stack, String perspIdStr) {
        MWindow stackWin = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        MUIElement tcElement = this.modelService.find(String.valueOf(stack.getElementId()) + perspIdStr, (MUIElement)stackWin);
        if (tcElement == null) {
            return "";
        }
        MTrimBar bar = (MTrimBar)tcElement.getParent();
        int sideVal = bar.getSide().getValue();
        int index = bar.getChildren().indexOf(tcElement);
        return String.valueOf(stack.getElementId()) + ' ' + sideVal + ' ' + index + "#";
    }

    @Inject
    @Optional
    private void subscribeTopicPerspReset(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perspReset") Event event, @Optional MApplication application) {
        MPerspective resetPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)resetPersp, null, MUIElement.class, Arrays.asList(TRIM_STACK_EXIST));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
        this.fixToolItemOfRightTrimBarStatus(application);
    }

    @Inject
    @Optional
    private void subscribeTopicPerspOpened(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perspOpened") Event event) {
        MPerspective openedPersp = (MPerspective)event.getProperty("ChangedElement");
        List allStacks = this.modelService.findElements((MUIElement)openedPersp, null, MGenericStack.class, Arrays.asList(TRIM_STACK_EXIST));
        for (MGenericStack stack : allStacks) {
            this.createTrim((MUIElement)stack);
        }
    }

    boolean isEmptyPerspectiveStack(MUIElement element) {
        if (!(element instanceof MPerspectiveStack)) {
            return false;
        }
        MPerspectiveStack ps = (MPerspectiveStack)element;
        return ps.getChildren().size() == 0;
    }

    void hideStack(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (this.isEmptyPerspectiveStack(element)) {
            element.setVisible(false);
            return;
        }
        this.createTrim(element);
        element.setVisible(false);
    }

    void showStack(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        List<MUIElement> elementsToHide = this.getElementsToHide(element);
        for (MUIElement toMinimize : elementsToHide) {
            this.setState(toMinimize, STACK_HIDDEN);
        }
        element.setVisible(true);
    }

    private List<MUIElement> getElementsToHide(MUIElement element) {
        MWindow win = this.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToHide = new ArrayList<MUIElement>();
        int loc = this.modelService.getElementLocation(element);
        if ((loc & 1) != 0) {
            List pStacks;
            List globalStacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null, 1);
            for (MPartStack gStack : globalStacks) {
                if (gStack == element || !gStack.isToBeRendered() || gStack.getWidget() == null || gStack.getTags().contains(STACK_HIDDEN)) continue;
                elementsToHide.add((MUIElement)gStack);
            }
            Object perspStack = null;
            perspStack = persp == null ? ((pStacks = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() > 0 ? (MPerspectiveStack)pStacks.get(0) : null) : persp.getParent();
            if (perspStack != null) {
                if (perspStack.getElementId() == null || perspStack.getElementId().length() == 0) {
                    perspStack.setElementId("PerspectiveStack");
                }
                elementsToHide.add((MUIElement)perspStack);
            }
        } else {
            List stacks = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPartStack.class, null, 11);
            for (MPartStack theStack : stacks) {
                if (theStack == element || !theStack.isToBeRendered() || this.getWindowFor((MUIElement)theStack) != win || (loc = this.modelService.getElementLocation((MUIElement)theStack)) == 8 || theStack.getWidget() == null || !theStack.isVisible() || theStack.getTags().contains(STACK_HIDDEN)) continue;
                elementsToHide.add((MUIElement)theStack);
            }
            ArrayList<String> standaloneTag = new ArrayList<String>();
            standaloneTag.add("Standalone");
            List standaloneViews = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPlaceholder.class, standaloneTag, 11);
            for (MPlaceholder part : standaloneViews) {
                if (!part.isToBeRendered()) continue;
                elementsToHide.add((MUIElement)part);
            }
        }
        return elementsToHide;
    }

    private MWindow getWindowFor(MUIElement element) {
        MElementContainer parent = element.getParent();
        while (parent != null && !(parent instanceof MWindow)) {
            parent = parent.getParent();
        }
        return (MWindow)parent;
    }

    private void createTrim(MUIElement element) {
        MWindow win = this.getWindowFor(element);
        if (!(win instanceof MTrimmedWindow)) {
            return;
        }
        MTrimmedWindow window = (MTrimmedWindow)win;
        Shell winShell = (Shell)window.getWidget();
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = (MToolControl)this.modelService.createModelElement(MToolControl.class);
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(XTrimStack.CONTRIBUTION_URI_XTRIMSTACK);
            trimStack.getTags().add("XTrimStack");
            trimStack.getTags().add("TrimBarLayout:center");
            MTrimBar bar = this.modelService.getTrim(window, SideValue.RIGHT);
            bar.getChildren().add(trimStack);
            bar.setVisible(true);
            if (bar.getWidget() == null) {
                bar.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)bar, (Object)winShell, window.getContext());
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
        }
        trimStack.setToBeRendered(true);
    }

    private String getMinimizedElementSuffix(MUIElement element) {
        String id = ID_SUFFIX;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            id = String.valueOf('(') + persp.getElementId() + ')';
        }
        return id;
    }
}

