/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import java.util.ArrayList;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class XRightTrimBarLayout
extends Layout {
    private static final int MARGIN_LEFT = -2;
    private static final int MARGIN_RIGHT = -2;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 0;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children;
        int width = 0;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point size = child.computeSize(-1, -1, true);
            width = Math.max(width, size.x);
            ++n2;
        }
        width = width + -2 + -2;
        return new Point(width, hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children;
        Rectangle bounds = composite.getBounds();
        bounds.x = -2;
        bounds.y = 20;
        bounds.width -= -4;
        bounds.height -= 20;
        int curX = bounds.x;
        int curY = bounds.y;
        ArrayList<Control> beginingControls = new ArrayList<Control>();
        ArrayList<Control> centerControls = new ArrayList<Control>();
        ArrayList<Control> endControls = new ArrayList<Control>();
        int centerControlsHeight = 0;
        int endControlsHeight = 0;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (this.isBegining(child)) {
                beginingControls.add(child);
            } else if (this.isCenter(child)) {
                centerControls.add(child);
                centerControlsHeight += child.computeSize((int)-1, (int)-1).y;
            } else if (this.isEnd(child)) {
                endControls.add(child);
                endControlsHeight += child.computeSize((int)-1, (int)-1).y;
            } else {
                centerControls.add(child);
                centerControlsHeight += child.computeSize((int)-1, (int)-1).y;
            }
            ++n2;
        }
        for (Control bc : beginingControls) {
            Point size = bc.computeSize(-1, -1);
            bc.setBounds(curX, curY, size.x, size.y);
            curY += size.y;
        }
        curY = Math.max(curY, (bounds.height - centerControlsHeight) / 2);
        for (Control cc : centerControls) {
            Point size = cc.computeSize(-1, -1);
            cc.setBounds(curX, curY, size.x, size.y);
            curY += size.y;
        }
        curY = Math.max(curY, bounds.y + bounds.height - endControlsHeight);
        for (Control ec : endControls) {
            Point size = ec.computeSize(-1, -1);
            ec.setBounds(curX, curY, size.x, size.y);
            curY += size.y;
        }
    }

    private boolean isBegining(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getTags().contains("TrimBarLayout:begining");
    }

    private boolean isCenter(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getTags().contains("TrimBarLayout:center");
    }

    private boolean isEnd(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getTags().contains("TrimBarLayout:end");
    }
}

