/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.core.util.FileUtils;

public class Log
implements ISchedulingRule {
    public static final String SINGLETON = ".singleton";
    public static final String OPENING = ".opening";
    public static final String K_PRIMARY_WINDOW = "PRIMARY_WINDOW";
    private static String lineSeparator = null;
    private File file;
    private Properties properties = null;

    public Log(File file) {
        this.file = file;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    private void loadProperties() {
        this.properties = new Properties();
        if (this.file.isFile() && this.file.canRead()) {
            try {
                FileInputStream is = new FileInputStream(this.file);
                try {
                    this.properties.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                CathyPlugin.log(e, "Failed to load properties from log file: " + this.file.getAbsolutePath());
            }
        }
    }

    public void saveProperties() {
        if (this.properties == null) {
            return;
        }
        FileUtils.ensureFileParent((File)this.file);
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                this.properties.store(out, null);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            CathyPlugin.log(e, "Failed to save properties to log file: " + this.file.getAbsolutePath());
        }
    }

    public String[] getContents() {
        if (!this.file.isFile() || !this.file.canRead()) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ("".equals(line = line.trim())) continue;
                    lines.add(line);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            CathyPlugin.log(e, "Failed to read log file: " + this.file.getAbsolutePath());
        }
        return lines.toArray(new String[lines.size()]);
    }

    public void setContents(String ... contents) {
        this.write(false, contents);
    }

    public void append(String ... lines) {
        if (lines.length == 0) {
            return;
        }
        this.write(true, lines);
    }

    private void write(boolean append, String ... contents) {
        FileUtils.ensureFileParent((File)this.file);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, append), "UTF-8"));
            try {
                String[] stringArray = contents;
                int n = contents.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    writer.write(line);
                    writer.newLine();
                    ++n2;
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            CathyPlugin.log(e, "Failed to write log file: " + this.file.getAbsolutePath());
        }
    }

    public void delete() {
        this.file.delete();
        this.properties = null;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public static Log get(String name) {
        URL url = Platform.getInstanceLocation().getURL();
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {}
        File file = new File(url.getFile(), name);
        Log log = new Log(file);
        return log;
    }

    public static String getLineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator");
        }
        return lineSeparator;
    }

    public boolean contains(ISchedulingRule rule) {
        if (rule == this) {
            return true;
        }
        if (rule instanceof Log) {
            Log log = (Log)rule;
            if (log.file == null || this.file == null) {
                return false;
            }
            return log.file.getAbsolutePath().equals(this.file.getAbsolutePath());
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule == this) {
            return true;
        }
        if (rule instanceof Log) {
            Log log = (Log)rule;
            if (log.file == null || this.file == null) {
                return false;
            }
            return log.file.getAbsolutePath().equals(this.file.getAbsolutePath());
        }
        return false;
    }
}

