/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.imports.document;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.imports.Messages;
import org.xmind.ui.internal.aspose.imports.document.WordImporter;
import org.xmind.ui.wizards.AbstractMindMapImportPage;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;
import org.xmind.ui.wizards.MindMapImporter;

public class WordImportWizard
extends AbstractMindMapImportWizard {
    private static final String SETTINGS_ID = "org.xmind.ui.aspose.import.Word";
    private static final String PAGE_ID = "importWord";
    private static final String DOCUMENT_FILTER = "*.doc;*.docx;*.rtf";
    private static final String DOCUMENT_EXT = "*.doc, *.docx, *.rtf";
    private WordImportPage page;

    public WordImportWizard() {
        IDialogSettings settings = AsposePlugin.getDefault().getDialogSettings().getSection(SETTINGS_ID);
        if (settings == null) {
            settings = AsposePlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_ID);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.WordImportWizard_windowTitle);
    }

    public void addPages() {
        this.page = new WordImportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected MindMapImporter createImporter(String sourcePath, IWorkbook targetWorkbook) {
        return new WordImporter(sourcePath, targetWorkbook);
    }

    protected String getApplicationId() {
        return "Microsoft Word";
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private class WordImportPage
    extends AbstractMindMapImportPage {
        protected WordImportPage() {
            super(WordImportWizard.PAGE_ID, Messages.WordImportPage_title);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            Label tipLabel = new Label(composite, 64);
            GridData tipLabelData = new GridData(1, 4, false, false);
            tipLabelData.widthHint = 450;
            tipLabelData.heightHint = 40;
            tipLabel.setLayoutData((Object)tipLabelData);
            tipLabel.setText(Messages.WordImport_tipLabel);
            Control destinationControl = this.createDestinationControl(composite);
            destinationControl.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateStatus();
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    WordImportPage.this.openBrowseDialog();
                }
            });
        }

        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterExtensions(new String[]{WordImportWizard.DOCUMENT_FILTER});
            dialog.setFilterNames(new String[]{NLS.bind((String)Messages.Document_FilterName, (Object)WordImportWizard.DOCUMENT_EXT)});
            return dialog;
        }
    }
}

