/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.thrift.transport;

import com.evernote.thrift.transport.TTransportException;

public abstract class TTransport {
    public abstract boolean isOpen();

    public boolean peek() {
        return this.isOpen();
    }

    public abstract void open() throws TTransportException;

    public abstract void close();

    public abstract int read(byte[] var1, int var2, int var3) throws TTransportException;

    public int readAll(byte[] buf, int off, int len) throws TTransportException {
        int got = 0;
        int ret = 0;
        while (got < len) {
            ret = this.read(buf, off + got, len - got);
            if (ret <= 0) {
                throw new TTransportException("Cannot read. Remote side has closed. Tried to read " + len + " bytes, but only got " + got + " bytes.");
            }
            got += ret;
        }
        return got;
    }

    public void write(byte[] buf) throws TTransportException {
        this.write(buf, 0, buf.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws TTransportException;

    public void flush() throws TTransportException {
    }

    public byte[] getBuffer() {
        return null;
    }

    public int getBufferPosition() {
        return 0;
    }

    public int getBytesRemainingInBuffer() {
        return -1;
    }

    public void consumeBuffer(int len) {
    }
}

