/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class TitleBorder
extends AbstractLabeledBorder {
    private int textAlignment = 2;
    private int textPlacement = 1;
    private Insets textPadding = new Insets(1, 2, 1, 2);
    private Color fillColor = null;
    private static final Dimension NO_EXTENT = new Dimension(0, 0);

    public TitleBorder() {
        this("");
    }

    public TitleBorder(String s) {
        super(s);
        this.setTextColor(ColorConstants.listForeground);
    }

    protected Insets calculateInsets(IFigure figure) {
        switch (this.getTextPlacement()) {
            case 16: {
                return new Insets(0, this.getTextExtents((IFigure)figure).width + this.getTextPadding().getWidth(), 0, 0);
            }
            case 4: {
                return new Insets(0, 0, this.getTextExtents((IFigure)figure).height + this.getTextPadding().getHeight(), 0);
            }
            case 8: {
                return new Insets(0, 0, 0, this.getTextExtents((IFigure)figure).width + this.getTextPadding().getWidth());
            }
        }
        return new Insets(this.getTextExtents((IFigure)figure).height + this.getTextPadding().getHeight(), 0, 0, 0);
    }

    protected Dimension getTextExtents(IFigure f) {
        if (this.getLabel() == null || "".equals(this.getLabel())) {
            return NO_EXTENT;
        }
        return super.getTextExtents(f);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(TitleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        Insets padding = this.getTextPadding();
        Dimension extent = this.getTextExtents(figure);
        int placement = this.getTextPlacement();
        switch (placement) {
            case 16: {
                TitleBorder.tempRect.width = Math.min(TitleBorder.tempRect.width, extent.width + padding.getWidth());
                break;
            }
            case 4: {
                int h = Math.min(TitleBorder.tempRect.height, extent.height + padding.getHeight());
                TitleBorder.tempRect.y = tempRect.bottom() - h;
                TitleBorder.tempRect.height = h;
                break;
            }
            case 8: {
                int w = Math.min(TitleBorder.tempRect.width, extent.width + padding.getWidth());
                TitleBorder.tempRect.x = tempRect.right() - w;
                TitleBorder.tempRect.width = w;
                break;
            }
            default: {
                TitleBorder.tempRect.height = Math.min(TitleBorder.tempRect.height, extent.height + padding.getHeight());
            }
        }
        graphics.clipRect(tempRect);
        Color bgColor = this.getBackgroundColor();
        if (bgColor != null) {
            graphics.setBackgroundColor(bgColor);
            graphics.fillRectangle(tempRect);
        }
        int x = TitleBorder.tempRect.x + padding.left;
        int y = TitleBorder.tempRect.y + padding.top;
        if (placement == 16 || placement == 8) {
            int freeSpace = TitleBorder.tempRect.height - padding.getHeight() - extent.height;
            switch (this.getTextAlignment()) {
                case 2: {
                    y += freeSpace / 2;
                    break;
                }
                case 32: {
                    y += freeSpace;
                }
            }
        } else {
            int freeSpace = TitleBorder.tempRect.width - padding.getWidth() - extent.width;
            switch (this.getTextAlignment()) {
                case 2: {
                    x += freeSpace / 2;
                    break;
                }
                case 4: {
                    x += freeSpace;
                }
            }
        }
        graphics.setFont(this.getFont(figure));
        graphics.setForegroundColor(this.getTextColor());
        graphics.drawText(this.getLabel(), x, y);
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public int getTextPlacement() {
        return this.textPlacement;
    }

    public Insets getTextPadding() {
        return this.textPadding;
    }

    public Color getBackgroundColor() {
        return this.fillColor;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void setTextPlacement(int textPlacement) {
        this.textPlacement = textPlacement;
        this.invalidate();
    }

    public void setTextPadding(Insets textPadding) {
        this.textPadding = textPadding;
        this.invalidate();
    }

    public void setTextPadding(int all) {
        this.textPadding = new Insets(all);
        this.invalidate();
    }

    public void setBackgroundColor(Color color) {
        this.fillColor = color;
    }
}

