/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.ui.gallery.ContentPane;
import org.xmind.ui.gallery.GalleryLayout;

public class Gallery {
    private FigureCanvas fc;
    private boolean horizontal;
    private boolean wrap;
    private ContentPane contentPane;
    private GalleryLayout layout = new GalleryLayout();

    public Gallery(Composite parent, int style) {
        try {
            this.fc = new FigureCanvas(parent, Gallery.checkStyle(style) | 0x20000000);
        }
        catch (Exception exception) {
            this.fc = new FigureCanvas(parent, 0x20000000);
        }
        this.horizontal = (style & 0x100) != 0;
        this.wrap = (style & 0x40) != 0;
        this.hookControl((Control)this.fc);
        this.createContents();
    }

    private void createContents() {
        this.contentPane = new ContentPane(this.horizontal, false, this.wrap);
        this.fc.setContents((IFigure)this.contentPane);
        this.relayout();
    }

    protected void hookControl(Control c) {
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Gallery.this.handleDispose(e);
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 832;
        return style &= ~mask;
    }

    public FigureCanvas getControl() {
        return this.fc;
    }

    public ContentPane getContentPane() {
        return this.contentPane;
    }

    public GalleryLayout getLayout() {
        return this.layout;
    }

    public void setLayout(GalleryLayout layout) {
        if (layout == null || layout == this.layout) {
            return;
        }
        this.layout = layout;
        this.relayout();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void clearContents() {
        this.contentPane.removeAll();
    }

    public int indexOf(IFigure frame) {
        return this.contentPane.getChildren().indexOf(frame);
    }

    public void addFrame(IFigure frame) {
        this.addFrame(frame, -1);
    }

    public void addFrame(IFigure frame, int index) {
        this.contentPane.add(frame, index);
    }

    public void removeFrame(IFigure frame) {
        this.contentPane.remove(frame);
    }

    public void removeFrame(int index) {
        IFigure slide = this.getFrame(index);
        if (slide != null) {
            this.removeFrame(slide);
        }
    }

    public IFigure getFrame(int index) {
        if (index < 0) {
            return null;
        }
        List slides = this.contentPane.getChildren();
        if (index >= slides.size()) {
            return null;
        }
        return (IFigure)slides.get(index);
    }

    public boolean isStretchMinorAxis() {
        return this.layout.minorAlignment == 3;
    }

    public void refresh() {
        this.relayout();
    }

    protected void relayout() {
        this.contentPane.setMajorAlignment(this.layout.majorAlignment);
        this.contentPane.setMinorAlignment(this.layout.minorAlignment);
        this.contentPane.setMajorSpacing(this.layout.majorSpacing);
        this.contentPane.setMinorSpacing(this.layout.minorSpacing);
        this.contentPane.setBorder((Border)new MarginBorder(this.layout.getMargins()));
        this.contentPane.revalidate();
        if (this.horizontal) {
            this.fc.getViewport().setContentsTracksWidth(this.wrap);
            this.fc.getViewport().setContentsTracksHeight(this.isStretchMinorAxis());
        } else {
            this.fc.getViewport().setContentsTracksHeight(this.wrap);
            this.fc.getViewport().setContentsTracksWidth(this.isStretchMinorAxis());
        }
    }

    public void centerHorizontal() {
        if (this.fc.isDisposed()) {
            return;
        }
        RangeModel horizontal = this.fc.getViewport().getHorizontalRangeModel();
        int h = (horizontal.getMaximum() - horizontal.getExtent() + horizontal.getMinimum()) / 2;
        this.fc.scrollToX(h);
    }

    protected void handleDispose(DisposeEvent e) {
    }
}

