/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import org.eclipse.jface.action.Action;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IDisposable2;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public abstract class EditorAction
extends Action
implements IDisposable2 {
    private IGraphicalEditor editor;

    protected EditorAction(IGraphicalEditor editor) {
        this.editor = editor;
    }

    protected EditorAction(String id, IGraphicalEditor editor) {
        this(editor);
        this.setId(id);
    }

    protected IGraphicalEditor getEditor() {
        return this.editor;
    }

    protected ICommandStack getCommandStack() {
        return this.editor == null ? null : this.editor.getCommandStack();
    }

    protected void saveAndRun(Command command) {
        ICommandStack cs = this.getCommandStack();
        if (cs != null) {
            cs.execute(command);
        }
    }

    protected IGraphicalEditorPage getActivePage() {
        return this.editor == null ? null : this.editor.getActivePageInstance();
    }

    protected IGraphicalViewer getActiveViewer() {
        IGraphicalEditorPage page = this.getActivePage();
        return page == null ? null : page.getViewer();
    }

    protected EditDomain getActiveEditDomain() {
        IGraphicalViewer viewer = this.getActiveViewer();
        return viewer == null ? null : viewer.getEditDomain();
    }

    protected ITool getActiveTool() {
        EditDomain domain = this.getActiveEditDomain();
        return domain == null ? null : domain.getActiveTool();
    }

    protected void performRequest(String request) {
        EditDomain domain = this.getActiveEditDomain();
        if (domain != null) {
            domain.handleRequest(request, (IViewer)this.getActiveViewer());
        }
    }

    protected void performRequest(Request request) {
        EditDomain domain = this.getActiveEditDomain();
        if (domain != null) {
            domain.handleRequest(request);
        }
    }

    public boolean isDisposed() {
        return this.editor == null;
    }

    public void dispose() {
        this.editor = null;
    }
}

