/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.ITopic;
import org.xmind.core.audio.AudioValues;
import org.xmind.ui.internal.audionotes.AudioNotesAgent;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesUtils;
import org.xmind.ui.internal.audionotes.AudioNotesViewerPage;
import org.xmind.ui.internal.audionotes.IAudioNotesAgentListener;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.internal.audionotes.ProgressComposite;

public class AudioNotesViewer2 {
    private ITopic sourceTopic;
    private Control control;
    private Map<Integer, AudioNotesViewerPage> pagesMap = new HashMap<Integer, AudioNotesViewerPage>();
    private boolean detached = false;

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        StackLayout layout = new StackLayout();
        composite.setLayout((Layout)layout);
        PlayPage playPage = new PlayPage(this);
        ((AudioNotesViewerPage)playPage).createControl(composite);
        this.pagesMap.put(1, playPage);
        DisplayPage displayPage = new DisplayPage(this);
        displayPage.createControl(composite);
        this.pagesMap.put(4, displayPage);
        InvalidSelectionPage invalidPage = new InvalidSelectionPage(this);
        invalidPage.createControl(composite);
        this.pagesMap.put(8, invalidPage);
        layout.topControl = this.sourceTopic != null ? this.pagesMap.get(1).getControl() : this.pagesMap.get(8).getControl();
        this.control = composite;
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AudioNotesViewer2.this.dispose();
            }
        });
        return composite;
    }

    public void dispose() {
        this.setSourceTopic(null);
        AudioNotesPlugin.getDefault().getAgent().windowOpened = false;
        for (AudioNotesViewerPage page : this.pagesMap.values()) {
            page.dispose();
        }
    }

    public void setSelection(ISelection selection, ISelectionProvider provider) {
        this.setSourceTopic(AudioNotesViewer2.findTopic(selection));
    }

    public void update(int page) {
    }

    public static ITopic findTopic(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
            return (ITopic)o;
        }
        return null;
    }

    public Control getControl() {
        return this.control;
    }

    public void setSourceTopic(ITopic topic) {
        if (topic == this.sourceTopic) {
            return;
        }
        ITopic oldTopic = this.sourceTopic;
        this.sourceTopic = topic;
        for (Integer i : this.pagesMap.keySet()) {
            this.pagesMap.get(i).setSourceTopic(topic);
        }
        if (oldTopic != null) {
            this.unhookTopic(oldTopic);
        }
        if (topic != null) {
            this.hookTopic(topic);
        }
        if (topic != null) {
            if (AudioNotesViewer2.hasAudioNotes(topic)) {
                this.showPage(1);
            } else {
                this.showPage(4);
            }
        } else {
            this.showPage(8);
        }
    }

    private void hookTopic(ITopic topic) {
    }

    public void showPage(int type) {
        Composite composite = (Composite)this.getControl();
        StackLayout layout = (StackLayout)composite.getLayout();
        AudioNotesViewerPage page = this.pagesMap.get(type);
        page.setSourceTopic(this.sourceTopic);
        layout.topControl = page.getControl();
        composite.layout(true);
    }

    private void unhookTopic(ITopic topic) {
    }

    private static boolean hasAudioNotes(ITopic topic) {
        return topic != null && AudioNotesUtils.getAudioEntryPath(topic) != null;
    }

    ITopic getSourceTopic() {
        return this.sourceTopic;
    }

    void resetLeftLabel() {
        PlayPage page = (PlayPage)this.pagesMap.get(1);
        page.leftLabel.setText(AudioNotesUtils.formatTime(0L));
    }

    class DisplayPage
    extends AudioNotesViewerPage {
        public DisplayPage(AudioNotesViewer2 viewer) {
            this.type = 4;
            this.viewer = viewer;
        }

        protected AudioNotesViewerPage.ContentComposite createContentComposite(Composite parent) {
            ProgressComposite progressBar = new ProgressComposite(parent, 256);
            progressBar.getControl().setEnabled(false);
            return progressBar;
        }

        protected void configImageButton() {
            super.configImageButton();
            this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/play.png"));
        }

        public void update(int type, Object source) {
            if (!(source instanceof ITopic)) {
                return;
            }
            ITopic topic = (ITopic)source;
            if ((type & 1) != 0) {
                this.mainLabel.setText(topic.getTitleText());
                this.leftLabel.setText(AudioNotesUtils.formatTime(0L));
                this.rightLabel.setText(AudioNotesUtils.formatFileSize("0"));
            }
        }
    }

    class InvalidSelectionPage
    extends AudioNotesViewerPage {
        public InvalidSelectionPage(AudioNotesViewer2 viewer) {
            this.type = 8;
            this.viewer = viewer;
        }

        protected AudioNotesViewerPage.ContentComposite createContentComposite(Composite parent) {
            ProgressComposite progressBar = new ProgressComposite(parent, 256);
            progressBar.getControl().setEnabled(false);
            return progressBar;
        }

        protected void configImageButton() {
            super.configImageButton();
            this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/play.png"));
        }

        public void update(int eventType, Object obj) {
            if ((1 & eventType) != 0) {
                if (this.mainLabel.getImage() == null) {
                    final Image invalidImage = AudioNotesPlugin.imageFrom("/icons/invalid_select.png").createImage();
                    this.mainLabel.setImage(invalidImage);
                    this.getControl().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            invalidImage.dispose();
                        }
                    });
                }
                this.secondaryLabel.setText("Invalid Topic Selected");
                this.leftLabel.setText(AudioNotesUtils.formatTime(0L));
                this.rightLabel.setText(AudioNotesUtils.formatFileSize("0"));
            }
        }
    }

    class PlayPage
    extends AudioNotesViewerPage
    implements IAudioNotesAgentListener {
        public PlayPage(AudioNotesViewer2 viewer) {
            this.type = 1;
            this.viewer = viewer;
        }

        protected Control createControl(Composite parent) {
            Control control = super.createControl(parent);
            AudioNotesPlugin.getDefault().getAgent().addAudioListener(this);
            return control;
        }

        protected AudioNotesViewerPage.ContentComposite createContentComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, true);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginBottom = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            ProgressComposite levelMeter = new ProgressComposite(composite, 256);
            levelMeter.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!(event.getSelection() instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                    agent.pauseAt = (Double)selection.getFirstElement();
                    if (agent.pauseAt != -1.0) {
                        agent.jumpTo(agent.pauseAt);
                    }
                }
            });
            return levelMeter;
        }

        protected void configImageButton() {
            super.configImageButton();
            this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/start_play.png"));
            this.imageButton.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                    if (PlayPage.isRecording()) {
                        agent.pauseAt = -1.0;
                        agent.stop();
                    } else if (PlayPage.isPlaying() && agent.getPlayingTopic().equals(PlayPage.this.sourceTopic)) {
                        agent.pauseAt = agent.getCurrentRate(PlayPage.this.sourceTopic);
                        agent.stop();
                    } else {
                        ITopic topic = PlayPage.this.sourceTopic;
                        if (topic != null) {
                            agent.startPlay(topic);
                            if (agent.pauseAt != -1.0) {
                                agent.jumpTo(agent.pauseAt);
                            }
                        }
                    }
                }
            });
        }

        public void started(ITopic topic, boolean recordOrPlayback) {
            if (!recordOrPlayback) {
                AudioNotesViewer2.this.detached = false;
                this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/stop_playing.png"));
                this.imageLabel.setText(Messages.AudioNotesViewerPage_Image_Label_Pause);
                this.content.getControl().setEnabled(true);
                String duration = AudioNotesUtils.formatTime(AudioNotesUtils.getDuration(topic));
                duration = duration == null ? AudioNotesUtils.formatTime(0L) : duration;
                this.rightLabel.setText(duration);
            }
        }

        public void stopped(ITopic topic, boolean recordOrPlayback) {
            if (topic == null) {
                return;
            }
            if (!recordOrPlayback) {
                long totalSeconds;
                AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                if (this.imageButton != null && !this.imageButton.getControl().isDisposed()) {
                    this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/start_play.png"));
                }
                if (this.imageLabel != null && !this.imageLabel.isDisposed()) {
                    this.imageLabel.setText(Messages.AudioNotesViewerPage_Image_Label);
                }
                if ((totalSeconds = agent.getTotalSeconds(this.sourceTopic)) > 0L && agent.getCurrentRate(this.sourceTopic) >= (double)((totalSeconds - 1L) / totalSeconds) || totalSeconds == 0L && AudioNotesUtils.getDuration(this.sourceTopic) != null) {
                    agent.pauseAt = -1.0;
                    if (this.content != null) {
                        this.content.setSelection(0.0);
                    }
                    if (this.leftLabel != null && !this.leftLabel.isDisposed()) {
                        this.leftLabel.setText(AudioNotesUtils.formatTime(0L));
                    }
                    if (this.rightLabel != null && !this.rightLabel.isDisposed() && this.sourceTopic != null) {
                        this.rightLabel.setText(AudioNotesUtils.formatFileSize(AudioNotesUtils.getFileSize(this.sourceTopic)));
                    }
                    if (this.content != null && !this.content.getControl().isDisposed()) {
                        this.content.getControl().setEnabled(false);
                    }
                }
            }
        }

        public void valuesChanged(ITopic topic, AudioValues values, boolean recordOrPlayback) {
            if (!this.leftLabel.isDisposed()) {
                if (!recordOrPlayback && !AudioNotesViewer2.this.detached) {
                    this.content.setSelection((double)values.time / (double)values.duration);
                    this.leftLabel.setText(AudioNotesUtils.formatTime(values.time));
                } else {
                    this.content.setSelection(0.0);
                    this.leftLabel.setText(AudioNotesUtils.formatTime(0L));
                }
            }
        }

        public void dispose() {
            super.dispose();
            AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
            agent.removeAudioListener(this);
        }

        public void update(int eventType, Object obj) {
            if (!(obj instanceof ITopic)) {
                return;
            }
            AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
            if ((1 & eventType) != 0) {
                ITopic topic = (ITopic)obj;
                if (topic != null && agent.getPlayingTopic() != null && topic.getId().equals(agent.getPlayingTopic().getId())) {
                    AudioNotesViewer2.this.detached = false;
                    if (agent.isPlaying()) {
                        this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/stop_playing.png"));
                        this.imageLabel.setText(Messages.AudioNotesViewerPage_Image_Label_Pause);
                        this.content.getControl().setEnabled(true);
                    } else if ((Double)((IStructuredSelection)this.content.getSelection()).getFirstElement() > 0.0) {
                        this.content.setSelection(0.0);
                        agent.startPlay(agent.getPlayingTopic());
                        agent.jumpTo(1.0);
                        this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/start_play.png"));
                        this.imageLabel.setText(Messages.AudioNotesDialog_Button_Start);
                        this.content.getControl().setEnabled(false);
                    }
                } else if (agent.isPlaying() && AudioNotesViewer2.hasAudioNotes(topic)) {
                    AudioNotesViewer2.this.detached = true;
                    this.imageButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom("/icons/start_play.png"));
                    this.imageLabel.setText(Messages.AudioNotesDialog_Button_Start);
                    this.content.getControl().setEnabled(true);
                } else if (AudioNotesViewer2.hasAudioNotes(topic) && (Double)((IStructuredSelection)this.content.getSelection()).getFirstElement() > 0.0) {
                    this.content.setSelection(0.0);
                    agent.startPlay(topic);
                    agent.jumpTo(1.0);
                    this.content.getControl().setEnabled(false);
                }
                String titleText = topic.getTitleText();
                this.mainLabel.setText(titleText);
                String secondaryLabelText = AudioNotesUtils.getRecordTime(topic);
                if (secondaryLabelText == null || "".equals(secondaryLabelText)) {
                    secondaryLabelText = "--:--";
                } else {
                    try {
                        secondaryLabelText = new SimpleDateFormat("hh:mm:ss a, MMM d yyyy").parse(secondaryLabelText).toLocaleString();
                    }
                    catch (Exception exception) {
                        secondaryLabelText = "--:--";
                    }
                }
                this.secondaryLabel.setText(secondaryLabelText);
                this.leftLabel.setText(AudioNotesUtils.formatTime(0L));
                String duration = AudioNotesUtils.formatTime(AudioNotesUtils.getDuration(topic));
                duration = duration == null ? AudioNotesUtils.formatTime(0L) : duration;
                this.rightLabel.setText(duration);
            }
        }
    }
}

