/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.IWordContext;
import org.xmind.ui.IWordContextProvider;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.internal.spelling.SpellingPlugin;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.PrefUtils;

public class SpellingCheckDialog
extends Dialog
implements IJobChangeListener,
IPartListener {
    private static final int OPTIONS_BUTTON_ID = 1025;
    private static String preferenceID = "org.xmind.ui.SpellingCheckPrefPage";
    private TreeViewer viewer;
    StyledText textWidget;
    private IWordContextProvider provider;
    private Button ignoreButton;
    private Button ignoreAllButton;
    private Button addToDictionaryButton;
    private Button changeButton;
    private Button changeAllButton;
    private Button scanWorkbookBt;
    private static List<WordItem> errorList = new LinkedList<WordItem>();
    private ResourceManager resources;

    public SpellingCheckDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(3312);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                SpellingCheckDialog.this.scanWorkbook();
            }
        });
        newShell.setText(Messages.SpellingCheckDialog_title);
    }

    protected void initializeBounds() {
        this.getShell().setBounds(300, 150, 516, 600);
        super.initializeBounds();
    }

    protected Control createDialogArea(Composite parent) {
        SpellingPlugin.getDefault().getUsageDataCollector().increase("SpellingCheckCount");
        Composite composite = (Composite)super.createDialogArea(parent);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createDescriptionArea(composite);
        this.createSeparator(composite);
        Composite content = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 14;
        layout.marginTop = 10;
        layout.marginBottom = 0;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 0;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(1808));
        this.createResultComposite(content);
        this.createSeparator(composite);
        SpellingViewContent.getInstance().addDialog(this);
        CheckSpellingJob.getInstance().addJobChangeListener(this);
        return composite;
    }

    private void createDescriptionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 14;
        gridLayout.marginHeight = 21;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label discriptionLabel = new Label(composite, 64);
        GridData discriptionLabelData = new GridData(4, 0x1000000, true, true);
        discriptionLabel.setLayoutData((Object)discriptionLabelData);
        discriptionLabel.setAlignment(16384);
        discriptionLabel.setText(Messages.SpellingCheckDialog_description);
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#cfcfcf")));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 1;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
    }

    private void createResultComposite(Composite parent) {
        Composite incorrectWordComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        incorrectWordComposite.setLayout((Layout)layout);
        incorrectWordComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(incorrectWordComposite, 0);
        label.setBackground(incorrectWordComposite.getBackground());
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText(Messages.SpellingCheckDialog_Result_NoDictionary_label);
        Composite textComposite = new Composite(incorrectWordComposite, 0);
        textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        textComposite.setBackground(incorrectWordComposite.getBackground());
        GridLayout layout2 = new GridLayout(1, true);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.verticalSpacing = 0;
        layout2.horizontalSpacing = 0;
        textComposite.setLayout((Layout)layout2);
        this.textWidget = new StyledText(textComposite, 2114);
        this.textWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textWidget.setEditable(false);
        this.textWidget.setEnabled(false);
        Composite buttonBar = new Composite(incorrectWordComposite, 0);
        buttonBar.setBackground(incorrectWordComposite.getBackground());
        buttonBar.setLayoutData((Object)new GridData(131072, 1024, true, false));
        GridLayout buttonLayout = new GridLayout(3, false);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginTop = 5;
        buttonLayout.marginWidth = 0;
        buttonLayout.verticalSpacing = 0;
        buttonLayout.horizontalSpacing = 20;
        buttonBar.setLayout((Layout)buttonLayout);
        this.ignoreButton = new Button(buttonBar, 8);
        this.setButtonLayoutData(this.ignoreButton);
        this.ignoreButton.setText(Messages.SpellingCheckDialog_Result_Ignore_button);
        this.ignoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpellingCheckDialog.this.ignore();
            }
        });
        this.ignoreAllButton = new Button(buttonBar, 8);
        this.setButtonLayoutData(this.ignoreAllButton);
        this.ignoreAllButton.setText(Messages.SpellingCheckDialog_Result_IgnoreAll_button);
        this.ignoreAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpellingCheckDialog.this.ignoreAll();
            }
        });
        this.addToDictionaryButton = new Button(buttonBar, 8);
        this.addToDictionaryButton.setText(Messages.SpellingCheckDialog_Result_AddToDictionary_button);
        this.addToDictionaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpellingCheckDialog.this.addToDictionary();
            }
        });
        Composite suggestionComposite = new Composite(parent, 0);
        suggestionComposite.setBackground(parent.getBackground());
        suggestionComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout3 = new GridLayout(1, true);
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        layout3.marginBottom = 20;
        layout3.verticalSpacing = 10;
        layout3.horizontalSpacing = 0;
        suggestionComposite.setLayout((Layout)layout3);
        Label suggestionLabel = new Label(suggestionComposite, 0);
        suggestionLabel.setText(Messages.SpellingCheckDialog_Result_Suggestions_label);
        this.viewer = new TreeViewer(suggestionComposite, 67588);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTree().setLinesVisible(false);
        this.viewer.getTree().setHeaderVisible(false);
        this.viewer.setContentProvider((IContentProvider)new SpellingCheckContentProvider());
        TreeColumn col1 = new TreeColumn(this.viewer.getTree(), 131072);
        col1.setWidth(300);
        this.viewer.setAutoExpandLevel(1);
        Composite suggestionButtonBar = new Composite(suggestionComposite, 0);
        suggestionButtonBar.setBackground(suggestionComposite.getBackground());
        suggestionButtonBar.setLayoutData((Object)new GridData(131072, 1024, true, false));
        GridLayout buttonLayout2 = new GridLayout(2, false);
        buttonLayout2.marginHeight = 0;
        buttonLayout2.marginTop = 5;
        buttonLayout2.marginWidth = 0;
        buttonLayout2.verticalSpacing = 0;
        buttonLayout2.horizontalSpacing = 20;
        suggestionButtonBar.setLayout((Layout)buttonLayout2);
        this.changeButton = new Button(suggestionButtonBar, 8);
        this.setButtonLayoutData(this.changeButton);
        this.changeButton.setText(Messages.SpellingCheckDialog_Result_Change_button);
        this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SpellingCheckDialog.this.viewer.getSelection();
                if (errorList != null && !errorList.isEmpty() && selection instanceof StructuredSelection) {
                    StructuredSelection st = (StructuredSelection)selection;
                    ReplaceAction action = new ReplaceAction((WordItem)errorList.remove(0), st.getFirstElement().toString());
                    action.run();
                }
                SpellingCheckDialog.this.refresh();
            }
        });
        this.changeAllButton = new Button(suggestionButtonBar, 8);
        this.setButtonLayoutData(this.changeAllButton);
        this.changeAllButton.setText(Messages.SpellingCheckDialog_Result_ChangeAll_button);
        this.changeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SpellingCheckDialog.this.viewer.getSelection();
                if (errorList != null && !errorList.isEmpty() && selection instanceof StructuredSelection) {
                    ArrayList<WordItem> waitDelete = new ArrayList<WordItem>();
                    StructuredSelection st = (StructuredSelection)selection;
                    String suggestion = st.getFirstElement().toString();
                    String invalidWord = ((WordItem)errorList.get((int)0)).invalidWord;
                    for (WordItem item : errorList) {
                        if (!invalidWord.equals(item.invalidWord)) continue;
                        waitDelete.add(item);
                        ReplaceAction action = new ReplaceAction(item, suggestion);
                        action.run();
                    }
                    for (WordItem item : waitDelete) {
                        errorList.remove(item);
                    }
                }
                SpellingCheckDialog.this.refresh();
            }
        });
    }

    private void ignore() {
        if (errorList.isEmpty()) {
            return;
        }
        WordItem item = errorList.remove(0);
        IgnoredWordsStorage ignoreInstance = IgnoredWordsStorage.getInstance();
        ignoreInstance.addIgnoreWord(item);
        this.refresh();
    }

    private void ignoreAll() {
        if (errorList.isEmpty()) {
            return;
        }
        WordItem item = errorList.get(0);
        IgnoredWordsStorage ignoreInstance = IgnoredWordsStorage.getInstance();
        ignoreInstance.addIgnoreAllWord(item, this.provider);
        this.scanWorkbook();
    }

    private void addToDictionary() {
        if (errorList.isEmpty()) {
            return;
        }
        AddToDictionaryAction addToDic = new AddToDictionaryAction(errorList.get(0));
        addToDic.run();
        this.scanWorkbook();
    }

    public void scanWorkbook() {
        errorList.clear();
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SpellingCheckView_dialogTitle, (String)Messages.SpellingCheckView_NoEditors_message);
            return;
        }
        this.provider = (IWordContextProvider)editor.getAdapter(IWordContextProvider.class);
        if (this.provider == null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SpellingCheckView_dialogTitle, (String)Messages.SpellingCheckView_NoProviders_message);
            return;
        }
        CheckSpellingJob.start(this.provider);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 13;
        layout.marginHeight = 23;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createOptionsButton(composite);
        Composite buttonBar = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 0;
        layout2.makeColumnsEqualWidth = false;
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout2.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonBar.setLayout((Layout)layout2);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        buttonBar.setFont(parent.getFont());
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    private void createOptionsButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)gridLayout);
        this.createButton(composite, 1025, Messages.SpellingCheckDialog_ButtonBar_Options_button, false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.close();
        } else if (1025 == buttonId) {
            PrefUtils.openPrefDialog((Shell)this.getParentShell(), (String)preferenceID);
        }
    }

    public int open() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this);
        return super.open();
    }

    public boolean close() {
        SpellingViewContent.getInstance().removeDialog(this);
        CheckSpellingJob.getInstance().removeJobChangeListener(this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this);
        return super.close();
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(final IJobChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (event.getResult().isOK()) {
                    SpellingViewContent.getInstance().setInput(((CheckSpellingJob)event.getJob()).getInput());
                }
            }
        });
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void inputChanged(IWordContextProvider input) {
        this.clearIgnoredWord();
        this.refresh();
    }

    private void clearIgnoredWord() {
        if (errorList != null) {
            IgnoredWordsStorage ignoreInstance = IgnoredWordsStorage.getInstance();
            ArrayList<WordItem> waitToDelete = new ArrayList<WordItem>();
            for (WordItem item : errorList) {
                if (!ignoreInstance.isIgnored(item, this.provider)) continue;
                waitToDelete.add(item);
            }
            for (WordItem item : waitToDelete) {
                errorList.remove(item);
            }
        }
    }

    private void refresh() {
        if (!errorList.isEmpty()) {
            IWordContext wordContext = SpellingCheckDialog.errorList.get((int)0).parent;
            wordContext.reveal();
            this.textWidget.setText(wordContext.getContent());
            List<Object> suggestions = SpellingCheckDialog.errorList.get((int)0).suggestions;
            this.viewer.setInput(suggestions);
            if (suggestions != null && !suggestions.isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(SpellingCheckDialog.errorList.get((int)0).suggestions.get(0)));
                this.changeButton.setEnabled(true);
                this.changeAllButton.setEnabled(true);
            } else {
                this.changeButton.setEnabled(false);
                this.changeAllButton.setEnabled(false);
            }
            String fullText = SpellingCheckDialog.errorList.get((int)0).parent.getContent();
            String errorText = SpellingCheckDialog.errorList.get((int)0).invalidWord;
            StyleRange range = new StyleRange();
            range.fontStyle = 1;
            range.foreground = ColorUtils.getColor((int)255, (int)0, (int)0);
            range.start = fullText.indexOf(errorText);
            range.length = errorText.length();
            StyleRange[] styleRanges = this.textWidget.getStyleRanges();
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(styleRanges.length + 1);
            StyleRange[] styleRangeArray = styleRanges;
            int n = styleRanges.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange ran = styleRangeArray[n2];
                ranges.add(ran);
                ++n2;
            }
            ranges.add(range);
            styleRanges = new StyleRange[ranges.size()];
            ranges.toArray(styleRanges);
            this.textWidget.setStyleRanges(styleRanges);
            this.ignoreButton.setEnabled(true);
            this.ignoreAllButton.setEnabled(true);
            this.addToDictionaryButton.setEnabled(true);
        } else {
            this.textWidget.setText(Messages.SpellingCheckDialog_Result_NoError_label);
            this.textWidget.setStyleRanges(new StyleRange[0]);
            this.ignoreButton.setEnabled(false);
            this.ignoreAllButton.setEnabled(false);
            this.addToDictionaryButton.setEnabled(false);
            this.viewer.setInput(Collections.emptyList());
            this.changeButton.setEnabled(false);
            this.changeAllButton.setEnabled(false);
        }
        if (this.scanWorkbookBt != null && !this.scanWorkbookBt.isDisposed()) {
            this.scanWorkbookBt.setEnabled(!errorList.isEmpty());
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.scanWorkbook();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.scanWorkbook();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private static class AddToDictionaryAction
    extends Action {
        private WordItem item;

        public AddToDictionaryAction(WordItem item) {
            this.item = item;
            this.setText(Messages.addToDictionary);
        }

        public void run() {
            SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

                public void handleWith(SpellChecker spellChecker) {
                    spellChecker.addToDictionary(((AddToDictionaryAction)AddToDictionaryAction.this).item.invalidWord);
                }
            });
        }
    }

    private static class CheckSpellingJob
    extends Job
    implements SpellCheckListener {
        private static final CheckSpellingJob instance = new CheckSpellingJob();
        private IWordContextProvider input = null;
        private SpellChecker spellChecker = null;
        private IWordContext currentWordContextItem = null;

        private CheckSpellingJob() {
            super(Messages.CheckSpellingJob_name);
        }

        public void setInput(IWordContextProvider input) {
            this.input = input;
        }

        public IWordContextProvider getInput() {
            return this.input;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.spellChecker = null;
            SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

                public void handleWith(SpellChecker theSpellChecker) {
                    CheckSpellingJob.this.spellChecker = theSpellChecker;
                }
            });
            while (this.spellChecker == null) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask(Messages.CheckSpellingJob_task_Scanning, this.input.getWordContexts().size());
            SpellChecker theSpellChecker = this.spellChecker;
            theSpellChecker.addSpellCheckListener((SpellCheckListener)this);
            try {
                for (IWordContext context : this.input.getWordContexts()) {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.subTask(context.getContent());
                    this.scan((IProgressMonitor)new SubProgressMonitor(monitor, 1), context);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.worked(1);
                }
            }
            finally {
                theSpellChecker.removeSpellCheckListener((SpellCheckListener)this);
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private void scan(IProgressMonitor monitor, IWordContext context) {
            monitor.beginTask(null, 1);
            String content = context.getContent();
            if (monitor.isCanceled()) {
                return;
            }
            this.currentWordContextItem = context;
            this.spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer(content));
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }

        public void spellingError(SpellCheckEvent event) {
            errorList.add(new WordItem(this.currentWordContextItem, event));
        }

        public static CheckSpellingJob getInstance() {
            return instance;
        }

        public static void start(IWordContextProvider input) {
            instance.setInput(input);
            instance.schedule();
        }
    }

    private static class IgnoredWordsStorage {
        private Map<IWordContextProvider, Set<String>> workbookIgnores = new HashMap<IWordContextProvider, Set<String>>();
        private Map<IWordContext, Set<String>> wordContextIgnores = new HashMap<IWordContext, Set<String>>();
        private static IgnoredWordsStorage instance;

        private IgnoredWordsStorage() {
        }

        public static IgnoredWordsStorage getInstance() {
            if (instance == null) {
                instance = new IgnoredWordsStorage();
            }
            return instance;
        }

        public void addIgnoreAllWord(WordItem wordItem, IWordContextProvider provider) {
            Set<String> ignoredWords = this.workbookIgnores.get(provider);
            if (ignoredWords == null) {
                ignoredWords = new HashSet<String>(10);
            }
            ignoredWords.add(wordItem.invalidWord);
            this.workbookIgnores.put(provider, ignoredWords);
        }

        public void addIgnoreWord(WordItem wordItem) {
            Set<String> ignoredWords = this.wordContextIgnores.get(wordItem.parent);
            if (ignoredWords == null) {
                ignoredWords = new HashSet<String>(5);
            }
            ignoredWords.add(wordItem.invalidWord);
            this.wordContextIgnores.put(wordItem.parent, ignoredWords);
        }

        public boolean isIgnored(WordItem wordItem, IWordContextProvider provider) {
            Set<String> ignoreWords = this.workbookIgnores.get(provider);
            if (ignoreWords != null && ignoreWords.contains(wordItem.invalidWord)) {
                return true;
            }
            ignoreWords = this.wordContextIgnores.get(wordItem.parent);
            return ignoreWords != null && ignoreWords.contains(wordItem.invalidWord);
        }
    }

    private static class ReplaceAction
    extends Action {
        private WordItem item;
        private String suggestion;

        public ReplaceAction(WordItem item, String suggestion) {
            this.item = item;
            this.suggestion = suggestion;
            this.setText(String.valueOf(item.invalidWord) + " -> " + suggestion);
        }

        public void run() {
            this.item.parent.replaceWord(this.item.start, this.item.invalidWord.length(), this.suggestion);
        }
    }

    private static class SpellingCheckContentProvider
    implements ITreeContentProvider {
        private SpellingCheckContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List list;
            if (inputElement instanceof List && !(list = (List)inputElement).isEmpty()) {
                return list.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private static class SpellingViewContent {
        private static final SpellingViewContent instance = new SpellingViewContent();
        private IWordContextProvider input = null;
        private List<SpellingCheckDialog> dialogs = new ArrayList<SpellingCheckDialog>();

        private SpellingViewContent() {
        }

        public void addDialog(SpellingCheckDialog dialog) {
            this.dialogs.add(dialog);
        }

        public void setInput(IWordContextProvider input) {
            this.input = input;
            this.fireInputChanged();
        }

        private void fireInputChanged() {
            Object[] objectArray = this.dialogs.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object dialog = objectArray[n2];
                ((SpellingCheckDialog)((Object)dialog)).inputChanged(this.input);
                ++n2;
            }
        }

        public static SpellingViewContent getInstance() {
            return instance;
        }

        public void removeDialog(SpellingCheckDialog spellingDialog) {
            this.dialogs.remove((Object)spellingDialog);
        }
    }

    private static class WordItem {
        public IWordContext parent;
        public int start;
        public String invalidWord;
        public List<Object> suggestions;

        public WordItem(IWordContext parent, SpellCheckEvent range) {
            this.parent = parent;
            this.start = range.getWordContextPosition();
            this.invalidWord = range.getInvalidWord();
            this.suggestions = range.getSuggestions();
        }
    }
}

