/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.Map;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.AbstractRefCounter;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.util.IMarkerRefCounter;

public class WorkbookMarkerRefCounter
extends AbstractRefCounter
implements IMarkerRefCounter {
    private WorkbookImpl workbook;
    private Map<IMarker, IMarkerGroup> groupCache;

    WorkbookMarkerRefCounter(WorkbookImpl workbook) {
        this.workbook = workbook;
        this.groupCache = new HashMap<IMarker, IMarkerGroup>();
    }

    protected Object findResource(String resourceId) {
        return this.workbook.getMarkerSheet().findMarker(resourceId);
    }

    protected void postIncreaseRef(String resourceId, Object resource) {
        IMarker marker = (IMarker)resource;
        MarkerSheetImpl markerSheet = this.workbook.getMarkerSheet();
        if (markerSheet.equals(marker.getOwnedSheet())) {
            IMarkerGroup group;
            IFileEntry entry;
            String resourcePath = marker.getResourcePath();
            if (resourcePath != null && (entry = this.workbook.getManifest().getFileEntry("markers/" + resourcePath)) != null) {
                entry.increaseReference();
            }
            if ((group = marker.getParent()) == null && (group = this.groupCache.get(marker)) != null) {
                group.addMarker(marker);
            }
            if (group != null) {
                this.groupCache.put(marker, group);
                if (group.getParent() == null) {
                    markerSheet.addMarkerGroup(group);
                }
            }
        }
    }

    protected void postDecreaseRef(String resourceId, Object resource) {
        IMarker marker = (IMarker)resource;
        MarkerSheetImpl markerSheet = this.workbook.getMarkerSheet();
        if (markerSheet.equals(marker.getOwnedSheet())) {
            IMarkerGroup group;
            IFileEntry entry;
            String resourcePath = marker.getResourcePath();
            if (resourcePath != null && (entry = this.workbook.getManifest().getFileEntry("markers/" + resourcePath)) != null) {
                entry.decreaseReference();
            }
            if ((group = marker.getParent()) != null) {
                this.groupCache.put(marker, group);
                if (this.getRefCount(resourceId) <= 0) {
                    group.removeMarker(marker);
                }
                if (group.isEmpty() && markerSheet.equals(group.getParent())) {
                    markerSheet.removeMarkerGroup(group);
                }
            }
        }
    }
}

