/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Summary;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryImpl
extends Summary
implements ICoreEventSource {
    private WorkbookImpl ownedWorkbook;
    private Element implementation;

    public SummaryImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedWorkbook = ownedWorkbook;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.implementation);
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SummaryImpl)) {
            return false;
        }
        SummaryImpl that = (SummaryImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    @Override
    public String toString() {
        return "SUM#" + this.getId() + "{" + this.getTopicId() + "}";
    }

    @Override
    public String getId() {
        return this.implementation.getAttribute("id");
    }

    @Override
    public String getStyleId() {
        return DOMUtils.getAttribute(this.implementation, "style-id");
    }

    @Override
    public void setStyleId(String styleId) {
        String oldValue = this.getStyleId();
        WorkbookImpl workbook = this.getRealizedWorkbook();
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        DOMUtils.setAttribute(this.implementation, "style-id", styleId);
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        String newValue = this.getStyleId();
        this.fireValueChange("style", oldValue, newValue);
        this.updateModificationInfo();
    }

    @Override
    public ISheet getOwnedSheet() {
        ITopic parent = this.getParent();
        return parent == null ? null : parent.getOwnedSheet();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    @Override
    public ITopic getParent() {
        Element t = this.getParentTopicElement();
        if (t != null) {
            return (ITopic)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(t);
        }
        return null;
    }

    private Element getParentTopicElement() {
        Node p = this.implementation.getParentNode();
        if (DOMUtils.isElementByTag(p, "summaries") && DOMUtils.isElementByTag(p = p.getParentNode(), "topic")) {
            return (Element)p;
        }
        return null;
    }

    @Override
    protected ITopic getTopic(int index) {
        if (index < 0) {
            return null;
        }
        Element p = this.getParentTopicElement();
        if (p == null) {
            return null;
        }
        Element ts = TopicImpl.findSubtopicsElement(p, "attached");
        if (ts == null) {
            return null;
        }
        Iterator<Element> it = DOMUtils.childElementIterByTag(ts, "topic");
        int i = 0;
        while (it.hasNext()) {
            Element t = it.next();
            if (i == index) {
                return (ITopic)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(t);
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getEndIndex() {
        return InternalDOMUtils.getEndIndex(DOMUtils.getAttribute(this.implementation, "range"));
    }

    @Override
    public int getStartIndex() {
        return InternalDOMUtils.getStartIndex(DOMUtils.getAttribute(this.implementation, "range"));
    }

    private Integer toIndexValue(int index) {
        return index < 0 ? null : Integer.valueOf(index);
    }

    @Override
    public void setEndIndex(int index) {
        String oldValue = DOMUtils.getAttribute(this.implementation, "range");
        Integer oldIndexValue = this.toIndexValue(this.getEndIndex());
        DOMUtils.setAttribute(this.implementation, "range", InternalDOMUtils.toRangeValue(this.getStartIndex(), index));
        Integer newIndexValue = this.toIndexValue(this.getEndIndex());
        String newValue = DOMUtils.getAttribute(this.implementation, "range");
        this.fireValueChange("endIndex", oldIndexValue, newIndexValue);
        this.fireValueChange("range", oldValue, newValue);
        this.updateModificationInfo();
    }

    @Override
    public void setStartIndex(int index) {
        String oldValue = DOMUtils.getAttribute(this.implementation, "range");
        Integer oldIndexValue = this.toIndexValue(this.getStartIndex());
        DOMUtils.setAttribute(this.implementation, "range", InternalDOMUtils.toRangeValue(index, this.getEndIndex()));
        Integer newIndexValue = this.toIndexValue(this.getStartIndex());
        String newValue = DOMUtils.getAttribute(this.implementation, "range");
        this.fireValueChange("startIndex", oldIndexValue, newIndexValue);
        this.fireValueChange("range", oldValue, newValue);
        this.updateModificationInfo();
    }

    @Override
    public ITopic getTopic() {
        String topicId = this.getTopicId();
        return topicId == null ? null : this.ownedWorkbook.findTopic(topicId);
    }

    @Override
    public String getTopicId() {
        return DOMUtils.getAttribute(this.implementation, "topic-id");
    }

    @Override
    public void setTopicId(String topicId) {
        String oldValue = this.getTopicId();
        DOMUtils.setAttribute(this.implementation, "topic-id", topicId);
        String newValue = this.getTopicId();
        this.fireValueChange("topicRefId", oldValue, newValue);
        this.updateModificationInfo();
    }

    protected WorkbookImpl getRealizedWorkbook() {
        ITopic parent = this.getParent();
        if (parent instanceof TopicImpl) {
            return ((TopicImpl)parent).getRealizedWorkbook();
        }
        return null;
    }

    protected void addNotify(WorkbookImpl workbook, TopicImpl parent) {
        this.getImplementation().setIdAttribute("id", true);
        workbook.getAdaptableRegistry().registerById(this, this.getId(), this.getImplementation().getOwnerDocument());
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
    }

    protected void removeNotify(WorkbookImpl workbook, TopicImpl parent) {
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        workbook.getAdaptableRegistry().unregisterById(this, this.getId(), this.getImplementation().getOwnerDocument());
        this.getImplementation().setIdAttribute("id", false);
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedWorkbook.getCoreEventSupport();
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }

    @Override
    public long getModifiedTime() {
        return InternalDOMUtils.getModifiedTime(this, this.implementation);
    }

    @Override
    public String getModifiedBy() {
        return InternalDOMUtils.getModifiedBy(this, this.implementation);
    }

    protected void updateModificationInfo() {
        InternalDOMUtils.updateModificationInfo(this);
        ITopic parent = this.getParent();
        if (parent != null) {
            ((TopicImpl)parent).updateModificationInfo();
        }
    }
}

