/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.core.Core;
import org.xmind.core.IWorkspace;
import org.xmind.core.util.FileUtils;

public class Workspace
implements IWorkspace {
    private static final String P_WORKSPACE = "org.xmind.core.workspace";
    private static final String P_APPLIED_WORKSPACE = "org.xmind.core.workspace.applied";
    private static final Pattern EXPANSION_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private String workingDirectory = null;
    private String defaultWorkingDirectory = null;

    public String getWorkingDirectory() {
        if (this.workingDirectory != null) {
            return this.workingDirectory;
        }
        String wd = System.getProperty(P_WORKSPACE);
        if (wd != null && !"".equals(wd)) {
            this.workingDirectory = Workspace.expandProperties(wd, System.getProperties());
            System.setProperty(P_APPLIED_WORKSPACE, this.workingDirectory);
            return this.workingDirectory;
        }
        return this.getDefaultWorkingDirectory();
    }

    public void setDefaultWorkingDirectory(String path) {
        this.defaultWorkingDirectory = path;
        if (this.workingDirectory == null && System.getProperty(P_WORKSPACE) == null) {
            System.setProperty(P_APPLIED_WORKSPACE, path);
        }
    }

    private String getDefaultWorkingDirectory() {
        if (this.defaultWorkingDirectory == null) {
            this.defaultWorkingDirectory = Workspace.calculateDefaultWorkingDirectory();
            System.setProperty(P_APPLIED_WORKSPACE, this.defaultWorkingDirectory);
        }
        return this.defaultWorkingDirectory;
    }

    public void setWorkingDirectory(String path) {
        this.workingDirectory = path;
        System.setProperty(P_APPLIED_WORKSPACE, path);
    }

    public String getAbsolutePath(String subPath) {
        if (subPath == null) {
            return null;
        }
        String wd = this.getWorkingDirectory();
        File f = new File(wd, subPath);
        return f.getAbsolutePath();
    }

    public String getTempDir() {
        return this.getAbsolutePath("temp");
    }

    public String getTempDir(String subPath) {
        return FileUtils.ensureDirectory(new File(this.getTempDir(), subPath)).getAbsolutePath();
    }

    public String getTempFile(String fileName) {
        return FileUtils.ensureFileParent(new File(this.getTempDir(), fileName)).getAbsolutePath();
    }

    public synchronized File createTempFile(String subPath, String prefix, String suffix) {
        File file;
        String subDir = this.getTempDir(subPath);
        while ((file = new File(subDir, String.valueOf(prefix) + Core.getIdFactory().createId() + suffix)).exists()) {
        }
        return file;
    }

    private static String calculateDefaultWorkingDirectory() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            return ".xmind";
        }
        return new File(userHome, ".xmind").getAbsolutePath();
    }

    private static String expandProperties(String input, Properties props) {
        StringBuffer buffer = new StringBuffer(input.length());
        Matcher m = EXPANSION_PATTERN.matcher(input);
        while (m.find()) {
            String name = m.group(1);
            String value = props.getProperty(name);
            if (value == null) {
                value = m.group();
            }
            value = value.replaceAll("([\\\\\\$])", "\\\\$1");
            m.appendReplacement(buffer, value);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }
}

