/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import org.xmind.core.Core;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;

public class AddIdeaGroupCommand
extends SourceCommand {
    private ITopic rootTopic;
    private String groupName;
    private ITopicExtensionElement parent;
    private ITopicExtensionElement addedGroup;
    private int index;

    public AddIdeaGroupCommand(ITopic rootTopic, String groupName) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.groupName = groupName == null ? "" : groupName;
        this.setLabel(IdeaFactoryMessages.AddIdeaGroupCommand_Name);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ITopicExtension ext = this.rootTopic.createExtension("org.xmind.ui.ideafactory");
        ITopicExtensionElement content = ext.getContent();
        this.parent = (ITopicExtensionElement)content.getCreatedChild("groups");
        if (this.addedGroup == null) {
            this.addedGroup = (ITopicExtensionElement)this.parent.createChild("group");
            this.addedGroup.setAttribute("id", Core.getIdFactory().createId());
            this.addedGroup.setTextContent(this.groupName);
            this.index = this.parent.getChildren().size();
        } else {
            this.parent.addChild((IExtensionElement)this.addedGroup, this.index);
        }
        this.fireCoreEvent(this.rootTopic, "ideaGroupAdded");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.parent.deleteChild((IExtensionElement)this.addedGroup);
        this.fireCoreEvent(this.rootTopic, "ideaGroupDeleted");
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.addedGroup, this.index - 1);
        }
    }

    public ITopicExtensionElement getCreatedGroupElement() {
        return this.addedGroup;
    }
}

