// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/v1/workflows.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_V1_WORKFLOWS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_V1_WORKFLOWS_CLIENT_H

#include "google/cloud/workflows/v1/workflows_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace workflows_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Workflows is used to deploy and execute workflow programs.
/// Workflows makes sure the program executes reliably, despite hardware and
/// networking interruptions.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class WorkflowsClient {
 public:
  explicit WorkflowsClient(std::shared_ptr<WorkflowsConnection> connection,
                           Options opts = {});
  ~WorkflowsClient();

  ///@{
  /// @name Copy and move support
  WorkflowsClient(WorkflowsClient const&) = default;
  WorkflowsClient& operator=(WorkflowsClient const&) = default;
  WorkflowsClient(WorkflowsClient&&) = default;
  WorkflowsClient& operator=(WorkflowsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(WorkflowsClient const& a, WorkflowsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(WorkflowsClient const& a, WorkflowsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists workflows in a given project and location.
  /// The default order is not specified.
  ///
  /// @param parent  Required. Project and location from which the workflows should be listed.
  ///  Format: projects/{project}/locations/{location}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.workflows.v1.Workflow], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.ListWorkflowsRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L272}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  StreamRange<google::cloud::workflows::v1::Workflow> ListWorkflows(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists workflows in a given project and location.
  /// The default order is not specified.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.workflows.v1.ListWorkflowsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.workflows.v1.Workflow], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.ListWorkflowsRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L272}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  StreamRange<google::cloud::workflows::v1::Workflow> ListWorkflows(
      google::cloud::workflows::v1::ListWorkflowsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single workflow.
  ///
  /// @param name  Required. Name of the workflow for which information should be retrieved.
  ///  Format: projects/{project}/locations/{location}/workflows/{workflow}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.workflows.v1.Workflow])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.GetWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L322}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  StatusOr<google::cloud::workflows::v1::Workflow> GetWorkflow(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single workflow.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.workflows.v1.GetWorkflowRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.workflows.v1.Workflow])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.GetWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L322}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  StatusOr<google::cloud::workflows::v1::Workflow> GetWorkflow(
      google::cloud::workflows::v1::GetWorkflowRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new workflow. If a workflow with the specified name already
  /// exists in the specified project and location, the long running operation
  /// returns a [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
  ///
  /// @param parent  Required. Project and location in which the workflow should be created.
  ///  Format:  projects/{project}/locations/{location}
  /// @param workflow  Required. Workflow to be created.
  /// @param workflow_id  Required. The ID of the workflow to be created. It has to fulfill the
  ///  following requirements:
  ///  @n
  ///  * Must contain only letters, numbers, underscores and hyphens.
  ///  * Must start with a letter.
  ///  * Must be between 1-64 characters.
  ///  * Must end with a number or a letter.
  ///  * Must be unique within the customer project and location.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.workflows.v1.Workflow] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.CreateWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L343}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  future<StatusOr<google::cloud::workflows::v1::Workflow>> CreateWorkflow(
      std::string const& parent,
      google::cloud::workflows::v1::Workflow const& workflow,
      std::string const& workflow_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new workflow. If a workflow with the specified name already
  /// exists in the specified project and location, the long running operation
  /// returns a [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.workflows.v1.CreateWorkflowRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.workflows.v1.Workflow] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.CreateWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L343}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  future<StatusOr<google::cloud::workflows::v1::Workflow>> CreateWorkflow(
      google::cloud::workflows::v1::CreateWorkflowRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a workflow with the specified name.
  /// This method also cancels and deletes all running executions of the
  /// workflow.
  ///
  /// @param name  Required. Name of the workflow to be deleted.
  ///  Format: projects/{project}/locations/{location}/workflows/{workflow}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.workflows.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.DeleteWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L370}
  /// [google.cloud.workflows.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L394}
  ///
  // clang-format on
  future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
  DeleteWorkflow(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a workflow with the specified name.
  /// This method also cancels and deletes all running executions of the
  /// workflow.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.workflows.v1.DeleteWorkflowRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.workflows.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.DeleteWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L370}
  /// [google.cloud.workflows.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L394}
  ///
  // clang-format on
  future<StatusOr<google::cloud::workflows::v1::OperationMetadata>>
  DeleteWorkflow(
      google::cloud::workflows::v1::DeleteWorkflowRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an existing workflow.
  /// Running this method has no impact on already running executions of the
  /// workflow. A new revision of the workflow might be created as a result of a
  /// successful update operation. In that case, the new revision is used
  /// in new workflow executions.
  ///
  /// @param workflow  Required. Workflow to be updated.
  /// @param update_mask  List of fields to be updated. If not present, the entire workflow
  ///  will be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.workflows.v1.Workflow] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.UpdateWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L384}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  future<StatusOr<google::cloud::workflows::v1::Workflow>> UpdateWorkflow(
      google::cloud::workflows::v1::Workflow const& workflow,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing workflow.
  /// Running this method has no impact on already running executions of the
  /// workflow. A new revision of the workflow might be created as a result of a
  /// successful update operation. In that case, the new revision is used
  /// in new workflow executions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.workflows.v1.UpdateWorkflowRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.workflows.v1.Workflow] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.workflows.v1.UpdateWorkflowRequest]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L384}
  /// [google.cloud.workflows.v1.Workflow]: @googleapis_reference_link{google/cloud/workflows/v1/workflows.proto#L113}
  ///
  // clang-format on
  future<StatusOr<google::cloud::workflows::v1::Workflow>> UpdateWorkflow(
      google::cloud::workflows::v1::UpdateWorkflowRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<WorkflowsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKFLOWS_V1_WORKFLOWS_CLIENT_H
