// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

#include "google/cloud/redis/cluster/v1/internal/cloud_redis_cluster_option_defaults.h"
#include "google/cloud/redis/cluster/v1/cloud_redis_cluster_connection.h"
#include "google/cloud/redis/cluster/v1/cloud_redis_cluster_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace redis_cluster_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options CloudRedisClusterDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_CLOUD_REDIS_CLUSTER_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_CLOUD_REDIS_CLUSTER_AUTHORITY", "redis.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<redis_cluster_v1::CloudRedisClusterRetryPolicyOption>()) {
    options.set<redis_cluster_v1::CloudRedisClusterRetryPolicyOption>(
        redis_cluster_v1::CloudRedisClusterLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<redis_cluster_v1::CloudRedisClusterBackoffPolicyOption>()) {
    options.set<redis_cluster_v1::CloudRedisClusterBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<redis_cluster_v1::CloudRedisClusterPollingPolicyOption>()) {
    options.set<redis_cluster_v1::CloudRedisClusterPollingPolicyOption>(
        GenericPollingPolicy<
            redis_cluster_v1::CloudRedisClusterRetryPolicyOption::Type,
            redis_cluster_v1::CloudRedisClusterBackoffPolicyOption::Type>(
            options.get<redis_cluster_v1::CloudRedisClusterRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<redis_cluster_v1::
                       CloudRedisClusterConnectionIdempotencyPolicyOption>()) {
    options.set<
        redis_cluster_v1::CloudRedisClusterConnectionIdempotencyPolicyOption>(
        redis_cluster_v1::
            MakeDefaultCloudRedisClusterConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace redis_cluster_v1_internal
}  // namespace cloud
}  // namespace google
