// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#include "google/cloud/logging/v2/internal/metrics_service_v2_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/logging/v2/logging_metrics.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetricsServiceV2Logging::MetricsServiceV2Logging(
    std::shared_ptr<MetricsServiceV2Stub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::logging::v2::ListLogMetricsResponse>
MetricsServiceV2Logging::ListLogMetrics(
    grpc::ClientContext& context,
    google::logging::v2::ListLogMetricsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::logging::v2::ListLogMetricsRequest const& request) {
        return child_->ListLogMetrics(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::logging::v2::LogMetric> MetricsServiceV2Logging::GetLogMetric(
    grpc::ClientContext& context,
    google::logging::v2::GetLogMetricRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::logging::v2::GetLogMetricRequest const& request) {
        return child_->GetLogMetric(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::logging::v2::LogMetric>
MetricsServiceV2Logging::CreateLogMetric(
    grpc::ClientContext& context,
    google::logging::v2::CreateLogMetricRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::logging::v2::CreateLogMetricRequest const& request) {
        return child_->CreateLogMetric(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::logging::v2::LogMetric>
MetricsServiceV2Logging::UpdateLogMetric(
    grpc::ClientContext& context,
    google::logging::v2::UpdateLogMetricRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::logging::v2::UpdateLogMetricRequest const& request) {
        return child_->UpdateLogMetric(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status MetricsServiceV2Logging::DeleteLogMetric(
    grpc::ClientContext& context,
    google::logging::v2::DeleteLogMetricRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::logging::v2::DeleteLogMetricRequest const& request) {
        return child_->DeleteLogMetric(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google
