// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/admin/v1/datastore_admin.proto

#include "google/cloud/datastore/admin/v1/datastore_admin_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace datastore_admin_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DatastoreAdminClient::DatastoreAdminClient(
    std::shared_ptr<DatastoreAdminConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DatastoreAdminClient::~DatastoreAdminClient() = default;

future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
DatastoreAdminClient::ExportEntities(
    std::string const& project_id,
    std::map<std::string, std::string> const& labels,
    google::datastore::admin::v1::EntityFilter const& entity_filter,
    std::string const& output_url_prefix, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::admin::v1::ExportEntitiesRequest request;
  request.set_project_id(project_id);
  *request.mutable_labels() = {labels.begin(), labels.end()};
  *request.mutable_entity_filter() = entity_filter;
  request.set_output_url_prefix(output_url_prefix);
  return connection_->ExportEntities(request);
}

future<StatusOr<google::datastore::admin::v1::ExportEntitiesResponse>>
DatastoreAdminClient::ExportEntities(
    google::datastore::admin::v1::ExportEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportEntities(request);
}

future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
DatastoreAdminClient::ImportEntities(
    std::string const& project_id,
    std::map<std::string, std::string> const& labels,
    std::string const& input_url,
    google::datastore::admin::v1::EntityFilter const& entity_filter,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::datastore::admin::v1::ImportEntitiesRequest request;
  request.set_project_id(project_id);
  *request.mutable_labels() = {labels.begin(), labels.end()};
  request.set_input_url(input_url);
  *request.mutable_entity_filter() = entity_filter;
  return connection_->ImportEntities(request);
}

future<StatusOr<google::datastore::admin::v1::ImportEntitiesMetadata>>
DatastoreAdminClient::ImportEntities(
    google::datastore::admin::v1::ImportEntitiesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportEntities(request);
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminClient::CreateIndex(
    google::datastore::admin::v1::CreateIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateIndex(request);
}

future<StatusOr<google::datastore::admin::v1::Index>>
DatastoreAdminClient::DeleteIndex(
    google::datastore::admin::v1::DeleteIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteIndex(request);
}

StatusOr<google::datastore::admin::v1::Index> DatastoreAdminClient::GetIndex(
    google::datastore::admin::v1::GetIndexRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIndex(request);
}

StreamRange<google::datastore::admin::v1::Index>
DatastoreAdminClient::ListIndexes(
    google::datastore::admin::v1::ListIndexesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListIndexes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_admin_v1
}  // namespace cloud
}  // namespace google
