// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_ARTIFACT_REGISTRY_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_ARTIFACT_REGISTRY_CLIENT_H

#include "google/cloud/artifactregistry/v1/artifact_registry_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The Artifact Registry API service.
///
/// Artifact Registry is an artifact management system for storing artifacts
/// from different package management systems.
///
/// The resources managed by this API are:
///
/// * Repositories, which group packages and their data.
/// * Packages, which group versions and their tags.
/// * Versions, which are specific forms of a package.
/// * Tags, which represent alternative names for versions.
/// * Files, which contain content and are optionally associated with a Package
///   or Version.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ArtifactRegistryClient {
 public:
  explicit ArtifactRegistryClient(
      std::shared_ptr<ArtifactRegistryConnection> connection,
      Options opts = {});
  ~ArtifactRegistryClient();

  ///@{
  /// @name Copy and move support
  ArtifactRegistryClient(ArtifactRegistryClient const&) = default;
  ArtifactRegistryClient& operator=(ArtifactRegistryClient const&) = default;
  ArtifactRegistryClient(ArtifactRegistryClient&&) = default;
  ArtifactRegistryClient& operator=(ArtifactRegistryClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ArtifactRegistryClient const& a,
                         ArtifactRegistryClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ArtifactRegistryClient const& a,
                         ArtifactRegistryClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists docker images.
  ///
  /// @param parent  Required. The name of the parent resource whose docker images will be
  ///  listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.DockerImage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DockerImage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L37}
  /// [google.devtools.artifactregistry.v1.ListDockerImagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L90}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::DockerImage>
  ListDockerImages(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists docker images.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListDockerImagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.DockerImage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DockerImage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L37}
  /// [google.devtools.artifactregistry.v1.ListDockerImagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L90}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::DockerImage>
  ListDockerImages(
      google::devtools::artifactregistry::v1::ListDockerImagesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a docker image.
  ///
  /// @param name  Required. The name of the docker images.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.DockerImage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DockerImage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L37}
  /// [google.devtools.artifactregistry.v1.GetDockerImageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L116}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::DockerImage> GetDockerImage(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a docker image.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetDockerImageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.DockerImage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DockerImage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L37}
  /// [google.devtools.artifactregistry.v1.GetDockerImageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L116}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::DockerImage> GetDockerImage(
      google::devtools::artifactregistry::v1::GetDockerImageRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists maven artifacts.
  ///
  /// @param parent  Required. The name of the parent resource whose maven artifacts will be
  ///  listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.MavenArtifact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListMavenArtifactsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L169}
  /// [google.devtools.artifactregistry.v1.MavenArtifact]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L127}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>
  ListMavenArtifacts(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists maven artifacts.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListMavenArtifactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.MavenArtifact], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListMavenArtifactsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L169}
  /// [google.devtools.artifactregistry.v1.MavenArtifact]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L127}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>
  ListMavenArtifacts(
      google::devtools::artifactregistry::v1::ListMavenArtifactsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a maven artifact.
  ///
  /// @param name  Required. The name of the maven artifact.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.MavenArtifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetMavenArtifactRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L197}
  /// [google.devtools.artifactregistry.v1.MavenArtifact]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L127}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
  GetMavenArtifact(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a maven artifact.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetMavenArtifactRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.MavenArtifact])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetMavenArtifactRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L197}
  /// [google.devtools.artifactregistry.v1.MavenArtifact]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L127}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
  GetMavenArtifact(
      google::devtools::artifactregistry::v1::GetMavenArtifactRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists npm packages.
  ///
  /// @param parent  Required. The name of the parent resource whose npm packages will be
  ///  listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.NpmPackage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListNpmPackagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L242}
  /// [google.devtools.artifactregistry.v1.NpmPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L208}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::NpmPackage>
  ListNpmPackages(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists npm packages.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListNpmPackagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.NpmPackage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListNpmPackagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L242}
  /// [google.devtools.artifactregistry.v1.NpmPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L208}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::NpmPackage>
  ListNpmPackages(
      google::devtools::artifactregistry::v1::ListNpmPackagesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a npm package.
  ///
  /// @param name  Required. The name of the npm package.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.NpmPackage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetNpmPackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L270}
  /// [google.devtools.artifactregistry.v1.NpmPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L208}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::NpmPackage> GetNpmPackage(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a npm package.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetNpmPackageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.NpmPackage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetNpmPackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L270}
  /// [google.devtools.artifactregistry.v1.NpmPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L208}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::NpmPackage> GetNpmPackage(
      google::devtools::artifactregistry::v1::GetNpmPackageRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists python packages.
  ///
  /// @param parent  Required. The name of the parent resource whose python packages will be
  ///  listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.PythonPackage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListPythonPackagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L319}
  /// [google.devtools.artifactregistry.v1.PythonPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L281}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::PythonPackage>
  ListPythonPackages(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists python packages.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListPythonPackagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.PythonPackage], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListPythonPackagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L319}
  /// [google.devtools.artifactregistry.v1.PythonPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L281}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::PythonPackage>
  ListPythonPackages(
      google::devtools::artifactregistry::v1::ListPythonPackagesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a python package.
  ///
  /// @param name  Required. The name of the python package.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.PythonPackage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetPythonPackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L347}
  /// [google.devtools.artifactregistry.v1.PythonPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L281}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
  GetPythonPackage(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a python package.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetPythonPackageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.PythonPackage])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetPythonPackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L347}
  /// [google.devtools.artifactregistry.v1.PythonPackage]: @googleapis_reference_link{google/devtools/artifactregistry/v1/artifact.proto#L281}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
  GetPythonPackage(
      google::devtools::artifactregistry::v1::GetPythonPackageRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Imports Apt artifacts. The returned Operation will complete once the
  /// resources are imported. Package, Version, and File resources are created
  /// based on the imported artifacts. Imported artifacts that conflict with
  /// existing resources are ignored.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ImportAptArtifactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.ImportAptArtifactsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ImportAptArtifactsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/apt_artifact.proto#L81}
  /// [google.devtools.artifactregistry.v1.ImportAptArtifactsResponse]: @googleapis_reference_link{google/devtools/artifactregistry/v1/apt_artifact.proto#L105}
  ///
  // clang-format on
  future<StatusOr<
      google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>
  ImportAptArtifacts(
      google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Imports Yum (RPM) artifacts. The returned Operation will complete once the
  /// resources are imported. Package, Version, and File resources are created
  /// based on the imported artifacts. Imported artifacts that conflict with
  /// existing resources are ignored.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ImportYumArtifactsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.ImportYumArtifactsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ImportYumArtifactsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/yum_artifact.proto#L73}
  /// [google.devtools.artifactregistry.v1.ImportYumArtifactsResponse]: @googleapis_reference_link{google/devtools/artifactregistry/v1/yum_artifact.proto#L97}
  ///
  // clang-format on
  future<StatusOr<
      google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>
  ImportYumArtifacts(
      google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists repositories.
  ///
  /// @param parent  Required. The name of the parent resource whose repositories will be
  ///  listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Repository], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListRepositoriesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L508}
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Repository>
  ListRepositories(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists repositories.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListRepositoriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Repository], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListRepositoriesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L508}
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Repository>
  ListRepositories(
      google::devtools::artifactregistry::v1::ListRepositoriesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a repository.
  ///
  /// @param name  Required. The name of the repository to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Repository])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L536}
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Repository> GetRepository(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a repository.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetRepositoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Repository])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L536}
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Repository> GetRepository(
      google::devtools::artifactregistry::v1::GetRepositoryRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a repository. The returned Operation will finish once the
  /// repository has been created. Its response will be the created Repository.
  ///
  /// @param parent  Required. The name of the parent resource where the repository will be
  ///  created.
  /// @param repository  Required. The repository to be created.
  /// @param repository_id  Required. The repository id to use for this repository.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.Repository] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.CreateRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L547}
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
  CreateRepository(
      std::string const& parent,
      google::devtools::artifactregistry::v1::Repository const& repository,
      std::string const& repository_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a repository. The returned Operation will finish once the
  /// repository has been created. Its response will be the created Repository.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.CreateRepositoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.Repository] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.CreateRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L547}
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
  CreateRepository(
      google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a repository.
  ///
  /// @param repository  The repository that replaces the resource on the server.
  /// @param update_mask  The update mask applies to the resource. For the `FieldMask` definition,
  ///  see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Repository])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  /// [google.devtools.artifactregistry.v1.UpdateRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L565}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Repository> UpdateRepository(
      google::devtools::artifactregistry::v1::Repository const& repository,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a repository.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.UpdateRepositoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Repository])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.Repository]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L344}
  /// [google.devtools.artifactregistry.v1.UpdateRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L565}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Repository> UpdateRepository(
      google::devtools::artifactregistry::v1::UpdateRepositoryRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a repository and all of its contents. The returned Operation will
  /// finish once the repository has been deleted. It will not have any Operation
  /// metadata and will return a google.protobuf.Empty response.
  ///
  /// @param name  Required. The name of the repository to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeleteRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L576}
  /// [google.devtools.artifactregistry.v1.OperationMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/service.proto#L415}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeleteRepository(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a repository and all of its contents. The returned Operation will
  /// finish once the repository has been deleted. It will not have any Operation
  /// metadata and will return a google.protobuf.Empty response.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.DeleteRepositoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeleteRepositoryRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/repository.proto#L576}
  /// [google.devtools.artifactregistry.v1.OperationMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/service.proto#L415}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeleteRepository(
      google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists packages.
  ///
  /// @param parent  Required. The name of the parent resource whose packages will be listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Package], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListPackagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L55}
  /// [google.devtools.artifactregistry.v1.Package]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L32}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Package> ListPackages(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists packages.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListPackagesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Package], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListPackagesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L55}
  /// [google.devtools.artifactregistry.v1.Package]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L32}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Package> ListPackages(
      google::devtools::artifactregistry::v1::ListPackagesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a package.
  ///
  /// @param name  Required. The name of the package to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Package])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetPackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L82}
  /// [google.devtools.artifactregistry.v1.Package]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Package> GetPackage(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a package.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetPackageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Package])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetPackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L82}
  /// [google.devtools.artifactregistry.v1.Package]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Package> GetPackage(
      google::devtools::artifactregistry::v1::GetPackageRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a package and all of its versions and tags. The returned operation
  /// will complete once the package has been deleted.
  ///
  /// @param name  Required. The name of the package to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeletePackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L93}
  /// [google.devtools.artifactregistry.v1.OperationMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/service.proto#L415}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeletePackage(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a package and all of its versions and tags. The returned operation
  /// will complete once the package has been deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.DeletePackageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeletePackageRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/package.proto#L93}
  /// [google.devtools.artifactregistry.v1.OperationMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/service.proto#L415}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeletePackage(
      google::devtools::artifactregistry::v1::DeletePackageRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists versions.
  ///
  /// @param parent  The name of the parent resource whose versions will be listed.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Version], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListVersionsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L85}
  /// [google.devtools.artifactregistry.v1.Version]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L50}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Version> ListVersions(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists versions.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListVersionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Version], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListVersionsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L85}
  /// [google.devtools.artifactregistry.v1.Version]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L50}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Version> ListVersions(
      google::devtools::artifactregistry::v1::ListVersionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a version
  ///
  /// @param name  The name of the version to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Version])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetVersionRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L113}
  /// [google.devtools.artifactregistry.v1.Version]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L50}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Version> GetVersion(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a version
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetVersionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Version])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetVersionRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L113}
  /// [google.devtools.artifactregistry.v1.Version]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L50}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Version> GetVersion(
      google::devtools::artifactregistry::v1::GetVersionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a version and all of its content. The returned operation will
  /// complete once the version has been deleted.
  ///
  /// @param name  The name of the version to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeleteVersionRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L122}
  /// [google.devtools.artifactregistry.v1.OperationMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/service.proto#L415}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeleteVersion(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a version and all of its content. The returned operation will
  /// complete once the version has been deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.DeleteVersionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeleteVersionRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L122}
  /// [google.devtools.artifactregistry.v1.OperationMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/service.proto#L415}
  ///
  // clang-format on
  future<StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeleteVersion(
      google::devtools::artifactregistry::v1::DeleteVersionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes multiple versions across a repository. The returned operation will
  /// complete once the versions have been deleted.
  ///
  /// @param parent  The name of the repository holding all requested versions.
  /// @param names  Required. The names of the versions to delete.
  ///  A maximum of 10000 versions can be deleted in a batch.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.BatchDeleteVersionsMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.BatchDeleteVersionsMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L152}
  /// [google.devtools.artifactregistry.v1.BatchDeleteVersionsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L132}
  ///
  // clang-format on
  future<StatusOr<
      google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
  BatchDeleteVersions(std::string const& parent,
                      std::vector<std::string> const& names, Options opts = {});

  // clang-format off
  ///
  /// Deletes multiple versions across a repository. The returned operation will
  /// complete once the versions have been deleted.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.BatchDeleteVersionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.devtools.artifactregistry.v1.BatchDeleteVersionsMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.BatchDeleteVersionsMetadata]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L152}
  /// [google.devtools.artifactregistry.v1.BatchDeleteVersionsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/version.proto#L132}
  ///
  // clang-format on
  future<StatusOr<
      google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
  BatchDeleteVersions(
      google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists files.
  ///
  /// @param parent  Required. The name of the repository whose files will be listed. For
  ///  example: "projects/p1/locations/us-central1/repositories/repo1"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.File], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.File]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L53}
  /// [google.devtools.artifactregistry.v1.ListFilesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L88}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::File> ListFiles(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists files.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListFilesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.File], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.File]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L53}
  /// [google.devtools.artifactregistry.v1.ListFilesRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L88}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::File> ListFiles(
      google::devtools::artifactregistry::v1::ListFilesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a file.
  ///
  /// @param name  Required. The name of the file to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.File])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.File]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L53}
  /// [google.devtools.artifactregistry.v1.GetFileRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L133}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::File> GetFile(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a file.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetFileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.File])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.File]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L53}
  /// [google.devtools.artifactregistry.v1.GetFileRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/file.proto#L133}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::File> GetFile(
      google::devtools::artifactregistry::v1::GetFileRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists tags.
  ///
  /// @param parent  The name of the parent package whose tags will be listed.
  ///  For example:
  ///  `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Tag], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListTagsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L53}
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Tag> ListTags(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists tags.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.ListTagsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.devtools.artifactregistry.v1.Tag], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ListTagsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L53}
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  ///
  // clang-format on
  StreamRange<google::devtools::artifactregistry::v1::Tag> ListTags(
      google::devtools::artifactregistry::v1::ListTagsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a tag.
  ///
  /// @param name  The name of the tag to retrieve.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Tag])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L88}
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Tag> GetTag(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a tag.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetTagRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Tag])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L88}
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Tag> GetTag(
      google::devtools::artifactregistry::v1::GetTagRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a tag.
  ///
  /// @param parent  The name of the parent resource where the tag will be created.
  /// @param tag  The tag to be created.
  /// @param tag_id  The tag id to use for this repository.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Tag])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.CreateTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L94}
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Tag> CreateTag(
      std::string const& parent,
      google::devtools::artifactregistry::v1::Tag const& tag,
      std::string const& tag_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a tag.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.CreateTagRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Tag])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.CreateTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L94}
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Tag> CreateTag(
      google::devtools::artifactregistry::v1::CreateTagRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a tag.
  ///
  /// @param tag  The tag that replaces the resource on the server.
  /// @param update_mask  The update mask applies to the resource. For the `FieldMask` definition,
  ///  see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Tag])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  /// [google.devtools.artifactregistry.v1.UpdateTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L106}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Tag> UpdateTag(
      google::devtools::artifactregistry::v1::Tag const& tag,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a tag.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.UpdateTagRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.Tag])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.Tag]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L32}
  /// [google.devtools.artifactregistry.v1.UpdateTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L106}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::Tag> UpdateTag(
      google::devtools::artifactregistry::v1::UpdateTagRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a tag.
  ///
  /// @param name  The name of the tag to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeleteTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L117}
  ///
  // clang-format on
  Status DeleteTag(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a tag.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.DeleteTagRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.DeleteTagRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/tag.proto#L117}
  ///
  // clang-format on
  Status DeleteTag(
      google::devtools::artifactregistry::v1::DeleteTagRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the IAM policy for a given resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L101}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the IAM policy for a given resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Tests if the caller has a list of permissions on a resource.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L136}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L151}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the Settings for the Project.
  ///
  /// @param name  Required. The name of the projectSettings resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.ProjectSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetProjectSettingsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L67}
  /// [google.devtools.artifactregistry.v1.ProjectSettings]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  GetProjectSettings(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the Settings for the Project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetProjectSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.ProjectSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetProjectSettingsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L67}
  /// [google.devtools.artifactregistry.v1.ProjectSettings]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  GetProjectSettings(
      google::devtools::artifactregistry::v1::GetProjectSettingsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the Settings for the Project.
  ///
  /// @param project_settings  The project settings.
  /// @param update_mask  Field mask to support partial updates.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.ProjectSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ProjectSettings]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L32}
  /// [google.devtools.artifactregistry.v1.UpdateProjectSettingsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L78}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  UpdateProjectSettings(
      google::devtools::artifactregistry::v1::ProjectSettings const&
          project_settings,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the Settings for the Project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.UpdateProjectSettingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.ProjectSettings])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.ProjectSettings]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L32}
  /// [google.devtools.artifactregistry.v1.UpdateProjectSettingsRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/settings.proto#L78}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  UpdateProjectSettings(google::devtools::artifactregistry::v1::
                            UpdateProjectSettingsRequest const& request,
                        Options opts = {});

  // clang-format off
  ///
  /// Retrieves the VPCSC Config for the Project.
  ///
  /// @param name  Required. The name of the VPCSCConfig resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.VPCSCConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetVPCSCConfigRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L69}
  /// [google.devtools.artifactregistry.v1.VPCSCConfig]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig> GetVPCSCConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the VPCSC Config for the Project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.GetVPCSCConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.VPCSCConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.GetVPCSCConfigRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L69}
  /// [google.devtools.artifactregistry.v1.VPCSCConfig]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig> GetVPCSCConfig(
      google::devtools::artifactregistry::v1::GetVPCSCConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the VPCSC Config for the Project.
  ///
  /// @param vpcsc_config  The project config.
  /// @param update_mask  Field mask to support partial updates.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.VPCSCConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.UpdateVPCSCConfigRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L80}
  /// [google.devtools.artifactregistry.v1.VPCSCConfig]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
  UpdateVPCSCConfig(
      google::devtools::artifactregistry::v1::VPCSCConfig const& vpcsc_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the VPCSC Config for the Project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.devtools.artifactregistry.v1.UpdateVPCSCConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.devtools.artifactregistry.v1.VPCSCConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.devtools.artifactregistry.v1.UpdateVPCSCConfigRequest]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L80}
  /// [google.devtools.artifactregistry.v1.VPCSCConfig]: @googleapis_reference_link{google/devtools/artifactregistry/v1/vpcsc_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
  UpdateVPCSCConfig(
      google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<ArtifactRegistryConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_ARTIFACT_REGISTRY_CLIENT_H
