// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_after_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPAfterResponseRuleFrontendCreatedCode is the HTTP code returned for type CreateHTTPAfterResponseRuleFrontendCreated
const CreateHTTPAfterResponseRuleFrontendCreatedCode int = 201

/*
CreateHTTPAfterResponseRuleFrontendCreated HTTP Response Rule created

swagger:response createHttpAfterResponseRuleFrontendCreated
*/
type CreateHTTPAfterResponseRuleFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPAfterResponseRule `json:"body,omitempty"`
}

// NewCreateHTTPAfterResponseRuleFrontendCreated creates CreateHTTPAfterResponseRuleFrontendCreated with default headers values
func NewCreateHTTPAfterResponseRuleFrontendCreated() *CreateHTTPAfterResponseRuleFrontendCreated {

	return &CreateHTTPAfterResponseRuleFrontendCreated{}
}

// WithPayload adds the payload to the create Http after response rule frontend created response
func (o *CreateHTTPAfterResponseRuleFrontendCreated) WithPayload(payload *models.HTTPAfterResponseRule) *CreateHTTPAfterResponseRuleFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http after response rule frontend created response
func (o *CreateHTTPAfterResponseRuleFrontendCreated) SetPayload(payload *models.HTTPAfterResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPAfterResponseRuleFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPAfterResponseRuleFrontendAcceptedCode is the HTTP code returned for type CreateHTTPAfterResponseRuleFrontendAccepted
const CreateHTTPAfterResponseRuleFrontendAcceptedCode int = 202

/*
CreateHTTPAfterResponseRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response createHttpAfterResponseRuleFrontendAccepted
*/
type CreateHTTPAfterResponseRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPAfterResponseRule `json:"body,omitempty"`
}

// NewCreateHTTPAfterResponseRuleFrontendAccepted creates CreateHTTPAfterResponseRuleFrontendAccepted with default headers values
func NewCreateHTTPAfterResponseRuleFrontendAccepted() *CreateHTTPAfterResponseRuleFrontendAccepted {

	return &CreateHTTPAfterResponseRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create Http after response rule frontend accepted response
func (o *CreateHTTPAfterResponseRuleFrontendAccepted) WithReloadID(reloadID string) *CreateHTTPAfterResponseRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http after response rule frontend accepted response
func (o *CreateHTTPAfterResponseRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http after response rule frontend accepted response
func (o *CreateHTTPAfterResponseRuleFrontendAccepted) WithPayload(payload *models.HTTPAfterResponseRule) *CreateHTTPAfterResponseRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http after response rule frontend accepted response
func (o *CreateHTTPAfterResponseRuleFrontendAccepted) SetPayload(payload *models.HTTPAfterResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPAfterResponseRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPAfterResponseRuleFrontendBadRequestCode is the HTTP code returned for type CreateHTTPAfterResponseRuleFrontendBadRequest
const CreateHTTPAfterResponseRuleFrontendBadRequestCode int = 400

/*
CreateHTTPAfterResponseRuleFrontendBadRequest Bad request

swagger:response createHttpAfterResponseRuleFrontendBadRequest
*/
type CreateHTTPAfterResponseRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPAfterResponseRuleFrontendBadRequest creates CreateHTTPAfterResponseRuleFrontendBadRequest with default headers values
func NewCreateHTTPAfterResponseRuleFrontendBadRequest() *CreateHTTPAfterResponseRuleFrontendBadRequest {

	return &CreateHTTPAfterResponseRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http after response rule frontend bad request response
func (o *CreateHTTPAfterResponseRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPAfterResponseRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http after response rule frontend bad request response
func (o *CreateHTTPAfterResponseRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http after response rule frontend bad request response
func (o *CreateHTTPAfterResponseRuleFrontendBadRequest) WithPayload(payload *models.Error) *CreateHTTPAfterResponseRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http after response rule frontend bad request response
func (o *CreateHTTPAfterResponseRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPAfterResponseRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPAfterResponseRuleFrontendConflictCode is the HTTP code returned for type CreateHTTPAfterResponseRuleFrontendConflict
const CreateHTTPAfterResponseRuleFrontendConflictCode int = 409

/*
CreateHTTPAfterResponseRuleFrontendConflict The specified resource already exists

swagger:response createHttpAfterResponseRuleFrontendConflict
*/
type CreateHTTPAfterResponseRuleFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPAfterResponseRuleFrontendConflict creates CreateHTTPAfterResponseRuleFrontendConflict with default headers values
func NewCreateHTTPAfterResponseRuleFrontendConflict() *CreateHTTPAfterResponseRuleFrontendConflict {

	return &CreateHTTPAfterResponseRuleFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http after response rule frontend conflict response
func (o *CreateHTTPAfterResponseRuleFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPAfterResponseRuleFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http after response rule frontend conflict response
func (o *CreateHTTPAfterResponseRuleFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http after response rule frontend conflict response
func (o *CreateHTTPAfterResponseRuleFrontendConflict) WithPayload(payload *models.Error) *CreateHTTPAfterResponseRuleFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http after response rule frontend conflict response
func (o *CreateHTTPAfterResponseRuleFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPAfterResponseRuleFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPAfterResponseRuleFrontendDefault General Error

swagger:response createHttpAfterResponseRuleFrontendDefault
*/
type CreateHTTPAfterResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPAfterResponseRuleFrontendDefault creates CreateHTTPAfterResponseRuleFrontendDefault with default headers values
func NewCreateHTTPAfterResponseRuleFrontendDefault(code int) *CreateHTTPAfterResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPAfterResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP after response rule frontend default response
func (o *CreateHTTPAfterResponseRuleFrontendDefault) WithStatusCode(code int) *CreateHTTPAfterResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP after response rule frontend default response
func (o *CreateHTTPAfterResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP after response rule frontend default response
func (o *CreateHTTPAfterResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPAfterResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP after response rule frontend default response
func (o *CreateHTTPAfterResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP after response rule frontend default response
func (o *CreateHTTPAfterResponseRuleFrontendDefault) WithPayload(payload *models.Error) *CreateHTTPAfterResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP after response rule frontend default response
func (o *CreateHTTPAfterResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPAfterResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
