// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vpcaccess/v1/vpc_access.proto

#include "google/cloud/vpcaccess/v1/internal/vpc_access_option_defaults.h"
#include "google/cloud/vpcaccess/v1/vpc_access_connection.h"
#include "google/cloud/vpcaccess/v1/vpc_access_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace vpcaccess_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options VpcAccessServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_VPC_ACCESS_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_VPC_ACCESS_SERVICE_AUTHORITY",
      "vpcaccess.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<vpcaccess_v1::VpcAccessServiceRetryPolicyOption>()) {
    options.set<vpcaccess_v1::VpcAccessServiceRetryPolicyOption>(
        vpcaccess_v1::VpcAccessServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<vpcaccess_v1::VpcAccessServiceBackoffPolicyOption>()) {
    options.set<vpcaccess_v1::VpcAccessServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<vpcaccess_v1::VpcAccessServicePollingPolicyOption>()) {
    options.set<vpcaccess_v1::VpcAccessServicePollingPolicyOption>(
        GenericPollingPolicy<
            vpcaccess_v1::VpcAccessServiceRetryPolicyOption::Type,
            vpcaccess_v1::VpcAccessServiceBackoffPolicyOption::Type>(
            options.get<vpcaccess_v1::VpcAccessServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          vpcaccess_v1::VpcAccessServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        vpcaccess_v1::VpcAccessServiceConnectionIdempotencyPolicyOption>(
        vpcaccess_v1::MakeDefaultVpcAccessServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vpcaccess_v1_internal
}  // namespace cloud
}  // namespace google
