// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/run/v2/revision.proto

#include "google/cloud/run/v2/internal/revisions_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace run_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RevisionsTracingConnection::RevisionsTracingConnection(
    std::shared_ptr<run_v2::RevisionsConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::run::v2::Revision>
RevisionsTracingConnection::GetRevision(
    google::cloud::run::v2::GetRevisionRequest const& request) {
  auto span = internal::MakeSpan("run_v2::RevisionsConnection::GetRevision");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRevision(request));
}

StreamRange<google::cloud::run::v2::Revision>
RevisionsTracingConnection::ListRevisions(
    google::cloud::run::v2::ListRevisionsRequest request) {
  auto span = internal::MakeSpan("run_v2::RevisionsConnection::ListRevisions");
  internal::OTelScope scope(span);
  auto sr = child_->ListRevisions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::run::v2::Revision>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::run::v2::Revision>>
RevisionsTracingConnection::DeleteRevision(
    google::cloud::run::v2::DeleteRevisionRequest const& request) {
  auto span = internal::MakeSpan("run_v2::RevisionsConnection::DeleteRevision");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteRevision(request));
}

StatusOr<google::longrunning::Operation>
RevisionsTracingConnection::DeleteRevision(
    NoAwaitTag, google::cloud::run::v2::DeleteRevisionRequest const& request) {
  auto span = internal::MakeSpan("run_v2::RevisionsConnection::DeleteRevision");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteRevision(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::run::v2::Revision>>
RevisionsTracingConnection::DeleteRevision(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("run_v2::RevisionsConnection::DeleteRevision");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteRevision(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<run_v2::RevisionsConnection> MakeRevisionsTracingConnection(
    std::shared_ptr<run_v2::RevisionsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RevisionsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace run_v2_internal
}  // namespace cloud
}  // namespace google
