// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recommender/v1/recommender_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECOMMENDER_V1_RECOMMENDER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECOMMENDER_V1_RECOMMENDER_CLIENT_H

#include "google/cloud/recommender/v1/recommender_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace recommender_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Provides insights and recommendations for cloud customers for various
/// categories like performance optimization, cost savings, reliability, feature
/// discovery, etc. Insights and recommendations are generated automatically
/// based on analysis of user resources, configuration and monitoring metrics.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class RecommenderClient {
 public:
  explicit RecommenderClient(std::shared_ptr<RecommenderConnection> connection,
                             Options opts = {});
  ~RecommenderClient();

  ///@{
  /// @name Copy and move support
  RecommenderClient(RecommenderClient const&) = default;
  RecommenderClient& operator=(RecommenderClient const&) = default;
  RecommenderClient(RecommenderClient&&) = default;
  RecommenderClient& operator=(RecommenderClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(RecommenderClient const& a,
                         RecommenderClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(RecommenderClient const& a,
                         RecommenderClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists insights for the specified Cloud Resource. Requires the
  /// recommender.*.list IAM permission for the specified insight type.
  ///
  /// @param parent  Required. The container resource on which to execute the request.
  ///  Acceptable formats:
  ///  @n
  ///  * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
  ///  @n
  ///  * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
  ///  @n
  ///  * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
  ///  @n
  ///  * `folders/[FOLDER_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
  ///  @n
  ///  * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]`
  ///  @n
  ///  LOCATION here refers to GCP Locations:
  ///  https://cloud.google.com/about/locations/
  ///  INSIGHT_TYPE_ID refers to supported insight types:
  ///  https://cloud.google.com/recommender/docs/insights/insight-types.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.recommender.v1.Insight], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.Insight]: @googleapis_reference_link{google/cloud/recommender/v1/insight.proto#L40}
  /// [google.cloud.recommender.v1.ListInsightsRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L341}
  ///
  // clang-format on
  StreamRange<google::cloud::recommender::v1::Insight> ListInsights(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists insights for the specified Cloud Resource. Requires the
  /// recommender.*.list IAM permission for the specified insight type.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.ListInsightsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.recommender.v1.Insight], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.Insight]: @googleapis_reference_link{google/cloud/recommender/v1/insight.proto#L40}
  /// [google.cloud.recommender.v1.ListInsightsRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L341}
  ///
  // clang-format on
  StreamRange<google::cloud::recommender::v1::Insight> ListInsights(
      google::cloud::recommender::v1::ListInsightsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the requested insight. Requires the recommender.*.get IAM permission
  /// for the specified insight type.
  ///
  /// @param name  Required. Name of the insight.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Insight])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetInsightRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L419}
  /// [google.cloud.recommender.v1.Insight]: @googleapis_reference_link{google/cloud/recommender/v1/insight.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Insight> GetInsight(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the requested insight. Requires the recommender.*.get IAM permission
  /// for the specified insight type.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.GetInsightRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Insight])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetInsightRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L419}
  /// [google.cloud.recommender.v1.Insight]: @googleapis_reference_link{google/cloud/recommender/v1/insight.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Insight> GetInsight(
      google::cloud::recommender::v1::GetInsightRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Marks the Insight State as Accepted. Users can use this method to
  /// indicate to the Recommender API that they have applied some action based
  /// on the insight. This stops the insight content from being updated.
  ///
  /// MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
  /// the recommender.*.update IAM permission for the specified insight.
  ///
  /// @param name  Required. Name of the insight.
  /// @param state_metadata  Optional. State properties user wish to include with this state.  Full
  ///  replace of the current state_metadata.
  /// @param etag  Required. Fingerprint of the Insight. Provides optimistic locking.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Insight])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.Insight]: @googleapis_reference_link{google/cloud/recommender/v1/insight.proto#L40}
  /// [google.cloud.recommender.v1.MarkInsightAcceptedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L430}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Insight> MarkInsightAccepted(
      std::string const& name,
      std::map<std::string, std::string> const& state_metadata,
      std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// Marks the Insight State as Accepted. Users can use this method to
  /// indicate to the Recommender API that they have applied some action based
  /// on the insight. This stops the insight content from being updated.
  ///
  /// MarkInsightAccepted can be applied to insights in ACTIVE state. Requires
  /// the recommender.*.update IAM permission for the specified insight.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.MarkInsightAcceptedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Insight])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.Insight]: @googleapis_reference_link{google/cloud/recommender/v1/insight.proto#L40}
  /// [google.cloud.recommender.v1.MarkInsightAcceptedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L430}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Insight> MarkInsightAccepted(
      google::cloud::recommender::v1::MarkInsightAcceptedRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists recommendations for the specified Cloud Resource. Requires the
  /// recommender.*.list IAM permission for the specified recommender.
  ///
  /// @param parent  Required. The container resource on which to execute the request.
  ///  Acceptable formats:
  ///  @n
  ///  * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  LOCATION here refers to GCP Locations:
  ///  https://cloud.google.com/about/locations/
  ///  RECOMMENDER_ID refers to supported recommenders:
  ///  https://cloud.google.com/recommender/docs/recommenders.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.recommender.v1.Recommendation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.ListRecommendationsRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L449}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StreamRange<google::cloud::recommender::v1::Recommendation>
  ListRecommendations(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists recommendations for the specified Cloud Resource. Requires the
  /// recommender.*.list IAM permission for the specified recommender.
  ///
  /// @param parent  Required. The container resource on which to execute the request.
  ///  Acceptable formats:
  ///  @n
  ///  * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `folders/[FOLDER_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]`
  ///  @n
  ///  LOCATION here refers to GCP Locations:
  ///  https://cloud.google.com/about/locations/
  ///  RECOMMENDER_ID refers to supported recommenders:
  ///  https://cloud.google.com/recommender/docs/recommenders.
  /// @param filter  Filter expression to restrict the recommendations returned. Supported
  ///  filter fields:
  ///  @n
  ///  For more information, see [ListRecommendationsRequest][google.cloud.recommender.v1.ListRecommendationsRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.recommender.v1.Recommendation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.ListRecommendationsRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L449}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StreamRange<google::cloud::recommender::v1::Recommendation>
  ListRecommendations(std::string const& parent, std::string const& filter,
                      Options opts = {});

  // clang-format off
  ///
  /// Lists recommendations for the specified Cloud Resource. Requires the
  /// recommender.*.list IAM permission for the specified recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.ListRecommendationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.recommender.v1.Recommendation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.ListRecommendationsRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L449}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StreamRange<google::cloud::recommender::v1::Recommendation>
  ListRecommendations(
      google::cloud::recommender::v1::ListRecommendationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the requested recommendation. Requires the recommender.*.get
  /// IAM permission for the specified recommender.
  ///
  /// @param name  Required. Name of the recommendation.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetRecommendationRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L527}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation> GetRecommendation(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the requested recommendation. Requires the recommender.*.get
  /// IAM permission for the specified recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.GetRecommendationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetRecommendationRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L527}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation> GetRecommendation(
      google::cloud::recommender::v1::GetRecommendationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Mark the Recommendation State as Dismissed. Users can use this method to
  /// indicate to the Recommender API that an ACTIVE recommendation has to
  /// be marked back as DISMISSED.
  ///
  /// MarkRecommendationDismissed can be applied to recommendations in ACTIVE
  /// state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.MarkRecommendationDismissedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationDismissedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L538}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationDismissed(
      google::cloud::recommender::v1::MarkRecommendationDismissedRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Marks the Recommendation State as Claimed. Users can use this method to
  /// indicate to the Recommender API that they are starting to apply the
  /// recommendation themselves. This stops the recommendation content from being
  /// updated. Associated insights are frozen and placed in the ACCEPTED state.
  ///
  /// MarkRecommendationClaimed can be applied to recommendations in CLAIMED,
  /// SUCCEEDED, FAILED, or ACTIVE state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param name  Required. Name of the recommendation.
  /// @param state_metadata  State properties to include with this state. Overwrites any existing
  ///  `state_metadata`.
  ///  Keys must match the regex `/^[a-z0-9][a-z0-9_.-]{0,62}$/`.
  ///  Values must match the regex `/^[a-zA-Z0-9_./-]{0,255}$/`.
  /// @param etag  Required. Fingerprint of the Recommendation. Provides optimistic locking.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationClaimedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L552}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationClaimed(
      std::string const& name,
      std::map<std::string, std::string> const& state_metadata,
      std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// Marks the Recommendation State as Claimed. Users can use this method to
  /// indicate to the Recommender API that they are starting to apply the
  /// recommendation themselves. This stops the recommendation content from being
  /// updated. Associated insights are frozen and placed in the ACCEPTED state.
  ///
  /// MarkRecommendationClaimed can be applied to recommendations in CLAIMED,
  /// SUCCEEDED, FAILED, or ACTIVE state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.MarkRecommendationClaimedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationClaimedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L552}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationClaimed(
      google::cloud::recommender::v1::MarkRecommendationClaimedRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Marks the Recommendation State as Succeeded. Users can use this method to
  /// indicate to the Recommender API that they have applied the recommendation
  /// themselves, and the operation was successful. This stops the recommendation
  /// content from being updated. Associated insights are frozen and placed in
  /// the ACCEPTED state.
  ///
  /// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
  /// CLAIMED, SUCCEEDED, or FAILED state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param name  Required. Name of the recommendation.
  /// @param state_metadata  State properties to include with this state. Overwrites any existing
  ///  `state_metadata`.
  ///  Keys must match the regex `/^[a-z0-9][a-z0-9_.-]{0,62}$/`.
  ///  Values must match the regex `/^[a-zA-Z0-9_./-]{0,255}$/`.
  /// @param etag  Required. Fingerprint of the Recommendation. Provides optimistic locking.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationSucceededRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L572}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationSucceeded(
      std::string const& name,
      std::map<std::string, std::string> const& state_metadata,
      std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// Marks the Recommendation State as Succeeded. Users can use this method to
  /// indicate to the Recommender API that they have applied the recommendation
  /// themselves, and the operation was successful. This stops the recommendation
  /// content from being updated. Associated insights are frozen and placed in
  /// the ACCEPTED state.
  ///
  /// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
  /// CLAIMED, SUCCEEDED, or FAILED state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.MarkRecommendationSucceededRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationSucceededRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L572}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationSucceeded(
      google::cloud::recommender::v1::MarkRecommendationSucceededRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Marks the Recommendation State as Failed. Users can use this method to
  /// indicate to the Recommender API that they have applied the recommendation
  /// themselves, and the operation failed. This stops the recommendation content
  /// from being updated. Associated insights are frozen and placed in the
  /// ACCEPTED state.
  ///
  /// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
  /// CLAIMED, SUCCEEDED, or FAILED state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param name  Required. Name of the recommendation.
  /// @param state_metadata  State properties to include with this state. Overwrites any existing
  ///  `state_metadata`.
  ///  Keys must match the regex `/^[a-z0-9][a-z0-9_.-]{0,62}$/`.
  ///  Values must match the regex `/^[a-zA-Z0-9_./-]{0,255}$/`.
  /// @param etag  Required. Fingerprint of the Recommendation. Provides optimistic locking.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationFailedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L592}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationFailed(
      std::string const& name,
      std::map<std::string, std::string> const& state_metadata,
      std::string const& etag, Options opts = {});

  // clang-format off
  ///
  /// Marks the Recommendation State as Failed. Users can use this method to
  /// indicate to the Recommender API that they have applied the recommendation
  /// themselves, and the operation failed. This stops the recommendation content
  /// from being updated. Associated insights are frozen and placed in the
  /// ACCEPTED state.
  ///
  /// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
  /// CLAIMED, SUCCEEDED, or FAILED state.
  ///
  /// Requires the recommender.*.update IAM permission for the specified
  /// recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.MarkRecommendationFailedRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.Recommendation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.MarkRecommendationFailedRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L592}
  /// [google.cloud.recommender.v1.Recommendation]: @googleapis_reference_link{google/cloud/recommender/v1/recommendation.proto#L40}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::Recommendation>
  MarkRecommendationFailed(
      google::cloud::recommender::v1::MarkRecommendationFailedRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the requested Recommender Config. There is only one instance of the
  /// config for each Recommender.
  ///
  /// @param name  Required. Name of the Recommendation Config to get.
  ///  @n
  ///  Acceptable formats:
  ///  @n
  ///  * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
  ///  @n
  ///  * `projects/[PROJECT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
  ///  @n
  ///  * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
  ///  @n
  ///  * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]/config`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.RecommenderConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetRecommenderConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L612}
  /// [google.cloud.recommender.v1.RecommenderConfig]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::RecommenderConfig>
  GetRecommenderConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the requested Recommender Config. There is only one instance of the
  /// config for each Recommender.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.GetRecommenderConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.RecommenderConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetRecommenderConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L612}
  /// [google.cloud.recommender.v1.RecommenderConfig]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::RecommenderConfig>
  GetRecommenderConfig(
      google::cloud::recommender::v1::GetRecommenderConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a Recommender Config. This will create a new revision of the
  /// config.
  ///
  /// @param recommender_config  Required. The RecommenderConfig to update.
  /// @param update_mask  The list of fields to be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.RecommenderConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.RecommenderConfig]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_config.proto#L32}
  /// [google.cloud.recommender.v1.UpdateRecommenderConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L633}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::RecommenderConfig>
  UpdateRecommenderConfig(
      google::cloud::recommender::v1::RecommenderConfig const&
          recommender_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Recommender Config. This will create a new revision of the
  /// config.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.UpdateRecommenderConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.RecommenderConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.RecommenderConfig]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_config.proto#L32}
  /// [google.cloud.recommender.v1.UpdateRecommenderConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L633}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::RecommenderConfig>
  UpdateRecommenderConfig(
      google::cloud::recommender::v1::UpdateRecommenderConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the requested InsightTypeConfig. There is only one instance of the
  /// config for each InsightType.
  ///
  /// @param name  Required. Name of the InsightTypeConfig to get.
  ///  @n
  ///  Acceptable formats:
  ///  @n
  ///  * `projects/[PROJECT_NUMBER]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
  ///  @n
  ///  * `projects/[PROJECT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
  ///  @n
  ///  * `organizations/[ORGANIZATION_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
  ///  @n
  ///  * `billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION]/insightTypes/[INSIGHT_TYPE_ID]/config`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.InsightTypeConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetInsightTypeConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L647}
  /// [google.cloud.recommender.v1.InsightTypeConfig]: @googleapis_reference_link{google/cloud/recommender/v1/insight_type_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
  GetInsightTypeConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the requested InsightTypeConfig. There is only one instance of the
  /// config for each InsightType.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.GetInsightTypeConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.InsightTypeConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.GetInsightTypeConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L647}
  /// [google.cloud.recommender.v1.InsightTypeConfig]: @googleapis_reference_link{google/cloud/recommender/v1/insight_type_config.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
  GetInsightTypeConfig(
      google::cloud::recommender::v1::GetInsightTypeConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an InsightTypeConfig change. This will create a new revision of the
  /// config.
  ///
  /// @param insight_type_config  Required. The InsightTypeConfig to update.
  /// @param update_mask  The list of fields to be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.InsightTypeConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.InsightTypeConfig]: @googleapis_reference_link{google/cloud/recommender/v1/insight_type_config.proto#L32}
  /// [google.cloud.recommender.v1.UpdateInsightTypeConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L668}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
  UpdateInsightTypeConfig(
      google::cloud::recommender::v1::InsightTypeConfig const&
          insight_type_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an InsightTypeConfig change. This will create a new revision of the
  /// config.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.recommender.v1.UpdateInsightTypeConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.recommender.v1.InsightTypeConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.recommender.v1.InsightTypeConfig]: @googleapis_reference_link{google/cloud/recommender/v1/insight_type_config.proto#L32}
  /// [google.cloud.recommender.v1.UpdateInsightTypeConfigRequest]: @googleapis_reference_link{google/cloud/recommender/v1/recommender_service.proto#L668}
  ///
  // clang-format on
  StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
  UpdateInsightTypeConfig(
      google::cloud::recommender::v1::UpdateInsightTypeConfigRequest const&
          request,
      Options opts = {});

 private:
  std::shared_ptr<RecommenderConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recommender_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECOMMENDER_V1_RECOMMENDER_CLIENT_H
