// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/metastore/v1/metastore.proto

#include "google/cloud/metastore/v1/internal/dataproc_metastore_option_defaults.h"
#include "google/cloud/metastore/v1/dataproc_metastore_connection.h"
#include "google/cloud/metastore/v1/dataproc_metastore_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace metastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options DataprocMetastoreDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_DATAPROC_METASTORE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_DATAPROC_METASTORE_AUTHORITY",
      "metastore.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<metastore_v1::DataprocMetastoreRetryPolicyOption>()) {
    options.set<metastore_v1::DataprocMetastoreRetryPolicyOption>(
        metastore_v1::DataprocMetastoreLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<metastore_v1::DataprocMetastoreBackoffPolicyOption>()) {
    options.set<metastore_v1::DataprocMetastoreBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<metastore_v1::DataprocMetastorePollingPolicyOption>()) {
    options.set<metastore_v1::DataprocMetastorePollingPolicyOption>(
        GenericPollingPolicy<
            metastore_v1::DataprocMetastoreRetryPolicyOption::Type,
            metastore_v1::DataprocMetastoreBackoffPolicyOption::Type>(
            options.get<metastore_v1::DataprocMetastoreRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          metastore_v1::DataprocMetastoreConnectionIdempotencyPolicyOption>()) {
    options
        .set<metastore_v1::DataprocMetastoreConnectionIdempotencyPolicyOption>(
            metastore_v1::
                MakeDefaultDataprocMetastoreConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace metastore_v1_internal
}  // namespace cloud
}  // namespace google
