// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#include "google/cloud/gkehub/v1/internal/gke_hub_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gkehub/v1/service.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace gkehub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GkeHubMetadata::GkeHubMetadata(
    std::shared_ptr<GkeHubStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::gkehub::v1::ListMembershipsResponse>
GkeHubMetadata::ListMemberships(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::ListMembershipsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListMemberships(context, options, request);
}

StatusOr<google::cloud::gkehub::v1::ListFeaturesResponse>
GkeHubMetadata::ListFeatures(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::ListFeaturesRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListFeatures(context, options, request);
}

StatusOr<google::cloud::gkehub::v1::Membership> GkeHubMetadata::GetMembership(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::GetMembershipRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetMembership(context, options, request);
}

StatusOr<google::cloud::gkehub::v1::Feature> GkeHubMetadata::GetFeature(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::GetFeatureRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetFeature(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncCreateMembership(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateMembership(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> GkeHubMetadata::CreateMembership(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateMembership(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncCreateFeature(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateFeature(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> GkeHubMetadata::CreateFeature(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateFeature(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncDeleteMembership(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteMembership(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> GkeHubMetadata::DeleteMembership(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteMembership(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncDeleteFeature(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteFeature(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> GkeHubMetadata::DeleteFeature(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteFeature(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncUpdateMembership(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncUpdateMembership(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation> GkeHubMetadata::UpdateMembership(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UpdateMembership(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncUpdateFeature(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncUpdateFeature(cq, std::move(context), std::move(options),
                                    request);
}

StatusOr<google::longrunning::Operation> GkeHubMetadata::UpdateFeature(
    grpc::ClientContext& context, Options options,
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UpdateFeature(context, options, request);
}

StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
GkeHubMetadata::GenerateConnectManifest(
    grpc::ClientContext& context, Options const& options,
    google::cloud::gkehub::v1::GenerateConnectManifestRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GenerateConnectManifest(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
GkeHubMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> GkeHubMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void GkeHubMetadata::SetMetadata(grpc::ClientContext& context,
                                 Options const& options,
                                 std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void GkeHubMetadata::SetMetadata(grpc::ClientContext& context,
                                 Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1_internal
}  // namespace cloud
}  // namespace google
