// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/user_event_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_USER_EVENT_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_USER_EVENT_TRACING_CONNECTION_H

#include "google/cloud/discoveryengine/v1/user_event_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class UserEventServiceTracingConnection
    : public discoveryengine_v1::UserEventServiceConnection {
 public:
  ~UserEventServiceTracingConnection() override = default;

  explicit UserEventServiceTracingConnection(
      std::shared_ptr<discoveryengine_v1::UserEventServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::discoveryengine::v1::UserEvent> WriteUserEvent(
      google::cloud::discoveryengine::v1::WriteUserEventRequest const& request)
      override;

  StatusOr<google::api::HttpBody> CollectUserEvent(
      google::cloud::discoveryengine::v1::CollectUserEventRequest const&
          request) override;

  future<StatusOr<google::cloud::discoveryengine::v1::PurgeUserEventsResponse>>
  PurgeUserEvents(
      google::cloud::discoveryengine::v1::PurgeUserEventsRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> PurgeUserEvents(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::PurgeUserEventsRequest const& request)
      override;

  future<StatusOr<google::cloud::discoveryengine::v1::PurgeUserEventsResponse>>
  PurgeUserEvents(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::discoveryengine::v1::ImportUserEventsResponse>>
  ImportUserEvents(
      google::cloud::discoveryengine::v1::ImportUserEventsRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> ImportUserEvents(
      NoAwaitTag,
      google::cloud::discoveryengine::v1::ImportUserEventsRequest const&
          request) override;

  future<StatusOr<google::cloud::discoveryengine::v1::ImportUserEventsResponse>>
  ImportUserEvents(google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<discoveryengine_v1::UserEventServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<discoveryengine_v1::UserEventServiceConnection>
MakeUserEventServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::UserEventServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_USER_EVENT_TRACING_CONNECTION_H
