// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/participant.proto

#include "google/cloud/dialogflow_es/internal/participants_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/internal/async_read_write_stream_impl.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/v2/participant.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ParticipantsStub::~ParticipantsStub() = default;

StatusOr<google::cloud::dialogflow::v2::Participant>
DefaultParticipantsStub::CreateParticipant(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::CreateParticipantRequest const& request) {
  google::cloud::dialogflow::v2::Participant response;
  auto status = grpc_stub_->CreateParticipant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Participant>
DefaultParticipantsStub::GetParticipant(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::GetParticipantRequest const& request) {
  google::cloud::dialogflow::v2::Participant response;
  auto status = grpc_stub_->GetParticipant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::ListParticipantsResponse>
DefaultParticipantsStub::ListParticipants(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::ListParticipantsRequest const& request) {
  google::cloud::dialogflow::v2::ListParticipantsResponse response;
  auto status = grpc_stub_->ListParticipants(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Participant>
DefaultParticipantsStub::UpdateParticipant(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::UpdateParticipantRequest const& request) {
  google::cloud::dialogflow::v2::Participant response;
  auto status = grpc_stub_->UpdateParticipant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::AnalyzeContentResponse>
DefaultParticipantsStub::AnalyzeContent(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::AnalyzeContentRequest const& request) {
  google::cloud::dialogflow::v2::AnalyzeContentResponse response;
  auto status = grpc_stub_->AnalyzeContent(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::dialogflow::v2::StreamingAnalyzeContentRequest,
    google::cloud::dialogflow::v2::StreamingAnalyzeContentResponse>>
DefaultParticipantsStub::AsyncStreamingAnalyzeContent(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  return google::cloud::internal::MakeStreamingReadWriteRpc<
      google::cloud::dialogflow::v2::StreamingAnalyzeContentRequest,
      google::cloud::dialogflow::v2::StreamingAnalyzeContentResponse>(
      cq, std::move(context), std::move(options),
      [this](grpc::ClientContext* context, grpc::CompletionQueue* cq) {
        return grpc_stub_->PrepareAsyncStreamingAnalyzeContent(context, cq);
      });
}

StatusOr<google::cloud::dialogflow::v2::SuggestArticlesResponse>
DefaultParticipantsStub::SuggestArticles(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::SuggestArticlesRequest const& request) {
  google::cloud::dialogflow::v2::SuggestArticlesResponse response;
  auto status = grpc_stub_->SuggestArticles(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::SuggestFaqAnswersResponse>
DefaultParticipantsStub::SuggestFaqAnswers(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::SuggestFaqAnswersRequest const& request) {
  google::cloud::dialogflow::v2::SuggestFaqAnswersResponse response;
  auto status = grpc_stub_->SuggestFaqAnswers(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::SuggestSmartRepliesResponse>
DefaultParticipantsStub::SuggestSmartReplies(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::SuggestSmartRepliesRequest const& request) {
  google::cloud::dialogflow::v2::SuggestSmartRepliesResponse response;
  auto status = grpc_stub_->SuggestSmartReplies(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::SuggestKnowledgeAssistResponse>
DefaultParticipantsStub::SuggestKnowledgeAssist(
    grpc::ClientContext& context, Options const&,
    google::cloud::dialogflow::v2::SuggestKnowledgeAssistRequest const&
        request) {
  google::cloud::dialogflow::v2::SuggestKnowledgeAssistResponse response;
  auto status =
      grpc_stub_->SuggestKnowledgeAssist(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
