// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datastream/v1/datastream.proto

#include "google/cloud/datastream/v1/internal/datastream_option_defaults.h"
#include "google/cloud/datastream/v1/datastream_connection.h"
#include "google/cloud/datastream/v1/datastream_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace datastream_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options DatastreamDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_DATASTREAM_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_DATASTREAM_AUTHORITY", "datastream.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<datastream_v1::DatastreamRetryPolicyOption>()) {
    options.set<datastream_v1::DatastreamRetryPolicyOption>(
        datastream_v1::DatastreamLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<datastream_v1::DatastreamBackoffPolicyOption>()) {
    options.set<datastream_v1::DatastreamBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<datastream_v1::DatastreamPollingPolicyOption>()) {
    options.set<datastream_v1::DatastreamPollingPolicyOption>(
        GenericPollingPolicy<
            datastream_v1::DatastreamRetryPolicyOption::Type,
            datastream_v1::DatastreamBackoffPolicyOption::Type>(
            options.get<datastream_v1::DatastreamRetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<datastream_v1::DatastreamConnectionIdempotencyPolicyOption>()) {
    options.set<datastream_v1::DatastreamConnectionIdempotencyPolicyOption>(
        datastream_v1::MakeDefaultDatastreamConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastream_v1_internal
}  // namespace cloud
}  // namespace google
