// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/sessions.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_CONTROLLER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_CONTROLLER_TRACING_CONNECTION_H

#include "google/cloud/dataproc/v1/session_controller_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class SessionControllerTracingConnection
    : public dataproc_v1::SessionControllerConnection {
 public:
  ~SessionControllerTracingConnection() override = default;

  explicit SessionControllerTracingConnection(
      std::shared_ptr<dataproc_v1::SessionControllerConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::dataproc::v1::Session>> CreateSession(
      google::cloud::dataproc::v1::CreateSessionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateSession(
      NoAwaitTag,
      google::cloud::dataproc::v1::CreateSessionRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::Session>> CreateSession(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::dataproc::v1::Session> GetSession(
      google::cloud::dataproc::v1::GetSessionRequest const& request) override;

  StreamRange<google::cloud::dataproc::v1::Session> ListSessions(
      google::cloud::dataproc::v1::ListSessionsRequest request) override;

  future<StatusOr<google::cloud::dataproc::v1::Session>> TerminateSession(
      google::cloud::dataproc::v1::TerminateSessionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> TerminateSession(
      NoAwaitTag,
      google::cloud::dataproc::v1::TerminateSessionRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::Session>> TerminateSession(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dataproc::v1::Session>> DeleteSession(
      google::cloud::dataproc::v1::DeleteSessionRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteSession(
      NoAwaitTag,
      google::cloud::dataproc::v1::DeleteSessionRequest const& request)
      override;

  future<StatusOr<google::cloud::dataproc::v1::Session>> DeleteSession(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<dataproc_v1::SessionControllerConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dataproc_v1::SessionControllerConnection>
MakeSessionControllerTracingConnection(
    std::shared_ptr<dataproc_v1::SessionControllerConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_INTERNAL_SESSION_CONTROLLER_TRACING_CONNECTION_H
