// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/jobs.proto

#include "google/cloud/dataproc/v1/internal/job_controller_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

JobControllerTracingConnection::JobControllerTracingConnection(
    std::shared_ptr<dataproc_v1::JobControllerConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::dataproc::v1::Job>
JobControllerTracingConnection::SubmitJob(
    google::cloud::dataproc::v1::SubmitJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataproc_v1::JobControllerConnection::SubmitJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SubmitJob(request));
}

future<StatusOr<google::cloud::dataproc::v1::Job>>
JobControllerTracingConnection::SubmitJobAsOperation(
    google::cloud::dataproc::v1::SubmitJobRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::JobControllerConnection::SubmitJobAsOperation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SubmitJobAsOperation(request));
}

StatusOr<google::longrunning::Operation>
JobControllerTracingConnection::SubmitJobAsOperation(
    NoAwaitTag, google::cloud::dataproc::v1::SubmitJobRequest const& request) {
  auto span = internal::MakeSpan(
      "dataproc_v1::JobControllerConnection::SubmitJobAsOperation");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->SubmitJobAsOperation(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataproc::v1::Job>>
JobControllerTracingConnection::SubmitJobAsOperation(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataproc_v1::JobControllerConnection::SubmitJobAsOperation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->SubmitJobAsOperation(operation));
}

StatusOr<google::cloud::dataproc::v1::Job>
JobControllerTracingConnection::GetJob(
    google::cloud::dataproc::v1::GetJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataproc_v1::JobControllerConnection::GetJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetJob(request));
}

StreamRange<google::cloud::dataproc::v1::Job>
JobControllerTracingConnection::ListJobs(
    google::cloud::dataproc::v1::ListJobsRequest request) {
  auto span =
      internal::MakeSpan("dataproc_v1::JobControllerConnection::ListJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListJobs(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataproc::v1::Job>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataproc::v1::Job>
JobControllerTracingConnection::UpdateJob(
    google::cloud::dataproc::v1::UpdateJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataproc_v1::JobControllerConnection::UpdateJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateJob(request));
}

StatusOr<google::cloud::dataproc::v1::Job>
JobControllerTracingConnection::CancelJob(
    google::cloud::dataproc::v1::CancelJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataproc_v1::JobControllerConnection::CancelJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelJob(request));
}

Status JobControllerTracingConnection::DeleteJob(
    google::cloud::dataproc::v1::DeleteJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataproc_v1::JobControllerConnection::DeleteJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteJob(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dataproc_v1::JobControllerConnection>
MakeJobControllerTracingConnection(
    std::shared_ptr<dataproc_v1::JobControllerConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<JobControllerTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
