// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#include "google/cloud/dataplex/v1/internal/data_scan_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/data_scan_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dataplex_v1::DataScanServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dataplex_v1::DataScanServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dataplex_v1::DataScanServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<dataplex_v1::DataScanServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dataplex_v1::DataScanServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<dataplex_v1::DataScanServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

DataScanServiceConnectionImpl::DataScanServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dataplex_v1_internal::DataScanServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DataScanServiceConnection::options())) {}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnectionImpl::CreateDataScan(
    google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDataScan(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataScan>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
        return stub->AsyncCreateDataScan(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataScan>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnectionImpl::CreateDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDataScan(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
        return stub_->CreateDataScan(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnectionImpl::CreateDataScan(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::DataScan>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDataScan",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataScan>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataScan>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnectionImpl::UpdateDataScan(
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateDataScan(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataScan>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
        return stub->AsyncUpdateDataScan(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataScan>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnectionImpl::UpdateDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDataScan(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
        return stub_->UpdateDataScan(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceConnectionImpl::UpdateDataScan(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::dataplex::v1::DataScan>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateDataScan",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataScan>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataScan>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceConnectionImpl::DeleteDataScan(
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDataScan(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
        return stub->AsyncDeleteDataScan(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataScanServiceConnectionImpl::DeleteDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDataScan(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
        return stub_->DeleteDataScan(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceConnectionImpl::DeleteDataScan(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDataScan",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::dataplex::v1::DataScan>
DataScanServiceConnectionImpl::GetDataScan(
    google::cloud::dataplex::v1::GetDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDataScan(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GetDataScanRequest const& request) {
        return stub_->GetDataScan(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::dataplex::v1::DataScan>
DataScanServiceConnectionImpl::ListDataScans(
    google::cloud::dataplex::v1::ListDataScansRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDataScans(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataScan>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataScanServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListDataScansRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListDataScansRequest const&
                       request) {
              return stub->ListDataScans(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListDataScansResponse r) {
        std::vector<google::cloud::dataplex::v1::DataScan> result(
            r.data_scans().size());
        auto& messages = *r.mutable_data_scans();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::RunDataScanResponse>
DataScanServiceConnectionImpl::RunDataScan(
    google::cloud::dataplex::v1::RunDataScanRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunDataScan(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::RunDataScanRequest const& request) {
        return stub_->RunDataScan(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceConnectionImpl::GetDataScanJob(
    google::cloud::dataplex::v1::GetDataScanJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDataScanJob(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::GetDataScanJobRequest const& request) {
        return stub_->GetDataScanJob(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceConnectionImpl::ListDataScanJobs(
    google::cloud::dataplex::v1::ListDataScanJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDataScanJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataScanJob>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataScanServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListDataScanJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListDataScanJobsRequest const&
                       request) {
              return stub->ListDataScanJobs(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListDataScanJobsResponse r) {
        std::vector<google::cloud::dataplex::v1::DataScanJob> result(
            r.data_scan_jobs().size());
        auto& messages = *r.mutable_data_scan_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
DataScanServiceConnectionImpl::GenerateDataQualityRules(
    google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateDataQualityRules(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&
                 request) {
        return stub_->GenerateDataQualityRules(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
