// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/storage_pool_types/v1/storage_pool_types.proto

#include "google/cloud/compute/storage_pool_types/v1/internal/storage_pool_types_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_storage_pool_types_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

StoragePoolTypesTracingConnection::StoragePoolTypesTracingConnection(
    std::shared_ptr<compute_storage_pool_types_v1::StoragePoolTypesConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::StoragePoolTypesScopedList>>
StoragePoolTypesTracingConnection::AggregatedListStoragePoolTypes(
    google::cloud::cpp::compute::storage_pool_types::v1::
        AggregatedListStoragePoolTypesRequest request) {
  auto span = internal::MakeSpan(
      "compute_storage_pool_types_v1::StoragePoolTypesConnection::"
      "AggregatedListStoragePoolTypes");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListStoragePoolTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::StoragePoolTypesScopedList>>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesTracingConnection::GetStoragePoolType(
    google::cloud::cpp::compute::storage_pool_types::v1::
        GetStoragePoolTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_storage_pool_types_v1::StoragePoolTypesConnection::"
      "GetStoragePoolType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetStoragePoolType(request));
}

StreamRange<google::cloud::cpp::compute::v1::StoragePoolType>
StoragePoolTypesTracingConnection::ListStoragePoolTypes(
    google::cloud::cpp::compute::storage_pool_types::v1::
        ListStoragePoolTypesRequest request) {
  auto span = internal::MakeSpan(
      "compute_storage_pool_types_v1::StoragePoolTypesConnection::"
      "ListStoragePoolTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListStoragePoolTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::StoragePoolType>(std::move(span),
                                                        std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_storage_pool_types_v1::StoragePoolTypesConnection>
MakeStoragePoolTypesTracingConnection(
    std::shared_ptr<compute_storage_pool_types_v1::StoragePoolTypesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<StoragePoolTypesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_storage_pool_types_v1_internal
}  // namespace cloud
}  // namespace google
