// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CERTIFICATEMANAGER_V1_CERTIFICATE_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CERTIFICATEMANAGER_V1_CERTIFICATE_MANAGER_CLIENT_H

#include "google/cloud/certificatemanager/v1/certificate_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace certificatemanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API Overview
///
/// Certificates Manager API allows customers to see and manage all their TLS
/// certificates.
///
/// Certificates Manager API service provides methods to manage certificates,
/// group them into collections, and create serving configuration that can be
/// easily applied to other Cloud resources e.g. Target Proxies.
///
/// Data Model
///
/// The Certificates Manager service exposes the following resources:
///
/// * `Certificate` that describes a single TLS certificate.
/// * `CertificateMap` that describes a collection of certificates that can be
/// attached to a target resource.
/// * `CertificateMapEntry` that describes a single configuration entry that
/// consists of a SNI and a group of certificates. It's a subresource of
/// CertificateMap.
///
/// Certificate, CertificateMap and CertificateMapEntry IDs
/// have to fully match the regexp `[a-z0-9-]{1,63}`. In other words,
/// - only lower case letters, digits, and hyphen are allowed
/// - length of the resource ID has to be in [1,63] range.
///
/// Provides methods to manage Cloud Certificate Manager entities.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CertificateManagerClient {
 public:
  explicit CertificateManagerClient(
      std::shared_ptr<CertificateManagerConnection> connection,
      Options opts = {});
  ~CertificateManagerClient();

  ///@{
  /// @name Copy and move support
  CertificateManagerClient(CertificateManagerClient const&) = default;
  CertificateManagerClient& operator=(CertificateManagerClient const&) =
      default;
  CertificateManagerClient(CertificateManagerClient&&) = default;
  CertificateManagerClient& operator=(CertificateManagerClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(CertificateManagerClient const& a,
                         CertificateManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CertificateManagerClient const& a,
                         CertificateManagerClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists Certificates in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the certificate should be
  ///  listed, specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.Certificate], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.ListCertificatesRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L415}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::Certificate>
  ListCertificates(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Certificates in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.ListCertificatesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.Certificate], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.ListCertificatesRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L415}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::Certificate>
  ListCertificates(
      google::cloud::certificatemanager::v1::ListCertificatesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Certificate.
  ///
  /// @param name  Required. A name of the certificate to describe. Must be in the format
  ///  `projects/*/locations/*/certificates/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.Certificate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.GetCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L457}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::Certificate> GetCertificate(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Certificate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.GetCertificateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.Certificate])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.GetCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L457}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::Certificate> GetCertificate(
      google::cloud::certificatemanager::v1::GetCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Certificate in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the certificate. Must be in the format
  ///  `projects/*/locations/*`.
  /// @param certificate  Required. A definition of the certificate to create.
  /// @param certificate_id  Required. A user-provided name of the certificate.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.Certificate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.CreateCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L469}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
  CreateCertificate(
      std::string const& parent,
      google::cloud::certificatemanager::v1::Certificate const& certificate,
      std::string const& certificate_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificate(
      NoAwaitTag, std::string const& parent,
      google::cloud::certificatemanager::v1::Certificate const& certificate,
      std::string const& certificate_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Certificate in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.CreateCertificateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.Certificate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.CreateCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L469}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
  CreateCertificate(
      google::cloud::certificatemanager::v1::CreateCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificate(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::CreateCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
  CreateCertificate(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Updates a Certificate.
  ///
  /// @param certificate  Required. A definition of the certificate to update.
  /// @param update_mask  Required. The update mask applies to the resource. For the `FieldMask`
  ///  definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.Certificate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.UpdateCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L487}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
  UpdateCertificate(
      google::cloud::certificatemanager::v1::Certificate const& certificate,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCertificate(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::Certificate const& certificate,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Certificate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.UpdateCertificateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.Certificate] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.Certificate]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L836}
  /// [google.cloud.certificatemanager.v1.UpdateCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L487}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
  UpdateCertificate(
      google::cloud::certificatemanager::v1::UpdateCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCertificate(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::UpdateCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::Certificate>>
  UpdateCertificate(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Certificate.
  ///
  /// @param name  Required. A name of the certificate to delete. Must be in the format
  ///  `projects/*/locations/*/certificates/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L499}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificate(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificate(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Certificate.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.DeleteCertificateRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L499}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificate(
      google::cloud::certificatemanager::v1::DeleteCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificate
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificate(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::DeleteCertificateRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificate
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificate(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Lists CertificateMaps in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the certificate maps should
  ///  be listed, specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.CertificateMap], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.ListCertificateMapsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L511}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::CertificateMap>
  ListCertificateMaps(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists CertificateMaps in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.ListCertificateMapsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.CertificateMap], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.ListCertificateMapsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L511}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::CertificateMap>
  ListCertificateMaps(
      google::cloud::certificatemanager::v1::ListCertificateMapsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single CertificateMap.
  ///
  /// @param name  Required. A name of the certificate map to describe. Must be in the format
  ///  `projects/*/locations/*/certificateMaps/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.CertificateMap])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.GetCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L553}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::CertificateMap>
  GetCertificateMap(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single CertificateMap.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.GetCertificateMapRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.CertificateMap])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.GetCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L553}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::CertificateMap>
  GetCertificateMap(
      google::cloud::certificatemanager::v1::GetCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new CertificateMap in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the certificate map. Must be in the format
  ///  `projects/*/locations/*`.
  /// @param certificate_map  Required. A definition of the certificate map to create.
  /// @param certificate_map_id  Required. A user-provided name of the certificate map.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMap] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.CreateCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L565}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
  CreateCertificateMap(
      std::string const& parent,
      google::cloud::certificatemanager::v1::CertificateMap const&
          certificate_map,
      std::string const& certificate_map_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateMap
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificateMap(
      NoAwaitTag, std::string const& parent,
      google::cloud::certificatemanager::v1::CertificateMap const&
          certificate_map,
      std::string const& certificate_map_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new CertificateMap in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.CreateCertificateMapRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMap] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.CreateCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L565}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
  CreateCertificateMap(
      google::cloud::certificatemanager::v1::CreateCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateMap
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificateMap(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::CreateCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateMap
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
  CreateCertificateMap(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Updates a CertificateMap.
  ///
  /// @param certificate_map  Required. A definition of the certificate map to update.
  /// @param update_mask  Required. The update mask applies to the resource. For the `FieldMask`
  ///  definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMap] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.UpdateCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L583}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
  UpdateCertificateMap(
      google::cloud::certificatemanager::v1::CertificateMap const&
          certificate_map,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificateMap
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCertificateMap(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::CertificateMap const&
          certificate_map,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a CertificateMap.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.UpdateCertificateMapRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMap] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMap]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1064}
  /// [google.cloud.certificatemanager.v1.UpdateCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L583}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
  UpdateCertificateMap(
      google::cloud::certificatemanager::v1::UpdateCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificateMap
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCertificateMap(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::UpdateCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificateMap
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMap>>
  UpdateCertificateMap(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Deletes a single CertificateMap. A Certificate Map can't be deleted
  /// if it contains Certificate Map Entries. Remove all the entries from
  /// the map before calling this method.
  ///
  /// @param name  Required. A name of the certificate map to delete. Must be in the format
  ///  `projects/*/locations/*/certificateMaps/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L595}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateMap(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateMap
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificateMap(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single CertificateMap. A Certificate Map can't be deleted
  /// if it contains Certificate Map Entries. Remove all the entries from
  /// the map before calling this method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.DeleteCertificateMapRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateMapRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L595}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateMap(
      google::cloud::certificatemanager::v1::DeleteCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateMap
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificateMap(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::DeleteCertificateMapRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateMap
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateMap(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Lists CertificateMapEntries in a given project and location.
  ///
  /// @param parent  Required. The project, location and certificate map from which the
  ///  certificate map entries should be listed, specified in the format
  ///  `projects/*/locations/*/certificateMaps/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.CertificateMapEntry], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L607}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::CertificateMapEntry>
  ListCertificateMapEntries(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists CertificateMapEntries in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.CertificateMapEntry], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L607}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::CertificateMapEntry>
  ListCertificateMapEntries(
      google::cloud::certificatemanager::v1::ListCertificateMapEntriesRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single CertificateMapEntry.
  ///
  /// @param name  Required. A name of the certificate map entry to describe. Must be in the
  ///  format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.CertificateMapEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L654}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>
  GetCertificateMapEntry(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single CertificateMapEntry.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.CertificateMapEntry])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L654}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>
  GetCertificateMapEntry(google::cloud::certificatemanager::v1::
                             GetCertificateMapEntryRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// Creates a new CertificateMapEntry in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the certificate map entry. Must be in the
  ///  format `projects/*/locations/*/certificateMaps/*`.
  /// @param certificate_map_entry  Required. A definition of the certificate map entry to create.
  /// @param certificate_map_entry_id  Required. A user-provided name of the certificate map entry.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMapEntry] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L666}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
  CreateCertificateMapEntry(
      std::string const& parent,
      google::cloud::certificatemanager::v1::CertificateMapEntry const&
          certificate_map_entry,
      std::string const& certificate_map_entry_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateMapEntry
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificateMapEntry(
      NoAwaitTag, std::string const& parent,
      google::cloud::certificatemanager::v1::CertificateMapEntry const&
          certificate_map_entry,
      std::string const& certificate_map_entry_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new CertificateMapEntry in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMapEntry] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L666}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
  CreateCertificateMapEntry(google::cloud::certificatemanager::v1::
                                CreateCertificateMapEntryRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateMapEntry
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificateMapEntry(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          CreateCertificateMapEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateMapEntry
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
  CreateCertificateMapEntry(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Updates a CertificateMapEntry.
  ///
  /// @param certificate_map_entry  Required. A definition of the certificate map entry to create map entry.
  /// @param update_mask  Required. The update mask applies to the resource. For the `FieldMask`
  ///  definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMapEntry] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L685}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
  UpdateCertificateMapEntry(
      google::cloud::certificatemanager::v1::CertificateMapEntry const&
          certificate_map_entry,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificateMapEntry
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCertificateMapEntry(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::CertificateMapEntry const&
          certificate_map_entry,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a CertificateMapEntry.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateMapEntry] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateMapEntry]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1127}
  /// [google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L685}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
  UpdateCertificateMapEntry(google::cloud::certificatemanager::v1::
                                UpdateCertificateMapEntryRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificateMapEntry
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateCertificateMapEntry(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          UpdateCertificateMapEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateCertificateMapEntry
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::CertificateMapEntry>>
  UpdateCertificateMapEntry(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Deletes a single CertificateMapEntry.
  ///
  /// @param name  Required. A name of the certificate map entry to delete. Must be in the
  ///  format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L698}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateMapEntry(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateMapEntry
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificateMapEntry(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single CertificateMapEntry.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L698}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateMapEntry(google::cloud::certificatemanager::v1::
                                DeleteCertificateMapEntryRequest const& request,
                            Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateMapEntry
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificateMapEntry(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          DeleteCertificateMapEntryRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateMapEntry
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateMapEntry(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Lists DnsAuthorizations in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the dns authorizations should
  ///  be listed, specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.DnsAuthorization], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  /// [google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L710}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::DnsAuthorization>
  ListDnsAuthorizations(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists DnsAuthorizations in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.DnsAuthorization], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  /// [google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L710}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::DnsAuthorization>
  ListDnsAuthorizations(
      google::cloud::certificatemanager::v1::ListDnsAuthorizationsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single DnsAuthorization.
  ///
  /// @param name  Required. A name of the dns authorization to describe. Must be in the
  ///  format `projects/*/locations/*/dnsAuthorizations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.DnsAuthorization])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  /// [google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L752}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>
  GetDnsAuthorization(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single DnsAuthorization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.DnsAuthorization])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  /// [google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L752}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>
  GetDnsAuthorization(
      google::cloud::certificatemanager::v1::GetDnsAuthorizationRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new DnsAuthorization in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the dns authorization. Must be in the
  ///  format `projects/*/locations/*`.
  /// @param dns_authorization  Required. A definition of the dns authorization to create.
  /// @param dns_authorization_id  Required. A user-provided name of the dns authorization.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.DnsAuthorization] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L764}
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
  CreateDnsAuthorization(
      std::string const& parent,
      google::cloud::certificatemanager::v1::DnsAuthorization const&
          dns_authorization,
      std::string const& dns_authorization_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDnsAuthorization
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDnsAuthorization(
      NoAwaitTag, std::string const& parent,
      google::cloud::certificatemanager::v1::DnsAuthorization const&
          dns_authorization,
      std::string const& dns_authorization_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new DnsAuthorization in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.DnsAuthorization] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L764}
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
  CreateDnsAuthorization(google::cloud::certificatemanager::v1::
                             CreateDnsAuthorizationRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDnsAuthorization
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateDnsAuthorization(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          CreateDnsAuthorizationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateDnsAuthorization
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
  CreateDnsAuthorization(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Updates a DnsAuthorization.
  ///
  /// @param dns_authorization  Required. A definition of the dns authorization to update.
  /// @param update_mask  Required. The update mask applies to the resource. For the `FieldMask`
  ///  definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.DnsAuthorization] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  /// [google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L783}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
  UpdateDnsAuthorization(
      google::cloud::certificatemanager::v1::DnsAuthorization const&
          dns_authorization,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDnsAuthorization
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateDnsAuthorization(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::DnsAuthorization const&
          dns_authorization,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a DnsAuthorization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.DnsAuthorization] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DnsAuthorization]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L1186}
  /// [google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L783}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
  UpdateDnsAuthorization(google::cloud::certificatemanager::v1::
                             UpdateDnsAuthorizationRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDnsAuthorization
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateDnsAuthorization(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          UpdateDnsAuthorizationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateDnsAuthorization
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::DnsAuthorization>>
  UpdateDnsAuthorization(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Deletes a single DnsAuthorization.
  ///
  /// @param name  Required. A name of the dns authorization to delete. Must be in the format
  ///  `projects/*/locations/*/dnsAuthorizations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L796}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteDnsAuthorization(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDnsAuthorization
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDnsAuthorization(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single DnsAuthorization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L796}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteDnsAuthorization(google::cloud::certificatemanager::v1::
                             DeleteDnsAuthorizationRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDnsAuthorization
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteDnsAuthorization(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          DeleteDnsAuthorizationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteDnsAuthorization
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteDnsAuthorization(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Lists CertificateIssuanceConfigs in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the certificate should be
  ///  listed, specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.CertificateIssuanceConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateIssuanceConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L124}
  /// [google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
  ListCertificateIssuanceConfigs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists CertificateIssuanceConfigs in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.CertificateIssuanceConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateIssuanceConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L124}
  /// [google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L37}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
  ListCertificateIssuanceConfigs(
      google::cloud::certificatemanager::v1::
          ListCertificateIssuanceConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single CertificateIssuanceConfig.
  ///
  /// @param name  Required. A name of the certificate issuance config to describe. Must be in
  ///  the format `projects/*/locations/*/certificateIssuanceConfigs/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.CertificateIssuanceConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateIssuanceConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L124}
  /// [google.cloud.certificatemanager.v1.GetCertificateIssuanceConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L80}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
  GetCertificateIssuanceConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single CertificateIssuanceConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.GetCertificateIssuanceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.CertificateIssuanceConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateIssuanceConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L124}
  /// [google.cloud.certificatemanager.v1.GetCertificateIssuanceConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L80}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::CertificateIssuanceConfig>
  GetCertificateIssuanceConfig(
      google::cloud::certificatemanager::v1::
          GetCertificateIssuanceConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new CertificateIssuanceConfig in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the certificate issuance config. Must be
  ///  in the format `projects/*/locations/*`.
  /// @param certificate_issuance_config  Required. A definition of the certificate issuance config to create.
  /// @param certificate_issuance_config_id  Required. A user-provided name of the certificate config.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateIssuanceConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateIssuanceConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L124}
  /// [google.cloud.certificatemanager.v1.CreateCertificateIssuanceConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L92}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>
  CreateCertificateIssuanceConfig(
      std::string const& parent,
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig const&
          certificate_issuance_config,
      std::string const& certificate_issuance_config_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateIssuanceConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificateIssuanceConfig(
      NoAwaitTag, std::string const& parent,
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig const&
          certificate_issuance_config,
      std::string const& certificate_issuance_config_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new CertificateIssuanceConfig in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.CreateCertificateIssuanceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.CertificateIssuanceConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CertificateIssuanceConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L124}
  /// [google.cloud.certificatemanager.v1.CreateCertificateIssuanceConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L92}
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>
  CreateCertificateIssuanceConfig(
      google::cloud::certificatemanager::v1::
          CreateCertificateIssuanceConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateIssuanceConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateCertificateIssuanceConfig(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          CreateCertificateIssuanceConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateCertificateIssuanceConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::cloud::certificatemanager::v1::CertificateIssuanceConfig>>
  CreateCertificateIssuanceConfig(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single CertificateIssuanceConfig.
  ///
  /// @param name  Required. A name of the certificate issuance config to delete. Must be in
  ///  the format `projects/*/locations/*/certificateIssuanceConfigs/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateIssuanceConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L112}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateIssuanceConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateIssuanceConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificateIssuanceConfig(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single CertificateIssuanceConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.DeleteCertificateIssuanceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteCertificateIssuanceConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_issuance_config.proto#L112}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateIssuanceConfig(
      google::cloud::certificatemanager::v1::
          DeleteCertificateIssuanceConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateIssuanceConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteCertificateIssuanceConfig(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::
          DeleteCertificateIssuanceConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteCertificateIssuanceConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteCertificateIssuanceConfig(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Lists TrustConfigs in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the TrustConfigs should be
  ///  listed, specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.TrustConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.ListTrustConfigsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L33}
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::TrustConfig>
  ListTrustConfigs(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TrustConfigs in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.ListTrustConfigsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.certificatemanager.v1.TrustConfig], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.ListTrustConfigsRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L33}
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  ///
  // clang-format on
  StreamRange<google::cloud::certificatemanager::v1::TrustConfig>
  ListTrustConfigs(
      google::cloud::certificatemanager::v1::ListTrustConfigsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single TrustConfig.
  ///
  /// @param name  Required. A name of the TrustConfig to describe. Must be in the format
  ///  `projects/*/locations/*/trustConfigs/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.TrustConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.GetTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L75}
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::TrustConfig> GetTrustConfig(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single TrustConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.GetTrustConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.certificatemanager.v1.TrustConfig])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.GetTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L75}
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  ///
  // clang-format on
  StatusOr<google::cloud::certificatemanager::v1::TrustConfig> GetTrustConfig(
      google::cloud::certificatemanager::v1::GetTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new TrustConfig in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the TrustConfig. Must be in the format
  ///  `projects/*/locations/*`.
  /// @param trust_config  Required. A definition of the TrustConfig to create.
  /// @param trust_config_id  Required. A user-provided name of the TrustConfig. Must match the regexp
  ///  `[a-z0-9-]{1,63}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.TrustConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CreateTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L87}
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
  CreateTrustConfig(
      std::string const& parent,
      google::cloud::certificatemanager::v1::TrustConfig const& trust_config,
      std::string const& trust_config_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTrustConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTrustConfig(
      NoAwaitTag, std::string const& parent,
      google::cloud::certificatemanager::v1::TrustConfig const& trust_config,
      std::string const& trust_config_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new TrustConfig in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.CreateTrustConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.TrustConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.CreateTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L87}
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
  CreateTrustConfig(
      google::cloud::certificatemanager::v1::CreateTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTrustConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTrustConfig(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::CreateTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTrustConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
  CreateTrustConfig(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Updates a TrustConfig.
  ///
  /// @param trust_config  Required. A definition of the TrustConfig to update.
  /// @param update_mask  Required. The update mask applies to the resource. For the `FieldMask`
  ///  definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.TrustConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  /// [google.cloud.certificatemanager.v1.UpdateTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L106}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
  UpdateTrustConfig(
      google::cloud::certificatemanager::v1::TrustConfig const& trust_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTrustConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTrustConfig(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::TrustConfig const& trust_config,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a TrustConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.UpdateTrustConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.TrustConfig] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.TrustConfig]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L135}
  /// [google.cloud.certificatemanager.v1.UpdateTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L106}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
  UpdateTrustConfig(
      google::cloud::certificatemanager::v1::UpdateTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTrustConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTrustConfig(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::UpdateTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTrustConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::TrustConfig>>
  UpdateTrustConfig(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Deletes a single TrustConfig.
  ///
  /// @param name  Required. A name of the TrustConfig to delete. Must be in the format
  ///  `projects/*/locations/*/trustConfigs/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L118}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteTrustConfig(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTrustConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTrustConfig(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single TrustConfig.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.certificatemanager.v1.DeleteTrustConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.certificatemanager.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.certificatemanager.v1.DeleteTrustConfigRequest]: @googleapis_reference_link{google/cloud/certificatemanager/v1/trust_config.proto#L118}
  /// [google.cloud.certificatemanager.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/certificatemanager/v1/certificate_manager.proto#L808}
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteTrustConfig(
      google::cloud::certificatemanager::v1::DeleteTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTrustConfig
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTrustConfig(
      NoAwaitTag,
      google::cloud::certificatemanager::v1::DeleteTrustConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTrustConfig
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::certificatemanager::v1::OperationMetadata>>
  DeleteTrustConfig(google::longrunning::Operation const& operation,
                    Options opts = {});

 private:
  std::shared_ptr<CertificateManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace certificatemanager_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CERTIFICATEMANAGER_V1_CERTIFICATE_MANAGER_CLIENT_H
