// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto

#include "google/cloud/bigquery/storage/v1/internal/bigquery_read_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_storage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BigQueryReadTracingConnection::BigQueryReadTracingConnection(
    std::shared_ptr<bigquery_storage_v1::BigQueryReadConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::storage::v1::ReadSession>
BigQueryReadTracingConnection::CreateReadSession(
    google::cloud::bigquery::storage::v1::CreateReadSessionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryReadConnection::CreateReadSession");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateReadSession(request));
}

StreamRange<google::cloud::bigquery::storage::v1::ReadRowsResponse>
BigQueryReadTracingConnection::ReadRows(
    google::cloud::bigquery::storage::v1::ReadRowsRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryReadConnection::ReadRows");
  internal::OTelScope scope(span);
  auto sr = child_->ReadRows(request);
  return internal::MakeTracedStreamRange<
      google::cloud::bigquery::storage::v1::ReadRowsResponse>(std::move(span),
                                                              std::move(sr));
}
StatusOr<google::cloud::bigquery::storage::v1::SplitReadStreamResponse>
BigQueryReadTracingConnection::SplitReadStream(
    google::cloud::bigquery::storage::v1::SplitReadStreamRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryReadConnection::SplitReadStream");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SplitReadStream(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquery_storage_v1::BigQueryReadConnection>
MakeBigQueryReadTracingConnection(
    std::shared_ptr<bigquery_storage_v1::BigQueryReadConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<BigQueryReadTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_storage_v1_internal
}  // namespace cloud
}  // namespace google
