// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/batch/v1/batch.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BATCH_V1_INTERNAL_BATCH_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BATCH_V1_INTERNAL_BATCH_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/batch/v1/batch.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace batch_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BatchServiceStub {
 public:
  virtual ~BatchServiceStub() = 0;

  virtual StatusOr<google::cloud::batch::v1::Job> CreateJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::CreateJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::batch::v1::Job> GetJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::GetJobRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::batch::v1::DeleteJobRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteJob(
      grpc::ClientContext& context, Options options,
      google::cloud::batch::v1::DeleteJobRequest const& request) = 0;

  virtual StatusOr<google::cloud::batch::v1::ListJobsResponse> ListJobs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::ListJobsRequest const& request) = 0;

  virtual StatusOr<google::cloud::batch::v1::Task> GetTask(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::GetTaskRequest const& request) = 0;

  virtual StatusOr<google::cloud::batch::v1::ListTasksResponse> ListTasks(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::ListTasksRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultBatchServiceStub : public BatchServiceStub {
 public:
  DefaultBatchServiceStub(
      std::unique_ptr<google::cloud::batch::v1::BatchService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::batch::v1::Job> CreateJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::CreateJobRequest const& request) override;

  StatusOr<google::cloud::batch::v1::Job> GetJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::GetJobRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::batch::v1::DeleteJobRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteJob(
      grpc::ClientContext& context, Options options,
      google::cloud::batch::v1::DeleteJobRequest const& request) override;

  StatusOr<google::cloud::batch::v1::ListJobsResponse> ListJobs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::ListJobsRequest const& request) override;

  StatusOr<google::cloud::batch::v1::Task> GetTask(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::GetTaskRequest const& request) override;

  StatusOr<google::cloud::batch::v1::ListTasksResponse> ListTasks(
      grpc::ClientContext& context, Options const& options,
      google::cloud::batch::v1::ListTasksRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::batch::v1::BatchService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace batch_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BATCH_V1_INTERNAL_BATCH_STUB_H
