// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/apikeys/v2/apikeys.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_API_KEYS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_API_KEYS_CONNECTION_H

#include "google/cloud/apikeys/v2/api_keys_connection_idempotency_policy.h"
#include "google/cloud/apikeys/v2/internal/api_keys_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/api/apikeys/v2/apikeys.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace apikeys_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ApiKeysConnection`.
class ApiKeysRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ApiKeysRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ApiKeysConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ApiKeysLimitedErrorCountRetryPolicy : public ApiKeysRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ApiKeysLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ApiKeysLimitedErrorCountRetryPolicy(
      ApiKeysLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ApiKeysLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ApiKeysLimitedErrorCountRetryPolicy(
      ApiKeysLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ApiKeysLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ApiKeysRetryPolicy> clone() const override {
    return std::make_unique<ApiKeysLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ApiKeysRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      apikeys_v2_internal::ApiKeysRetryTraits>
      impl_;
};

/**
 * A retry policy for `ApiKeysConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ApiKeysLimitedTimeRetryPolicy : public ApiKeysRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ApiKeysLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ApiKeysLimitedTimeRetryPolicy(ApiKeysLimitedTimeRetryPolicy&& rhs) noexcept
      : ApiKeysLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ApiKeysLimitedTimeRetryPolicy(
      ApiKeysLimitedTimeRetryPolicy const& rhs) noexcept
      : ApiKeysLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ApiKeysRetryPolicy> clone() const override {
    return std::make_unique<ApiKeysLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ApiKeysRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      apikeys_v2_internal::ApiKeysRetryTraits>
      impl_;
};

/**
 * The `ApiKeysConnection` object for `ApiKeysClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ApiKeysClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ApiKeysClient`.
 *
 * To create a concrete instance, see `MakeApiKeysConnection()`.
 *
 * For mocking, see `apikeys_v2_mocks::MockApiKeysConnection`.
 */
class ApiKeysConnection {
 public:
  virtual ~ApiKeysConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::api::apikeys::v2::Key>> CreateKey(
      google::api::apikeys::v2::CreateKeyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateKey(
      NoAwaitTag, google::api::apikeys::v2::CreateKeyRequest const& request);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> CreateKey(
      google::longrunning::Operation const& operation);

  virtual StreamRange<google::api::apikeys::v2::Key> ListKeys(
      google::api::apikeys::v2::ListKeysRequest request);

  virtual StatusOr<google::api::apikeys::v2::Key> GetKey(
      google::api::apikeys::v2::GetKeyRequest const& request);

  virtual StatusOr<google::api::apikeys::v2::GetKeyStringResponse> GetKeyString(
      google::api::apikeys::v2::GetKeyStringRequest const& request);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> UpdateKey(
      google::api::apikeys::v2::UpdateKeyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateKey(
      NoAwaitTag, google::api::apikeys::v2::UpdateKeyRequest const& request);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> UpdateKey(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> DeleteKey(
      google::api::apikeys::v2::DeleteKeyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteKey(
      NoAwaitTag, google::api::apikeys::v2::DeleteKeyRequest const& request);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> DeleteKey(
      google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> UndeleteKey(
      google::api::apikeys::v2::UndeleteKeyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UndeleteKey(
      NoAwaitTag, google::api::apikeys::v2::UndeleteKeyRequest const& request);

  virtual future<StatusOr<google::api::apikeys::v2::Key>> UndeleteKey(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::api::apikeys::v2::LookupKeyResponse> LookupKey(
      google::api::apikeys::v2::LookupKeyRequest const& request);
};

/**
 * A factory function to construct an object of type `ApiKeysConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of ApiKeysClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ApiKeysConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::apikeys_v2::ApiKeysPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ApiKeysConnection` created by
 * this function.
 */
std::shared_ptr<ApiKeysConnection> MakeApiKeysConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apikeys_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_API_KEYS_CONNECTION_H
