// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPErrorRuleBackendOKCode is the HTTP code returned for type GetHTTPErrorRuleBackendOK
const GetHTTPErrorRuleBackendOKCode int = 200

/*
GetHTTPErrorRuleBackendOK Successful operation

swagger:response getHttpErrorRuleBackendOK
*/
type GetHTTPErrorRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewGetHTTPErrorRuleBackendOK creates GetHTTPErrorRuleBackendOK with default headers values
func NewGetHTTPErrorRuleBackendOK() *GetHTTPErrorRuleBackendOK {

	return &GetHTTPErrorRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http error rule backend o k response
func (o *GetHTTPErrorRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http error rule backend o k response
func (o *GetHTTPErrorRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http error rule backend o k response
func (o *GetHTTPErrorRuleBackendOK) WithPayload(payload *models.HTTPErrorRule) *GetHTTPErrorRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http error rule backend o k response
func (o *GetHTTPErrorRuleBackendOK) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPErrorRuleBackendNotFoundCode is the HTTP code returned for type GetHTTPErrorRuleBackendNotFound
const GetHTTPErrorRuleBackendNotFoundCode int = 404

/*
GetHTTPErrorRuleBackendNotFound The specified resource was not found

swagger:response getHttpErrorRuleBackendNotFound
*/
type GetHTTPErrorRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPErrorRuleBackendNotFound creates GetHTTPErrorRuleBackendNotFound with default headers values
func NewGetHTTPErrorRuleBackendNotFound() *GetHTTPErrorRuleBackendNotFound {

	return &GetHTTPErrorRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http error rule backend not found response
func (o *GetHTTPErrorRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http error rule backend not found response
func (o *GetHTTPErrorRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http error rule backend not found response
func (o *GetHTTPErrorRuleBackendNotFound) WithPayload(payload *models.Error) *GetHTTPErrorRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http error rule backend not found response
func (o *GetHTTPErrorRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPErrorRuleBackendDefault General Error

swagger:response getHttpErrorRuleBackendDefault
*/
type GetHTTPErrorRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPErrorRuleBackendDefault creates GetHTTPErrorRuleBackendDefault with default headers values
func NewGetHTTPErrorRuleBackendDefault(code int) *GetHTTPErrorRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPErrorRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP error rule backend default response
func (o *GetHTTPErrorRuleBackendDefault) WithStatusCode(code int) *GetHTTPErrorRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP error rule backend default response
func (o *GetHTTPErrorRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP error rule backend default response
func (o *GetHTTPErrorRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPErrorRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP error rule backend default response
func (o *GetHTTPErrorRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP error rule backend default response
func (o *GetHTTPErrorRuleBackendDefault) WithPayload(payload *models.Error) *GetHTTPErrorRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP error rule backend default response
func (o *GetHTTPErrorRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPErrorRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
