// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPCheckDefaultsCreatedCode is the HTTP code returned for type CreateHTTPCheckDefaultsCreated
const CreateHTTPCheckDefaultsCreatedCode int = 201

/*
CreateHTTPCheckDefaultsCreated HTTP check created

swagger:response createHttpCheckDefaultsCreated
*/
type CreateHTTPCheckDefaultsCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewCreateHTTPCheckDefaultsCreated creates CreateHTTPCheckDefaultsCreated with default headers values
func NewCreateHTTPCheckDefaultsCreated() *CreateHTTPCheckDefaultsCreated {

	return &CreateHTTPCheckDefaultsCreated{}
}

// WithPayload adds the payload to the create Http check defaults created response
func (o *CreateHTTPCheckDefaultsCreated) WithPayload(payload *models.HTTPCheck) *CreateHTTPCheckDefaultsCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check defaults created response
func (o *CreateHTTPCheckDefaultsCreated) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckDefaultsCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPCheckDefaultsAcceptedCode is the HTTP code returned for type CreateHTTPCheckDefaultsAccepted
const CreateHTTPCheckDefaultsAcceptedCode int = 202

/*
CreateHTTPCheckDefaultsAccepted Configuration change accepted and reload requested

swagger:response createHttpCheckDefaultsAccepted
*/
type CreateHTTPCheckDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewCreateHTTPCheckDefaultsAccepted creates CreateHTTPCheckDefaultsAccepted with default headers values
func NewCreateHTTPCheckDefaultsAccepted() *CreateHTTPCheckDefaultsAccepted {

	return &CreateHTTPCheckDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the create Http check defaults accepted response
func (o *CreateHTTPCheckDefaultsAccepted) WithReloadID(reloadID string) *CreateHTTPCheckDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http check defaults accepted response
func (o *CreateHTTPCheckDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http check defaults accepted response
func (o *CreateHTTPCheckDefaultsAccepted) WithPayload(payload *models.HTTPCheck) *CreateHTTPCheckDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check defaults accepted response
func (o *CreateHTTPCheckDefaultsAccepted) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPCheckDefaultsBadRequestCode is the HTTP code returned for type CreateHTTPCheckDefaultsBadRequest
const CreateHTTPCheckDefaultsBadRequestCode int = 400

/*
CreateHTTPCheckDefaultsBadRequest Bad request

swagger:response createHttpCheckDefaultsBadRequest
*/
type CreateHTTPCheckDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPCheckDefaultsBadRequest creates CreateHTTPCheckDefaultsBadRequest with default headers values
func NewCreateHTTPCheckDefaultsBadRequest() *CreateHTTPCheckDefaultsBadRequest {

	return &CreateHTTPCheckDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http check defaults bad request response
func (o *CreateHTTPCheckDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPCheckDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http check defaults bad request response
func (o *CreateHTTPCheckDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http check defaults bad request response
func (o *CreateHTTPCheckDefaultsBadRequest) WithPayload(payload *models.Error) *CreateHTTPCheckDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check defaults bad request response
func (o *CreateHTTPCheckDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPCheckDefaultsConflictCode is the HTTP code returned for type CreateHTTPCheckDefaultsConflict
const CreateHTTPCheckDefaultsConflictCode int = 409

/*
CreateHTTPCheckDefaultsConflict The specified resource already exists

swagger:response createHttpCheckDefaultsConflict
*/
type CreateHTTPCheckDefaultsConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPCheckDefaultsConflict creates CreateHTTPCheckDefaultsConflict with default headers values
func NewCreateHTTPCheckDefaultsConflict() *CreateHTTPCheckDefaultsConflict {

	return &CreateHTTPCheckDefaultsConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http check defaults conflict response
func (o *CreateHTTPCheckDefaultsConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPCheckDefaultsConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http check defaults conflict response
func (o *CreateHTTPCheckDefaultsConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http check defaults conflict response
func (o *CreateHTTPCheckDefaultsConflict) WithPayload(payload *models.Error) *CreateHTTPCheckDefaultsConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http check defaults conflict response
func (o *CreateHTTPCheckDefaultsConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckDefaultsConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPCheckDefaultsDefault General Error

swagger:response createHttpCheckDefaultsDefault
*/
type CreateHTTPCheckDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPCheckDefaultsDefault creates CreateHTTPCheckDefaultsDefault with default headers values
func NewCreateHTTPCheckDefaultsDefault(code int) *CreateHTTPCheckDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPCheckDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP check defaults default response
func (o *CreateHTTPCheckDefaultsDefault) WithStatusCode(code int) *CreateHTTPCheckDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP check defaults default response
func (o *CreateHTTPCheckDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP check defaults default response
func (o *CreateHTTPCheckDefaultsDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPCheckDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP check defaults default response
func (o *CreateHTTPCheckDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP check defaults default response
func (o *CreateHTTPCheckDefaultsDefault) WithPayload(payload *models.Error) *CreateHTTPCheckDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP check defaults default response
func (o *CreateHTTPCheckDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPCheckDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
