/*
eXdupe Archiver, copyright 2010 - 2012 by eXdupe.com. All rights reserved.

eXdupe is traditional proprietary software, with parts of the source code being available under 
restricted non-permissive terms:

You may modify and compile eXdupe, and we encourage you to submit bugfixes or new features to 
us. However, redistribution of original or modified source code or binaries, or any derived 
work, is probitted.

EXDUPE IS NOT FREE. Use of original or modified eXdupe or any derived work requires you to
purchase a license (see http://www.exdupe.com/). 

eXdupe contains 3'rd party source code files that carry their own original preamble terms and are not 
covered by above terms.
*/

#ifndef DEDUPE_HEADER
#define DEDUPE_HEADER

#define DUP_BLOCK 'D'

#include <string.h>
#include <stdint.h>

uint64_t dup_memory(uint64_t bits);
int dup_init (size_t large_block, size_t small_block, uint64_t memory_usage, int max_threadcount, void *memory, int compression_level);

size_t dup_compress(const void *src, unsigned char *dst, size_t size, bool flush);
int dup_decompress(const unsigned char *src, unsigned char *dst, size_t *length, uint64_t *payload);
int dup_decompress_simulate(const unsigned char *src, size_t *length, uint64_t *payload);
bool dup_busy(void);

size_t dup_size_compressed(const unsigned char *src);
size_t dup_size_decompressed(const unsigned char *src);

void dup_counters_reset(void);
uint64_t dup_counter_payload(void);
uint64_t dup_counter_compressed(void);

void dup_add(bool add);
size_t dup_table_condense(void);
int dup_table_expand(size_t len);
void dup_deinit(void);

void reset_profiling(void);
void print_profiling(void);

#endif

