/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#include "infodialog.h"
#include "common.h"
#include <QDesktopWidget>
#include <QTime>

InfoDialog::InfoDialog(QWidget *parent):
    QDialog(parent)
{
    setupUi(this);
    setWindowFlags(Qt::FramelessWindowHint |
                   Qt::SplashScreen |
                   Qt::WindowStaysOnTopHint);
}

InfoDialog::~InfoDialog()
{
}

void InfoDialog::show()
{
    // move the window to the bottom-left corner
    QDesktopWidget *desktop = QApplication::desktop();
    QRect rect = desktop->availableGeometry(this);
    move(rect.right() - width(), rect.bottom() - height());

    QDialog::show();
}

void InfoDialog::setPercentage(int perc)
{
    m_bar_percentage->setValue(perc);
    m_lbl_percentage->setText(QString("%1 %").arg(perc));
}

void InfoDialog::setCapacity(unsigned long act, unsigned long max)
{
#if (defined(Q_OS_WIN32))
    m_lbl_capacity->setText(QString("%1 mWh of %2 mWh").arg(act).arg(max));
#elif (defined(Q_OS_LINUX))
    m_lbl_capacity->setText(QString("%1 mAh of %2 mAh").arg(act).arg(max));
#endif
}

void InfoDialog::setRate(long rate)
{
#if (defined(Q_OS_WIN32))
    m_lbl_rate->setText(QString("%1 mW").arg(qAbs(rate)));
#elif (defined(Q_OS_LINUX))
    m_lbl_rate->setText(QString("%1 mA").arg(rate));
#endif
}

void InfoDialog::setBatteryState(BatteryMeter::charge_t state)
{
    switch (state)
    {
    case BatteryMeter::CHARGED:
        m_lbl_battery->setText("Charged");
        break;

    case BatteryMeter::CHARGING:
        m_lbl_battery->setText("Charging");
        break;

    case BatteryMeter::DISCHARGING:
        m_lbl_battery->setText("Discharging");
        break;

    case BatteryMeter::UNKNOWN:
        m_lbl_battery->setText("Unkown state");
        break;
    }
}

void InfoDialog::setAcState(bool online)
{
    m_lbl_ac->setText(online ? "Connected" : "Disconnected");
}

void InfoDialog::setTimeRemaining(unsigned long min)
{
    QTime t(min / 60, min % 60);
    if (t.minute() == 0 && t.second() == 0)
    {
        m_lbl_remain_time->hide();
        m_lbl_remain_time_info->hide();
        return;
    }

    // prepare string for time information
    QString str;
    if (t.hour() == 1)
        str = "1 hour, ";
    else
        str = QString("%1 hours, ").arg(t.hour());

    if (t.minute() == 1)
        str += "1 minute";
    else
        str += QString("%1 minutes").arg(t.minute());

    m_lbl_remain_time->setText(str);
    m_lbl_remain_time->show();
    m_lbl_remain_time_info->show();
}

void InfoDialog::mousePressEvent(QMouseEvent *ev)
{
    Q_UNUSED(ev);
    hide();
}
