/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.internal.core.utils.ui.IActionSingleton;

public class MenuIntersector {
    private List<IMenuElement> m_elements;

    public static void merge(IMenuManager mainMenu, List<IMenuManager> menus) {
        MenuIntersector intersector = new MenuIntersector();
        for (IMenuManager menu : menus) {
            intersector.merge(menu);
        }
        intersector.addToMenu(mainMenu);
    }

    public void merge(IMenuManager menu) {
        IContributionItem[] items = menu.getItems();
        if (this.m_elements == null) {
            this.m_elements = Lists.newArrayList();
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (SeparatorElement.accept(item)) {
                    this.m_elements.add(new SeparatorElement(item));
                } else if (MenuElement.accept(item)) {
                    this.m_elements.add(new MenuElement(item));
                } else if (MenuItemElement.accept(item)) {
                    this.m_elements.add(new MenuItemElement(item));
                }
                ++n2;
            }
        } else {
            Iterator<IMenuElement> I = this.m_elements.iterator();
            while (I.hasNext()) {
                IMenuElement element = I.next();
                if (element.incorporate(menu)) continue;
                I.remove();
            }
        }
    }

    public void addToMenu(IMenuManager menu) {
        for (IMenuElement element : this.m_elements) {
            element.addToMenu(menu);
        }
    }

    private static abstract class AbstractMenuElement
    implements IMenuElement {
        private AbstractMenuElement() {
        }

        @Override
        public final boolean incorporate(IMenuManager menu) {
            IContributionItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (!SeparatorElement.accept(item) && this.incorporate(item)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected abstract boolean incorporate(IContributionItem var1);
    }

    private static interface IMenuElement {
        public boolean incorporate(IMenuManager var1);

        public void addToMenu(IMenuManager var1);
    }

    private static class MenuElement
    extends AbstractMenuElement {
        private final MenuIntersector m_intersector = new MenuIntersector();
        private String m_menuTitle;

        public MenuElement(IContributionItem item) {
            this.incorporate(item);
        }

        @Override
        protected boolean incorporate(IContributionItem item) {
            if (MenuElement.accept(item)) {
                MenuManager menu = (MenuManager)item;
                if (this.m_menuTitle == null) {
                    this.m_menuTitle = menu.getMenuText();
                    this.m_intersector.merge((IMenuManager)menu);
                    return true;
                }
                if (this.m_menuTitle.equals(menu.getMenuText())) {
                    this.m_intersector.merge((IMenuManager)menu);
                    return true;
                }
            }
            return false;
        }

        public static boolean accept(IContributionItem item) {
            return item instanceof MenuManager;
        }

        @Override
        public void addToMenu(IMenuManager menu) {
            MenuManager subMenu = new MenuManager(this.m_menuTitle);
            this.m_intersector.addToMenu((IMenuManager)subMenu);
            if (!subMenu.isEmpty()) {
                menu.add((IContributionItem)subMenu);
            }
        }
    }

    private static class MenuItemElement
    extends AbstractMenuElement {
        private final Collection<IAction> m_actions = Sets.newHashSet();

        public MenuItemElement(IContributionItem item) {
            this.incorporate(item);
        }

        @Override
        protected boolean incorporate(IContributionItem item) {
            if (MenuItemElement.accept(item)) {
                ActionContributionItem actionItem = (ActionContributionItem)item;
                IAction action = actionItem.getAction();
                if (this.m_actions.isEmpty()) {
                    this.m_actions.add(action);
                    return true;
                }
                IAction original = this.getAction();
                if (!action.getText().equals(original.getText())) {
                    return false;
                }
                if (action.getStyle() != original.getStyle()) {
                    return false;
                }
                if (!(action instanceof IActionSingleton)) {
                    this.m_actions.add(action);
                }
                return true;
            }
            return false;
        }

        private IAction getAction() {
            return this.m_actions.iterator().next();
        }

        public static boolean accept(IContributionItem item) {
            return item instanceof ActionContributionItem;
        }

        @Override
        public void addToMenu(IMenuManager menu) {
            IAction original = this.getAction();
            Action action = new Action(original.getText(), original.getStyle()){

                public void runWithEvent(Event event) {
                    this.updateChecked();
                    for (IAction innerAction : m_actions) {
                        innerAction.runWithEvent(event);
                    }
                }

                public void run() {
                    this.updateChecked();
                    for (IAction innerAction : m_actions) {
                        innerAction.run();
                    }
                }

                private void updateChecked() {
                    for (IAction innerAction : m_actions) {
                        innerAction.setChecked(this.isChecked());
                    }
                }
            };
            boolean checked = true;
            for (IAction innerAction : this.m_actions) {
                checked &= innerAction.isChecked();
            }
            action.setChecked(checked);
            action.setImageDescriptor(original.getImageDescriptor());
            action.setHoverImageDescriptor(original.getHoverImageDescriptor());
            action.setDisabledImageDescriptor(original.getDisabledImageDescriptor());
            action.setEnabled(original.isEnabled());
            menu.add((IAction)action);
        }
    }

    private static class SeparatorElement
    implements IMenuElement {
        private final IContributionItem m_item;

        public SeparatorElement(IContributionItem item) {
            this.m_item = item;
        }

        @Override
        public boolean incorporate(IMenuManager menu) {
            return true;
        }

        @Override
        public void addToMenu(IMenuManager menu) {
            menu.add(this.m_item);
        }

        public static boolean accept(IContributionItem item) {
            return item.isSeparator() || item.isGroupMarker();
        }
    }
}

