/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.core.model.association.UnknownAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterChildren;
import org.eclipse.wb.internal.core.model.order.MethodOrderAfterParentChildren;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ThisVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

public final class ChildTargetCalculator {
    private final JavaInfo m_parent;
    private final JavaInfo m_child;
    private final JavaInfo m_nextChild;
    private VariableSupport m_parentVariable;

    public ChildTargetCalculator(JavaInfo parent, JavaInfo child, JavaInfo nextChild) {
        this.m_parent = parent;
        this.m_child = child;
        this.m_nextChild = nextChild;
    }

    public StatementTarget getTarget() throws Exception {
        StatementTarget target = this.getTarget_Lazy_ImplicitFactory();
        if (target != null) {
            return target;
        }
        if (this.m_nextChild != null) {
            Statement associationStatement = this.m_nextChild.getAssociation().getStatement();
            Statement targetStatement = this.trackRelatedStatementsUp(this.m_nextChild, associationStatement);
            return new StatementTarget(targetStatement, true);
        }
        target = ThisVariableSupport.getForcedTarget(this.m_parent);
        if (target != null) {
            return target;
        }
        JavaInfoUtils.materializeVariable(this.m_parent);
        this.m_parentVariable = this.m_parent.getVariableSupport();
        Statement targetStatement = this.getLastTargetStatement();
        if (targetStatement != null) {
            targetStatement = this.trackTargetStatementsDown(targetStatement);
            return new StatementTarget(targetStatement, false);
        }
        return this.m_parentVariable.getChildTarget();
    }

    private StatementTarget getTarget_Lazy_ImplicitFactory() {
        if (this.m_nextChild != null && this.m_nextChild.getAssociation() instanceof InvocationVoidAssociation && this.m_nextChild.getVariableSupport() instanceof LazyVariableSupport) {
            LazyVariableSupport lazy = (LazyVariableSupport)this.m_nextChild.getVariableSupport();
            List<ASTNode> invocations = ExecutionFlowUtils.getInvocations(JavaInfoUtils.getState(this.m_parent).getFlowDescription(), lazy.m_accessor);
            if (!invocations.isEmpty()) {
                ASTNode targetInvocation = invocations.get(0);
                Statement targetStatement = AstNodeUtils.getEnclosingStatement(targetInvocation);
                return new StatementTarget(targetStatement, true);
            }
        }
        return null;
    }

    private Statement trackRelatedStatementsUp(JavaInfo javaInfo, Statement targetStatement) throws Exception {
        Block targetBlock = (Block)targetStatement.getParent();
        List<Statement> statements = DomGenerics.statements(targetBlock);
        int index = statements.indexOf(targetStatement);
        while (index-- != 0) {
            Statement newTargetStatement = statements.get(index);
            if (!this.isRelatedStatement(javaInfo, newTargetStatement)) {
                return targetStatement;
            }
            targetStatement = newTargetStatement;
        }
        if (targetBlock.getParent() instanceof Block) {
            return this.trackRelatedStatementsUp(javaInfo, (Statement)targetBlock);
        }
        return targetStatement;
    }

    private Statement trackTargetStatementsDown(Statement targetStatement) throws Exception {
        boolean isLastStatement;
        Block targetBlock = (Block)targetStatement.getParent();
        List<Statement> statements = DomGenerics.statements(targetBlock);
        boolean bl = isLastStatement = statements.get(statements.size() - 1) == targetStatement;
        if (isLastStatement && targetBlock.getParent() instanceof Block) {
            if (!this.m_parentVariable.isValidStatementForChild((Statement)targetBlock)) {
                return targetStatement;
            }
            return this.trackTargetStatementsDown((Statement)targetBlock);
        }
        return targetStatement;
    }

    private Statement getLastTargetStatement() throws Exception {
        final Statement[] lastStatement = new Statement[1];
        ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(this.m_parent).getFlowDescription();
        ExecutionFlowUtils.visit(new ExecutionFlowUtils.VisitingContext(true), flowDescription, new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){
            private final LinkedList<TargetMethodInformation> m_methodsStack = Lists.newLinkedList();
            private boolean m_anyChildFound = false;
            private boolean m_terminalFound = false;

            public void postVisit(ASTNode node) {
                if (node instanceof Statement) {
                    Statement statement = (Statement)node;
                    this.postVisit(statement);
                }
            }

            private void postVisit(Statement statement) {
                if (this.m_terminalFound) {
                    return;
                }
                this.m_terminalFound = ChildTargetCalculator.this.isTerminalStatement(statement);
                if (this.m_terminalFound) {
                    return;
                }
                if (ChildTargetCalculator.this.isParentCreation(statement) || ChildTargetCalculator.this.isAssociationForSomeChild(statement)) {
                    this.m_anyChildFound = true;
                    this.m_methodsStack.getFirst().interesting = true;
                }
                if (ChildTargetCalculator.this.m_parentVariable.isValidStatementForChild(statement) && ChildTargetCalculator.this.isTargetStatement(statement)) {
                    lastStatement[0] = statement;
                }
            }

            @Override
            public boolean enterFrame(ASTNode node) {
                if (node instanceof MethodDeclaration) {
                    TargetMethodInformation methodInformation = new TargetMethodInformation();
                    methodInformation.lastStatement = lastStatement[0];
                    this.m_methodsStack.addFirst(methodInformation);
                }
                return true;
            }

            @Override
            public void leaveFrame(ASTNode node) {
                if (node instanceof MethodDeclaration) {
                    TargetMethodInformation methodInformation = this.m_methodsStack.removeFirst();
                    if (this.m_anyChildFound && !methodInformation.interesting) {
                        lastStatement[0] = methodInformation.lastStatement;
                    }
                    if (!this.m_methodsStack.isEmpty()) {
                        this.m_methodsStack.getFirst().interesting |= methodInformation.interesting;
                    }
                }
            }
        });
        return lastStatement[0];
    }

    private boolean isParentCreation(Statement statement) {
        CreationSupport parentCreation = this.m_parent.getCreationSupport();
        ASTNode parentNode = parentCreation.getNode();
        if (parentCreation instanceof ThisCreationSupport) {
            return AstNodeUtils.contains(parentNode, (ASTNode)statement);
        }
        return statement == AstNodeUtils.getEnclosingStatement(parentNode);
    }

    private boolean isAssociationForSomeChild(Statement statement) {
        for (JavaInfo child : this.m_parent.getChildrenJava()) {
            Association association = child.getAssociation();
            if (association == null || child.getCreationSupport() instanceof IImplicitCreationSupport || association.getStatement() != statement) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetStatement(Statement statement) {
        JavaInfo javaInfo = this.m_parent;
        while (javaInfo != null) {
            MethodOrder methodOrder = this.getMethodOrder(javaInfo, statement);
            if (methodOrder != null && !methodOrder.canReference(javaInfo)) {
                return false;
            }
            if (!(javaInfo.getParent() instanceof JavaInfo)) break;
            javaInfo = (JavaInfo)javaInfo.getParent();
        }
        return this.isRelatedStatement(this.m_parent, statement);
    }

    private boolean isTerminalStatement(Statement statement) {
        boolean[] terminal = new boolean[1];
        if (this.m_child != null) {
            MethodOrder methodOrder = this.getMethodOrder(this.m_parent, statement);
            if (methodOrder instanceof MethodOrderAfterChildren && ((MethodOrderAfterChildren)methodOrder).isTargetChild(this.m_child)) {
                terminal[0] = true;
            }
            if (this.m_parent != null) {
                for (JavaInfo parentChildInfo : this.m_parent.getChildrenJava()) {
                    MethodOrder methodOrder2 = this.getMethodOrder(parentChildInfo, statement);
                    if (!(methodOrder2 instanceof MethodOrderAfterParentChildren) || !((MethodOrderAfterParentChildren)methodOrder2).isTargetChild(this.m_child)) continue;
                    terminal[0] = true;
                }
            }
        }
        this.m_parent.getBroadcastJava().target_isTerminalStatement(this.m_parent, this.m_child, statement, terminal);
        return terminal[0];
    }

    private MethodInvocation getMethodInvocation(JavaInfo javaInfo, Statement statement) {
        MethodInvocation invocation;
        ExpressionStatement expressionStatement;
        if (statement instanceof ExpressionStatement && (expressionStatement = (ExpressionStatement)statement).getExpression() instanceof MethodInvocation && javaInfo.isRepresentedBy((ASTNode)(invocation = (MethodInvocation)expressionStatement.getExpression()).getExpression())) {
            return invocation;
        }
        return null;
    }

    private MethodDescription getMethodDescription(JavaInfo javaInfo, Statement statement) {
        MethodInvocation invocation = this.getMethodInvocation(javaInfo, statement);
        if (invocation != null) {
            return javaInfo.getDescription().getMethod(AstNodeUtils.getMethodBinding(invocation));
        }
        return null;
    }

    private MethodOrder getMethodOrder(JavaInfo javaInfo, Statement statement) {
        MethodDescription description = this.getMethodDescription(javaInfo, statement);
        if (description != null) {
            return description.getOrder();
        }
        return null;
    }

    private boolean isRelatedStatement(JavaInfo javaInfo, Statement statement) {
        for (ASTNode node : javaInfo.getRelatedNodes()) {
            MethodInvocation invocation;
            Statement relatedStatement = AstNodeUtils.getEnclosingStatement(node);
            if (relatedStatement instanceof ReturnStatement || relatedStatement != statement || (invocation = javaInfo.getMethodInvocation(node)) != null && !javaInfo.shouldEvaluateInvocation(invocation)) continue;
            return true;
        }
        for (JavaInfo child : javaInfo.getChildrenJava()) {
            boolean hasGoodAssociation;
            Association association = child.getAssociation();
            boolean hasAssociation = association != null;
            boolean bl = hasGoodAssociation = hasAssociation && !(association instanceof UnknownAssociation);
            if (hasAssociation && !hasGoodAssociation || !this.isRelatedStatement(child, statement)) continue;
            return true;
        }
        return false;
    }

    private static final class TargetMethodInformation {
        boolean interesting = false;
        Statement lastStatement;

        private TargetMethodInformation() {
        }
    }
}

