"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    return (pugDoc, pos, options) => {
        const htmlPos = pugDoc.map.getGeneratedPosition(pos);
        if (!htmlPos) {
            return;
        }
        const htmlResult = htmlLs.doHover(pugDoc.map.embeddedDocument, htmlPos, pugDoc.htmlDocument, options);
        if (!htmlResult) {
            return;
        }
        return (0, language_service_1.transformHover)(htmlResult, htmlRange => pugDoc.map.getSourceRange(htmlRange));
    };
}
exports.register = register;
//# sourceMappingURL=hover.js.map