/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestNpmRun {
    protected ILaunchManager launchManager;

    @BeforeEach
    public void setUpLaunch() throws DebugException {
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.removeAllLaunches();
    }

    private void removeAllLaunches() throws DebugException {
        ILaunch[] iLaunchArray = this.launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            launch.terminate();
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n3 = iDebugTargetArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDebugTarget debugTarget = iDebugTargetArray[n4];
                debugTarget.terminate();
                launch.removeDebugTarget(debugTarget);
                ++n4;
            }
            iDebugTargetArray = launch.getProcesses();
            n3 = iDebugTargetArray.length;
            n4 = 0;
            while (n4 < n3) {
                IDebugTarget process = iDebugTargetArray[n4];
                process.terminate();
                ++n4;
            }
            ++n2;
        }
    }

    @AfterEach
    public void tearDownLaunch() throws DebugException {
        this.removeAllLaunches();
    }

    @Test
    public void testNpmRunEnvVariables() throws Exception {
        IProject project = Utils.provisionTestProject("envtest");
        IFile projectFile = project.getFile("package.json");
        ILaunchConfigurationWorkingCopy launchConfig = this.launchManager.getLaunchConfigurationType("org.eclipse.wildwebdeveloper.launchConfiguration.NPMLaunch").newInstance((IContainer)ResourcesPlugin.getWorkspace().getRoot(), "npm.envtest");
        launchConfig.setAttribute("program", projectFile.getLocation().toOSString());
        launchConfig.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", project.getLocation().toOSString());
        launchConfig.setAttribute("runtimeArgs", "run envtest");
        launchConfig.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Map.of("ENVTEST_ENVIRONMENT_VARIABLE", "ENVTEST_VARIABLE_VALUE}"));
        launchConfig.setAttribute("org.eclipse.debug.core.capture_output", true);
        ILaunch launch = launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
        while (!launch.isTerminated()) {
            DisplayHelper.sleep((Display)Display.getDefault(), (long)50L);
        }
        File envtestLogFile = new File(project.getLocation().toOSString(), "envtest.dump");
        Assertions.assertTrue((envtestLogFile.exists() && envtestLogFile.canRead() ? 1 : 0) != 0, (String)"Env variable test result dump file is not created");
        String content = new BufferedReader(new FileReader(envtestLogFile)).lines().collect(Collectors.joining("\n"));
        Assertions.assertTrue((content.contains("ENVTEST_ENVIRONMENT_VARIABLE") && content.contains("ENVTEST_VARIABLE_VALUE") ? 1 : 0) != 0, (String)"Env variable aren't not passed to subprocess");
    }
}

